/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "rfdesense/RfDesenseTxTestTd.h"

#include <algorithm>
#include <iterator>
#include <stdexcept>

#include "em.h"
#include "rfdesense/RfDesenseTxTestBase.h"
#include "util/log_extra.h"

#undef LOG_TAG
#define LOG_TAG "EM_RfDesenseTxTestTd"
const int RfDesenseTxTestTd::INDEX_BAND = 0;
const int RfDesenseTxTestTd::INDEX_CHANNEL = 1;
const int RfDesenseTxTestTd::INDEX_POWER = 2;
std::string RfDesenseTxTestTd::band = "";
std::string RfDesenseTxTestTd::channel= "";
std::string RfDesenseTxTestTd::power= "";
const std::vector<std::string> RfDesenseTxTestTd::tdscdma_band_values = {"1","6"};
const std::vector<std::vector<std::string>> RfDesenseTxTestTd::tdscdma_limits = {
            {"10087","10054","10121","10054","10121","24","10","24"},
            {"9500","9404","9596","9404","9596","24","10","24"}};
const std::vector<std::string> RfDesenseTxTestTd::wcdma_band_values = {"1","2","3","4","5","6","7","8","9","10","11","12","13","14","19","20","21","22"};
const std::vector<std::vector<std::string>> RfDesenseTxTestTd::wcdma_limits = {
            {"9750","9612","9888","9612","9888","23","-55","24"},
            {"9262","9262","9538","12","287","23","-55","24"},
            {"937","937","1288","937","1288","23","-55","24"},
            {"1312","1312","1513","1662","1862","23","-55","24"},
            {"4132","4132","4233","782","862","23","-55","24"},
            {"4162","4162","4188","812","837","23","-55","24"},
            {"2012","2012","2338","2362","2687","23","-55","24"},
            {"2712","2712","2863","2712","2863","23","-55","24"},
            {"8762","8762","8912","8762","8912","23","-55","24"},
            {"2887","2887","3163","3187","3462","23","-55","24"},
            {"3487","3487","3562","3487","3562","23","-55","24"},
            {"3617","3617","3678","3707","3767","23","-55","24"},
            {"3792","3792","3818","3842","3867","23","-55","24"},
            {"3892","3892","3918","3942","3967","23","-55","24"},
            {"312","312","363","387","437","23","-55","24"},
            {"4287","4287","4413","4287","4413","23","-55","24"},
            {"462","462","512","462","512","23","-55","24"},
            {"4437","4437","4813","4437","4813","23","-55","24"}};
std::map<int, std::string> RfDesenseTxTestTd::tdscdam_values = {{INDEX_BAND, "1"},{INDEX_CHANNEL, "10087"},{INDEX_POWER, "24"}};
std::map<int, std::string> RfDesenseTxTestTd::wcdma_values = {{INDEX_BAND, "1"},{INDEX_CHANNEL, "9750"},{INDEX_POWER, "23"}};

RfDesenseTxTestTd::RfDesenseTxTestTd(int modemType) {
    this->modem_type = modemType;
    if(modem_type == utils::MODEM_TDSCDMA){
        band = tdscdam_values[INDEX_BAND];
        channel = tdscdam_values[INDEX_CHANNEL];
        power = tdscdam_values[INDEX_POWER];
    } else if(modem_type == utils::MODEM_WCDMA) {
        band = wcdma_values[INDEX_BAND];
        channel = wcdma_values[INDEX_CHANNEL];
        power = wcdma_values[INDEX_POWER];
    }
}

RfDesenseTxTestTd::~RfDesenseTxTestTd() {
    // TODO Auto-generated destructor stub
}

std::string RfDesenseTxTestTd::modemTypeToString(int type) {
    switch(modem_type){
        case utils::MODEM_TDSCDMA:
            return "TDSCDMA";
        case utils::MODEM_WCDMA:
            return "MODEM_WCDMA";
        default:
            return "UNKNOWN";
    }
}

std::string RfDesenseTxTestTd::get_command() {
    std::string command = "AT+ERFTX=0,0," + band + "," + channel + "," + power;
    LOG_D(LOG_TAG, "GSM command: %s", command.c_str());
    return command;
}

std::string RfDesenseTxTestTd::get_band(){
    return band;
}

std::string RfDesenseTxTestTd::get_power(){
    return power;
}

bool RfDesenseTxTestTd::check_channel(int index, std::string channel) {
    std::string s;
    std::vector<std::vector<std::string>> limits;
    if(modem_type == utils::MODEM_TDSCDMA){
        limits = tdscdma_limits;
    } else if(modem_type == utils::MODEM_WCDMA) {
        limits = wcdma_limits;
    } else {
        s = utils::format("check_channel(): modem type (%s) isn't right", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_channel(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }

    if(index >= limits.size()) {
        s = utils::format("check_channel,index(%d) is invalid", index);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_channel,index(%d) is invalid", index);
        return false;
    }
    int value = -1;
    try {
        value = std::stoi(channel);
    } catch (std::invalid_argument &err) {
        s = utils::format("check_channel,channel(%s) is invalid, reason: %s", channel.c_str(), err.what());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_channel,channel(%s) is invalid, reason: %s", channel.c_str(), err.what());
        return false;
    }
    step = 1;
    std::vector<std::string> limit = limits[index];
    min = std::stoi(limit[RfDesenseTxTestBase::CHANNEL_MIN]);
    max =  std::stoi(limit[RfDesenseTxTestBase::CHANNEL_MAX]);
    min2 =  std::stoi(limit[RfDesenseTxTestBase::CHANNEL_MIN2]);
    max2 =  std::stoi(limit[RfDesenseTxTestBase::CHANNEL_MAX2]);
    if ((value < min || value > max) && (value < min2 || value > max2)) {
        s = utils::format("check_channel,channel(%s) is invalid, range is [%d, %d] or [%d, %d]" , channel.c_str(), min, max, min2, max2);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_channel,channel(%s) is invalid, range is [%d, %d] or [%d, %d]" , channel.c_str(), min, max, min2, max2);
        return false;
    }
    return true;
}

bool RfDesenseTxTestTd::check_power(int index ,std::string power) {
    std::string s;
    std::vector<std::vector<std::string>> limits;
    if(modem_type == utils::MODEM_TDSCDMA){
        limits = tdscdma_limits;
    } else if(modem_type == utils::MODEM_WCDMA) {
        limits = wcdma_limits;
    } else {
        s = utils::format("check_power(): modem type (%s) isn't right", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_power(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }
    if(index >= limits.size()) {
        s = utils::format("check_power,index(%d) is invalid", index);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_power,index(%d) is invalid", index);
        return false;
    }
    int value = -1;
    try {
        value = std::stoi(power);
    } catch (std::invalid_argument &err) {
        s = utils::format("check_power,power(%s) is invalid, reason: %s", power.c_str(), err.what());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_power,power(%s) is invalid, reason: %s", power.c_str(), err.what());
        return false;
    }
    step = 1;
    std::vector<std::string> limit = limits[index];
    min = std::stoi(limit[RfDesenseTxTestBase::POWER_MIN]);
    max =  std::stoi(limit[RfDesenseTxTestBase::POWER_MAX]);
    if (value < min || value > max) {
        s = utils::format("check_power,power(%s) is invalid, range is [%d, %d]" , power.c_str(), min, max);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_power,power(%s) is invalid, range is [%d, %d]" , power.c_str(), min, max);
        return false;
    }
    if (step != 1 && (value - min) % step != 0) {
        return false;
    }
    return true;
}

void RfDesenseTxTestTd::show_default() {
    std::string temp;
    if(modem_type == utils::MODEM_TDSCDMA){
        int band_index = utils::find_index(tdscdma_band_values, band);
        temp = "TDSCDMA parameters: Band: " + std::string(rfdesense_tdscdma_band[band_index].name) +
            ", Channel(ARFCN): " + channel + ", Power Level(dBm): " + power;
    } else if(modem_type == utils::MODEM_WCDMA) {
        int band_index = utils::find_index(wcdma_band_values, band);
        temp = "WCDMA parameters: Band: " + std::string(rfdesense_wcdma_band[band_index].name) +
            ", Channel(ARFCN): " + channel + ", Power Level(dBm): " + power;
    }
    if(!temp.empty()) {
        emResultNotifyWithDone(temp);
    } else {
        em_result_notify_fail("show_default");
        LOG_D(LOG_TAG, "temp is null ");
    }
}

bool RfDesenseTxTestTd::set_band(int value) {
    std::string s;
    std::vector<std::string> band_values;
    if(modem_type == utils::MODEM_TDSCDMA){
        band_values = tdscdma_band_values;
    } else if(modem_type == utils::MODEM_WCDMA) {
        band_values = wcdma_band_values;
    } else {
        s = utils::format("set_band(): modem type (%s) isn't right", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "set_band(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }
    if(value < 0 || value >= band_values.size()) {
        s = utils::format("set band(). value(%d) is out of range", value);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "set band(). value(%d) is out of range", value);
        return false;
    }
    band = band_values[value];
    if(modem_type == utils::MODEM_TDSCDMA){
        tdscdam_values[INDEX_BAND] = band;
    } else if(modem_type == utils::MODEM_WCDMA) {
        wcdma_values[INDEX_BAND] = band;
    }
    std::string temp;
    if(modem_type == utils::MODEM_TDSCDMA){
        em_result_notify_ok(std::string("band: ") + rfdesense_tdscdma_band[value].name);
    } else if(modem_type == utils::MODEM_WCDMA) {
        em_result_notify_ok(std::string("band: ") + rfdesense_wcdma_band[value].name);
    }
    return true;
}

bool RfDesenseTxTestTd::set_channel(std::string str) {
    std::string s;
    std::vector<std::string> band_values;
    if(modem_type == utils::MODEM_TDSCDMA){
        band_values = tdscdma_band_values;
    } else if(modem_type == utils::MODEM_WCDMA) {
        band_values = wcdma_band_values;
    } else {
        s = utils::format("set_channel(): modem type (%s) isn't right", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "set_channel(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }
    int index = utils::find_index(band_values, band);
    if(index < 0 ) {
        s = utils::format("set_channel(%s) isn't invalid", band.c_str());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "set_channel(%s) isn't invalid", band.c_str());
        return false;
    }
    if(!check_channel(index, str)) return false;
    channel = str;
    if(modem_type == utils::MODEM_TDSCDMA){
        tdscdam_values[INDEX_CHANNEL] = channel;
    } else if(modem_type == utils::MODEM_WCDMA) {
        wcdma_values[INDEX_CHANNEL] = channel;
    }
    em_result_notify_ok("channel: " + channel);
    return true;
}

bool RfDesenseTxTestTd::set_power(std::string str) {
    std::string s;
    std::vector<std::string> band_values;
    if(modem_type == utils::MODEM_TDSCDMA){
        band_values = tdscdma_band_values;
    } else if(modem_type == utils::MODEM_WCDMA) {
        band_values = wcdma_band_values;
    } else {
        s = utils::format("set_power(): modem type (%s) isn't right", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "set_power(): modem type (%s) isn't right", modemTypeToString(modem_type));
        return false;
    }
    int index = utils::find_index(band_values, band);
    if(index < 0 ) {
        s = utils::format("set_power(%s) isn't invalid", band.c_str());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "set_power(%s) isn't invalid", band.c_str());
        return false;
    }
    if(!check_power(index, str)) return false;
    power = str;
    if(modem_type == utils::MODEM_TDSCDMA){
        tdscdam_values[INDEX_POWER] = str;
    } else if(modem_type == utils::MODEM_WCDMA) {
        wcdma_values[INDEX_POWER] = str;
    }
    em_result_notify_ok("power: " + power);
    return true;
}

void RfDesenseTxTestTd::show_channel() {
    emResultNotifyWithDone("Channel(UarfCN): " + channel);
}

void RfDesenseTxTestTd::show_power() {
    emResultNotifyWithDone("Power Level(dBm): " + power);
}
