inherit externalsrc package

DESCRIPTION = "liblynq-protcl.so demo"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS += "platform-libs dbus liblynq-log mosquitto "
inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/common_src/lib/liblynq-protcl/"

TARGET_CC_ARCH += "${LDFLAGS}"
BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"
#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

FILES_${PN} = "${base_libdir}/*.so \
               ${base_bindir}\
               ${base_sbindir} \
               /etc/dbus-1/system.d/"

FILES_${PN}-dev = "/test \
                   ${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"


#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if [ "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" ]; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mhard-float -Wl,--hash-style=gnu -DTELEPHONYWARE"
	elif [ "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4" ]; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mhard-float -Wl,--hash-style=gnu -DTELEPHONYWARE"
	elif [ "${PACKAGE_ARCH}" = "cortexa53hf-neon-fp-armv8" ]; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mhard-float -Wl,--hash-style=gnu -DTELEPHONYWARE -mhard-float -mfpu=neon-fp-armv8 -mfloat-abi=hard -mcpu=cortex-a53 -mtune=cortex-a53"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu -DTELEPHONYWARE"
	fi
}

do_install () {
    oe_runmake install ROOT=${D}

    if [ -d "${WORKONSRC}" ] ; then
        install -d ${D}${includedir}/ftp
		install -d ${D}${includedir}/http
		install -d ${D}${includedir}/lynq_mqtt
		install -d ${D}${includedir}/dhcp
        cp -af ${S}/include/ftp ${D}${includedir}/ftp
		cp -af ${S}/include/http ${D}${includedir}/http
		cp -af ${S}/include/lynq_mqtt ${D}${includedir}/lynq_mqtt
		cp -af ${S}/include/dhcp ${D}${includedir}/dhcp
    fi 
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}
