#inherit externalsrc package
inherit externalsrc package systemd
DESCRIPTION = "lynq framework service"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS += "platform-libs audio-mixer-ctrl libvendor-ril libpal gstreamer1.0 glib-2.0 dtmf libapn dbus"
inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/common_src/framework/lynq-framework-service/src"

TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
#SYSTEMD_SERVICE_${PN} = "lynq_framework_service.service"
#FILES_${PN} += "${systemd_unitdir}/system/lynq_framework_service.service"
FILES_${PN} += "/system/etc/tele/ring ${bindir}"
#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	echo "lynq-framework-service PN ${PN}"
	echo "lynq-framework-service FILES_${PN} ${FILES_${PN}}"
	echo "lynq-framework-service D ${D}"
	echo "lynq-framework-service bindir ${bindir}"
	echo "lynq-framework-service ${D}${bindir}"
	echo "lynq-framework-service ${S}/lynq-framework-service"
	install -d ${D}${bindir}/
	install -m 0755 ${S}lynq-framework-service ${D}${bindir}/
	install -d ${D}${includedir}
	install ${S}/atci/ATCI.h ${D}${includedir}
#	cp -R ${S}/demoscript ${D}${bindir}/
	if test "${TARGET_PLATFORM}" = "mt2731"; then
		install -d ${D}/system/etc/tele/ring
		cp -R ${TOPDIR}/../src/lynq/framework/lynq-framework-service/ringtone/*.wav ${D}/system/etc/tele/ring
	fi
}
