inherit externalsrc package systemd

DESCRIPTION = "lynq_logrotate.service demo"
#LICENSE = "MediaTekProprietary"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS += "platform-libs  dbus glib-2.0 liblynq-log liblynq-fota"
inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/IC_src/mtk/framework/lynq-logrotate-service/src"

TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "lynq_logrotate.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_logrotate.service"

#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system/
		install -m 0644 ${B}/lynq_logrotate.service ${D}${systemd_unitdir}/system
	fi
	
	install -d ${D}${bindir}/
	install -m 0755 ${S}/lynq-logrotate-service ${D}${bindir}/
	install -d ${D}${includedir}
}

