#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <gio/gio.h>
#include <log/log.h>
#include <glib.h>
/*dongyu@2023.7.11 Add I2C read/write interface start*/
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>
/*dongyu@2023.7.11 Add I2C read/write interface end*/
#include "libdriver.h"
#define GPIO_SERVICE "gpio.lynq" /*well-known bus name */
#define GPIO_DATA_INTERFACE "gpio.lynq.Data" /*interface name*/
#define GPIO_DATA_PATH "/gpio/lynq/data" /*object name*/
#define LOG_TAG "GPIO_CONTROL"
static GMainLoop *loop = NULL;
static GDBusProxy *pProxy = NULL;
triggerCallback mtriggerCallback = NULL;;

void proxy_signals_on_signal (GDBusProxy  *proxy,
                              const gchar *sender_name,
                              const gchar *signal_name,
                              GVariant    *parameters,
                              gpointer     user_data)
{
    gint32 status;
    RLOGD("signal_name: %s\n", signal_name);
    g_variant_get (parameters,"(i)",&status);
    //RLOGD("listen singal ok,%d",status);
    if(mtriggerCallback){
        mtriggerCallback(signal_name,status);
    }
    else
    {
        RLOGE("mbroadcastcallback NULL");
    }
    printf("trigger status is %d\n",status);
}

BOOL registerClientSignalHandler(GDBusProxy *proxy)
{
    gulong signal_handler_id;
    signal_handler_id = g_signal_connect(proxy, "g-signal",
                      G_CALLBACK (proxy_signals_on_signal), NULL);
    RLOGD("proxy is ready");
    if (signal_handler_id == 0) {
        RLOGD("listen singal fail!");
        return FALSE;
    }
    return TRUE;
}
void registerTriggerCallback(triggerCallback callback)
{
    if (NULL != callback){
        //memcpy(&mbroadcastcallback, callback, sizeof(broadcastCallback));
        mtriggerCallback = callback;
    }
    else{
        RLOGD("registerSignalCallback: parameter point is NULL");
    }
}
void *run(void* arg)
{
    
    /** start the main event loop which manages all available sources of events */
    g_main_loop_run(loop);
    return ((void*)0);
}

void disconnect_key(void)
{
    if(pProxy != NULL) {
        g_object_unref (pProxy);
    }
    if(loop != NULL) {
        g_main_loop_unref(loop);
    }
}
int thread_create(void)
{
    int err;
    pthread_t thr;

    err = pthread_create(&thr, NULL, run, NULL);
    if(0 != err){
            RLOGD("Can't create thread: %s\n", strerror(err));
    }
    else{       
            RLOGD("New thread created: %s\n", strerror(err));
    }

    return err;
}
int trigger_loop()
{
    g_main_loop_run(loop);
}

BOOL service_ready(void)
{
    gchar *owner_name = NULL;
    owner_name = g_dbus_proxy_get_name_owner((GDBusProxy*)pProxy);
    if(NULL != owner_name)
    {
        RLOGD("Owner Name: %s\n", owner_name);        
        g_free(owner_name);
        return TRUE;
    }
    else
    {   
        g_print("Owner Name is NULL.");     
        return FALSE;
    }
}

void register_key_info(void){
     GError *error = NULL;
     RLOGD("go!\n");	
        loop = g_main_loop_new(NULL, FALSE);

        pProxy = g_dbus_proxy_new_for_bus_sync (G_BUS_TYPE_SYSTEM,
                                         G_DBUS_PROXY_FLAGS_NONE,
                                         NULL, /* GDBusInterfaceInfo */
                                         GPIO_SERVICE,
                                         GPIO_DATA_PATH,
                                         GPIO_DATA_INTERFACE,
                                         NULL, /* GCancellable */
                                         &error);
    if (pProxy == NULL)
    {
      RLOGD ("Error creating proxy: %s\n", error->message);
      disconnect_key();
    }
    if (registerClientSignalHandler(pProxy)== FALSE){
      RLOGD ("register Error");
      disconnect_key();
    }
    while(service_ready() != TRUE);
    thread_create();
}

int lynq_set_gpio (char * mode,int gpio_numb,int param)
{
    GDBusConnection *c1;
    GVariant *result;
    GError *error;
    GMainLoop *loop;
    gint32  set_result = -1;
    g_type_init();
    loop = g_main_loop_new(NULL, FALSE);   /** create main loop, but do not start it.*/
    error = NULL;
    c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
    g_assert_no_error (error);
    error = NULL;
    g_assert (c1 != NULL);
    g_assert (!g_dbus_connection_is_closed (c1));
    result = g_dbus_connection_call_sync (c1,
                                        GPIO_SERVICE,  /* bus name */
                                        GPIO_DATA_PATH, /* object path */
                                        GPIO_DATA_INTERFACE,  /* interface name */
                                        "setGpio",                 /* method name */
                                        g_variant_new ("(sii)", mode,gpio_numb,param),  /* parameters */
                                         G_VARIANT_TYPE ("(i)"),                    /* return type */
                                        G_DBUS_CALL_FLAGS_NONE,
                                        -1,
                                        NULL,
                                        &error);
    g_assert_no_error (error);
    g_assert (result != NULL);
    g_variant_get(result, "(i)", &(set_result));
   // RLOGD("%s, %s, %d,result:%d", __FILE__, __FUNCTION__, __LINE__,set_result);
    g_variant_unref (result);
    //g_main_loop_run (loop);
    g_main_loop_unref (loop);
    return set_result;
}
/*
int set_gpio143(){
  int   result;
  result = set_gpio (GPIO_MODE,WIFI_LED_CONTROL,1);
  return result;
 // sprintf(output, "gpio set stauts %d\n",result);
 // printf("%s",output);
 // emResultNotify(output);
}*/
void lynq_get_gpio (int gpio_numb,char *response)
{
    GDBusConnection *c1;
    GError *error;
    GMainLoop *loop;
    //char output[2048] = {0};
    //gchar *response;
    GVariant *get;
    gsize n_elts=0;
    GVariantIter *iter;
    //guchar *response;
    gchar *get_res;
//	const char *p;
    g_type_init();
    loop = g_main_loop_new(NULL, FALSE);   /** create main loop, but do not start it.*/
    error = NULL;
    c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
    g_assert_no_error (error);
    error = NULL;
    g_assert (c1 != NULL);
    g_assert (!g_dbus_connection_is_closed (c1));
    error = NULL;
    get = g_dbus_connection_call_sync (c1,
                                        GPIO_SERVICE,  
                                        GPIO_DATA_PATH, 
                                        GPIO_DATA_INTERFACE,  
                                        "getGpio",                 
                                        g_variant_new ("(i)",gpio_numb), 
                                         G_VARIANT_TYPE ("(s)"),                     
                                        G_DBUS_CALL_FLAGS_NONE,
                                        -1,
                                        NULL,
                                        &error);
    g_assert_no_error (error);
    g_assert (get != NULL);
    g_variant_get (get, "(s)",&get_res);
    strcpy(response, get_res);
    g_variant_unref (get);
    RLOGD("get_gpio,%s",response);
    g_main_loop_unref (loop);
}
/*
void get_gpio143(){
  char output[1024] = {0};
  char output1[2048] = {0};
  get_gpio (WIFI_LED_CONTROL,output);
  printf("get_gpio143,%s\n",output);
 
}
*/

/*dongyu@2023.7.12 Add I2C read/write interface start*/
/*****************************************************************************************************
@file driver_control.c
@brief The lynq_i2c_read function is used to read data from an I2C device. It accepts four parameters:
        - dev_nodeoPath to the I2C device node
        - addroI2C device address
        - regoRegister address to be read
        - read_valueoRegister address data read
        - return: If successful, return 0; if unsuccessful, return -1
@author dongyu
@date 2023-7-12
@version V1.0
@copyright MobileTek
*****************************************************************************************************/
int lynq_i2c_read(char *dev_node, int addr, char reg, char *read_value)
{
    int file;
    char buf[1];

    if (dev_node == NULL)
    {
        RLOGD("lynq_i2c_read Invalid dev_node\n");
        return -1;
    }

    if ((file = open(dev_node, O_RDWR)) < 0)
    {
        RLOGD("Failed to open i2c bus\n");
        return -1;
    }

    if (ioctl(file, I2C_SLAVE, addr) < 0)
    {
        RLOGD("Failed to acquire bus access and/or talk to slave\n");
        close(file);
        return -1;
    }

    buf[0] = reg;
    if (write(file, buf, 1) != 1)
    {
        RLOGD("Failed to write to the i2c bus\n");
        close(file);
        return -1;
    }

    if (read(file, read_value, 1) != 1)
    {
        RLOGD("Failed to read from the i2c bus\n");
        close(file);
        return -1;
    }

    RLOGD("Read value: %02x\n", *read_value);

    close(file);

    return 0;
}

/*****************************************************************************************************
@file driver_control.c
@brief The lynq_i2c_write function is used to write data to an I2C device. It accepts four parameters:
        - dev_nodeoPath to the I2C device node
        - addroI2C device address
        - regoRegister address to be written
        - dataoData to be written
        - return: If successful, return 0; if unsuccessful, return -1
@author dongyu
@date 2023-7-12
@version V1.0
@copyright MobileTek
*****************************************************************************************************/
int lynq_i2c_write(char *dev_node, int addr, char reg, char data)
{
    int file;
    char buf[2];

    if (dev_node == NULL)
    {
        RLOGD("lynq_i2c_write Invalid dev_node\n");
        return -1;
    }

    if ((file = open(dev_node, O_RDWR)) < 0)
    {
        RLOGD("Failed to open i2c bus\n");
        return -1;
    }

    if (ioctl(file, I2C_SLAVE, addr) < 0)
    {
        RLOGD("Failed to acquire bus access and/or talk to slave\n");
        close(file);
        return -1;
    }

    buf[0] = reg;
    buf[1] = data;
    if (write(file, buf, 2) != 2)
    {
        RLOGD("Failed to write to the i2c bus\n");
        close(file);
        return -1;
    }

    RLOGD("Write value: %02x\n", data);

    close(file);

    return 0;
}
/*dongyu@2023.7.12 Add I2C read/write interface end*/

/*dongyu@2023.7.11 Configurable General Purpose Interface for GPIO Packages start*/
int lynq_getGpio_values(int gpio_numb, char* mode, char* dir, char* dout, char* drive)
{
    char command[100];
    char response[100] = {0};

    if (mode == NULL || dir == NULL || dout == NULL || drive == NULL)
    {
        RLOGD("lynq_getGpio_values pointers are NULL, returning -1\n");
        return -1;
    }

    if (gpio_numb >= 0 && gpio_numb <= 180)
    {
        sprintf(command, "echo start 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio");
        if(system(command) != 0)
        {
            RLOGD("0~180 Range command execution failure!\n");
            return -1;
        }
    }
    else if (gpio_numb > 180 && gpio_numb <= 234)
    {
        sprintf(command, "echo start 180 > /sys/devices/platform/10005000.pinctrl/mt_gpio");
        if(system(command) != 0)
        {
            RLOGD("180~234 Range command execution failure!\n");
            return -1;
        }
    }
    else
    {
        RLOGD("The gpio_numb parameter takes values in the range 0 ~ 234!\n");
        return -1;
    }

    sprintf(command, "cat /sys/devices/platform/10005000.pinctrl/mt_gpio | grep -E \"^%03d\"", gpio_numb);
    FILE* fp = popen(command, "r");
    if (fp == NULL)
    {
        RLOGD("Failed to open pipe!\n");
        return -1;
    }
    fgets(response, 100, fp);
    pclose(fp);

    if (strlen(response) < 10)
    {
        RLOGD("Response is either empty or shorter than expected!\n");
        return -1;
    }
    *mode = response[4];
    *dir = response[5];
    *dout = response[6];
    *drive = response[9];

    return 0;
}

static int lynq_setGpio_execution(const char *state, int gpio_numb, int param)
{
    char command[100];
    sprintf(command, "echo %s %d %d >/sys/devices/platform/10005000.pinctrl/mt_gpio", state, gpio_numb, param);
    int result = system(command);
    if (result != 0)
    {
        RLOGD("Failed to execute command: %s\n", command);
        return -1;
    }
    return 0;
}

int lynq_setGpio_values(const char *state, int gpio_numb, int param)
{
    int result;
    char mode, dir, dout, drive;
    if (state == NULL)
    {
        RLOGD("lynq_setGpio_values pointers are NULL, returning -1\n");
        return -1;
    }

    lynq_getGpio_values(gpio_numb, &mode, &dir, &dout, &drive);

    if ((strcmp(state, "mode") == 0 || strcmp(state, "driving") == 0) && \
                    (gpio_numb >= 0 && gpio_numb <= 234) && (param >= 0 && param <= 7))
    {
        result = lynq_setGpio_execution(state, gpio_numb, param);
        if (result != 0)
        {
            return result;
        }
    }
    else if ((strcmp(state, "dir") == 0 || strcmp(state, "out") == 0) && \
                    (gpio_numb >= 0 && gpio_numb <= 234) && (param >= 0 && param <= 1) && mode == '0')
    {
        result = lynq_setGpio_execution(state, gpio_numb, param);
        if (result != 0)
        {
            return result;
        }
    }
    else
    {
        RLOGD("The parameter you entered is invalid!\n");
        return -1;
    }

    return 0;
}
/*dongyu@2023.7.11 Configurable General Purpose Interface for GPIO Packages end*/
