#ifndef LYNQ_GNSS_H
#define LYNQ_GNSS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "gpshal.h"
#include "hal2mnl_interface.h"
#define DEV "/dev/ttyGS3"
typedef enum{
    LYNQ_MODE_GPS_GLONASS = 0,
    LYNQ_MODE_GPS_BEIDOU,
    LYNQ_MODE_GPS_GLONASS_BEIDOU,
    LYNQ_MODE_GPS,
    LYNQ_MODE_BEIDOU,
    LYNQ_MODE_GLONASS,
    LYNQ_MODE_GPS_GLONASS_BEIDOU_GALILEO,
    LYNQ_MODE_GPS_GALILEO,
    LYNQ_MODE_GPS_GLONASS_GALILEO,
    LYNQ_MODE_GPS_GALILEO_ONLY,
    LYNQ_MODE_GPS_GLONASS_BEIDOU_GALILEO_NAVIC,
    LYNQ_MODE_GNSS_END
}LYNQ_GNSS_MODE_CONFIGURATION;

typedef enum{
    LYNQ_SWITCH_DISABLE = 0,
    LYNQ_SWITCH_ENABLE
}LYNQ_CONF_SWITCH;

typedef struct {
    GpsLocation legacyLocation;

    float           horizontalAccuracyMeters;

    /**
    * Represents expected vertical position accuracy in meters
    * (68% confidence).
    */
    float           verticalAccuracyMeters;

    /**
    * Represents expected speed accuracy in meter per seconds
    * (68% confidence).
    */
    float           speedAccuracyMetersPerSecond;

    /**
    * Represents expected bearing accuracy in degrees
    * (68% confidence).
    */
    float           bearingAccuracyDegrees;
} lynq_GpsLocation_ext;

typedef void (*gps_location_callback_ext)(lynq_GpsLocation_ext* location);

// typedef void (* gps_status_callback)(GpsStatus* status);

// typedef void (* gps_nmea_callback)(GpsUtcTime timestamp, const char* nmea, int length);

// typedef pthread_t (* gps_create_thread)(const char* name, void (*start)(void *), void* arg);

//typedef void (*gnss_measurement_ext_callback) (GnssData_ext* data);


typedef struct
{
    size_t size;
    gps_location_callback_ext lynq_location_cb;
    gps_status_callback lynq_status_cb;
    gps_nmea_callback lynq_nmea_cb;
    gps_create_thread lynq_create_thread_cb;
}lynq_gnss_cb;

typedef struct 
{
    size_t size;
    gnss_measurement_ext_callback lynq_measurement_callback;
}lynq_raw_gnss_cbs;

typedef void ( *lynq_atsvc_incb )(const char *input,const int length);
typedef void ( *lynq_atsvc_outcb )(char *output,int out_size,int type);
lynq_atsvc_incb lynq_register_gnss(lynq_atsvc_outcb out_cb);
lynq_atsvc_outcb atsvc_gnss_outcb;

int lynq_gnss_init(void);

int lynq_gnss_deinit(void);

int lynq_gnss_callback_reg(lynq_gnss_cb* callbacks);

int lynq_gnss_start(void);

int lynq_gnss_stop(void);

int lynq_gnss_inject_time(GpsUtcTime time, int64_t timeReference, int uncertainty);

int lynq_gnss_inject_location(double latitude,double longitude,float  accuracy);

int lynq_gnss_delete_aiding_data(GpsAidingData flags);

int lynq_gnss_inject_fused_location(double latitude,double longitude,float accuracy);

int lynq_gnss_start_raw_meas_mode(lynq_raw_gnss_cbs* raw_gnss_cbs);

int lynq_gnss_stop_raw_meas_mode();

int lynq_gnss_set_start_mode(LYNQ_GNSS_MODE_CONFIGURATION start_mode);

int lynq_gnss_epo_switch(LYNQ_CONF_SWITCH switch_op);

int lynq_gnss_output_frequency_set(int frequency);

int lynq_agps_set_enabled(LYNQ_CONF_SWITCH agps_status);

int lynq_agps_get_enabled_status(int *status);

#ifdef __cplusplus
}
#endif

#endif