#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h>
#include <time.h>
#include <lynq-system-own.h>

void lynq_lpm_handler(int lpm_edge)
{
	FILE * fp = NULL;
	char buft[32] = {0};
	char * cmd="cat /sys/devices/platform/10005000.pinctrl/mt_gpio | grep 000: | cut -b 8";
	//printf("[%s][%d]cmd=[%s]\n",__FUNCTION__,__LINE__,cmd);	

	fp = popen (cmd, "r");
	if (fp) {
		if (fgets(buft, sizeof(buft), fp) != NULL) {		
			//printf("[%s][%d]%s\n",__FUNCTION__,__LINE__,buft);					
			strtok(buft, "\n");
			
		}
		pclose(fp);
	}
	//printf("[%s][%d]last_state %d\n",__FUNCTION__,__LINE__,last_state);
	if(atoi(buft)!=last_state){
		last_state=atoi(buft);
		lpm_edge=atoi(buft);
		printf("[%s][%d]lpm_edge=%d\n",__FUNCTION__,__LINE__,lpm_edge);
	}
}

int LYNQ_Lpm_Init (LYNQ_Lpm_Handler_T lynq_lpm_handler)
{
	LYNQ_Lpm_Handler=lynq_lpm_handler;
	return 0;
}
int LYNQ_Lpm_Deinit (void)
{
	LYNQ_Lpm_Handler=NULL;
	return 0;
}

void suspendOperatingSystem()
{
	system("killall -9 lynq-function-test");
	system("echo 7 | emdlogger_ctrl");
	system("/usr/bin/telephony &");
	system("sleep 5");
	system("sh /usr/bin/demoscript/DSDS/set_default_sim_all_except_data.sh 0");
	system("sh /usr/bin/demoscript/Network_API/RadioOn.sh 0");
	system("sh /usr/bin/demoscript/DSDS/set_default_sim_all_except_data.sh 1");
	system("sh /usr/bin/demoscript/Network_API/RadioOn.sh 0");
	system("echo mem > /sys/power/autosleep");
}

int LYNQ_Autosleep_Enable(int enable)
{
	if(enable){
		suspendOperatingSystem();
	}
	return 0;
}

int LYNQ_SLP_WakeLock_Lock(const char *name)
{
    char gyCmd[64] = {0};
	sprintf(gyCmd,"echo %s > /sys/power/wake_lock",name);
	system(gyCmd);
}

int LYNQ_SLP_WakeLock_Unlock(const char *name)
{
    char gyCmd[64] = {0};
	sprintf(gyCmd,"echo %s > /sys/power/wake_unlock",name);
	system(gyCmd);	
}

void LYNQ_Power_Mode(char *power_mode)
{
    char gyCmd[64] = {0};
	sprintf(gyCmd,"sh /etc/powerscript/power_mode_own %s",power_mode);
	system(gyCmd);
}

void LYNQ_Power_Down(int mode)
{
	if(mode){
		system("reboot");
	}else{
		system("init 0");
	}
}

int LYNQ_Adc_Show(int adc_num)
{
	FILE * fp = NULL;
	char buft[32] = {0};
	char * cmd="cat /sys/bus/iio/devices/iio:device0/in_voltage0_BATADC_input";
	//printf("[%s][%d]cmd=[%s]\n",__FUNCTION__,__LINE__,cmd);	

	fp = popen (cmd, "r");
	if (fp) {
		if (fgets(buft, sizeof(buft), fp) != NULL) {		
			//printf("[%s][%d]%s\n",__FUNCTION__,__LINE__,buft);					
			strtok(buft, "\n");
			
		}
		pclose(fp);
	}
	return atoi(buft);
}


