#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include "liblynq-thermal/lynq_get_thermal.h"


char* lynq_read_version()
{
    return "THERMAL-V1.0";
}

int read_sys_info(char *sys_path, char *out_buf, int out_buf_len)
{
    int fd, ret;
    char buf[LYNQ_THM_PATH] = "";

    if (NULL == out_buf)
        return LYNQ_THM_ZONE_ERROR;

    if ((access(sys_path, F_OK)) == -1)
        return LYNQ_THM_ACCESS_ERROR;

    fd = open(sys_path, O_RDONLY);

    if (fd < 0)
    {
        printf("[%s-%d] open error!!!\n", __FUNCTION__, __LINE__);
        return LYNQ_THM_OPEN_ERROR;
    }

    ret = read(fd, buf, sizeof(buf));


    if(ret<0){
        close(fd);
        printf("[%s-%d] read error!!!\n", __FUNCTION__, __LINE__);
        return LYNQ_THM_READ_ERROR;
    }
    memcpy(out_buf, buf, out_buf_len);
    close(fd);

    return LYNQ_THM_OK;
}

int lynq_get_zone_tmp(ZONE_NUM num, int *temp)
{
    char tz_path[LYNQ_THM_PATH] = "";
    char buf[LYNQ_THM_PATH] = "";

    if(num < 0 || num > 19)
    {
        printf("[%s-%d] no such device,please reinput!!\n", __FUNCTION__, __LINE__);
        return  LYNQ_THM_ZONE_ERROR;
    }

    if(NULL == temp)
        return LYNQ_THM_ZONE_ERROR;
    
    sprintf(tz_path, "%s/%s%d/temp", TYPE_PATH_PRE, LYNQ_THM_ZONE_KEY, num);

    int ret = read_sys_info(tz_path, buf, LYNQ_THM_PATH);
    if(!ret)
    {
        if(strlen(buf))
            *temp = atoi(buf);
    }

    return ret;
}
