#!/bin/sh
for ((i=0; i < 10; i++)); do
        state=`systemctl is-active wg870_drv_insmod.service`
        if [ "$state" == "active" ]; then
                break
        elif [ "$state" != "activating" ]; then
                echo "to start now"
                systemctl start wg870_drv_insmod.service
        fi
        usleep 100000
done

if [ "$state" != "active" ]; then
        exit 1
fi

state=`wpa_cli -iwpa_wlan0_cmd -p/var/run/ ping`
if  [ "$state" != "PONG" ]; then
    for ((i=0; i < 50; i++)); do
        usleep 100000
        state=`wpa_cli -iwpa_wlan0_cmd -p/var/run/ ping`
        echo "$state"
        if [ "$state" == "PONG" ]; then
            service_started=1
            break
        fi
    done
else
        service_started=1
fi

if [ "$service_started" != "1" ];then
        exit 1
fi

state=`wpa_cli -iwpa_wlan0_cmd -p/var/run/ interface | grep -vE "Available|p2p-dev" | grep wlan0`
if [ $? != 0 ]; then
        state=`wpa_cli -iwpa_wlan0_cmd -p/var/run/ interface_add wlan0 /data/wifi/wg870/wpa_supplicant.conf nl80211`
        if [ "$state" != "OK" ]; then
                exit 2
        fi
		wpa_cli -iwpa_wlan0_cmd -p/var/run/ IFNAME=wlan0 disconnect
fi

state=`wpa_cli -iwpa_wlan0_cmd -p/var/run/ interface | grep -vE "Available|p2p-dev" | grep ap0`
if [ $? != 0 ]; then
		wpa_cli -iwpa_wlan0_cmd -p/var/run/ IFNAME=wlan0 DRIVER interface_create ap0
        state=`wpa_cli -iwpa_wlan0_cmd -p/var/run/ interface_add ap0 /data/wifi/wg870/wpa_supplicant_ap.conf nl80211`

        if [ "$state" != "OK" ]; then
                exit 3
        fi
        ifconfig ap0 down
fi


state=`wpa_cli -iwpa_wlan0_cmd -p/var/run/ IFNAME=wlan0 log_level INFO`
if [ "$state" != "OK" ]; then
        state=`wpa_cli -iwpa_wlan0_cmd -p/var/run/ IFNAME=wlan0 log_level INFO`

        if [ "$state" != "OK" ]; then
                echo "change wpa_cli log_level to INFO FAIL"
        fi
fi


exit 0

