//
// Created by DELL on 2021/7/12.
//
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include "nadif_hal_service.h"
#include "nadif_hal_service_types.h"
#include "lynq-conti-plugin-response.h"

#define ARRAY_SIZE(X) (sizeof(X)/sizeof(X[0]))

void parse_resp_imsi(int32_t sv_id, void *resp_data)
{
    NADIF_HAL_RESP_DATA *respData = (NADIF_HAL_RESP_DATA*)resp_data;
    printf("get imsi: ret=%d ,imsi=%s\n", respData->imsi_resp.result, respData->imsi_resp.imsi);
}

extern parse_resp_t parse_resp_tables[] =
{
        {NADIF_HAL_SVC_GET_IMSI, parse_resp_imsi},
        {0, NULL}
};

int list_param_for_sv_id(int32_t sv_id, void *data)
{
    for(int i= 0; i < ARRAY_SIZE(parse_resp_tables); i++)
    {
        if(sv_id == parse_resp_tables[i].sv_id)
        {
            parse_resp_tables[i].parse_response(sv_id, data);
        }
    }
}

