/*============================================================================= 
**     FileName: fota_test.c
**     Desc: about function test
**     Author: victor
**     Version: V1.0
**     LastChange: 2021-10-11
**     History: 
=============================================================================*/
#include "function_common.h"
#include <log/log.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "fota_test.h"
#include "fcntl.h"
#include "mtk_device_wrap.h"


#ifdef __cplusplus
extern "C" {
#endif
#include "include/iot_rock.h"
//#include "ftp/lynq_ftp.h"
#ifdef __cplusplus
}
#endif

//lynq_ftp_socker_info ftp_log_info;

#define UPDATA_ADDR "/tmp/fota.delta"
#define READ_BLOCK_SIZE 0x40000

int lynq_fota_md5_flag = -1;

#if 0
#define FLASH_DEV_DELTA       "/dev/disk/by-partlabel/delta"
#else
#define FLASH_DEV_DELTA       "/dev/mtd41"	
#endif

#if 0
int lynq_ftp_download_fota_package(char *string[])
{

    sprintf(ftp_log_info.sevname,"%s",string[1]);
    LYVERBLOG("[+UP]: sevname:%s\n",ftp_log_info.sevname);
    ftp_log_info.portnum = atoi(string[2]);
    LYVERBLOG("[+UP]: portnum:%d\n",ftp_log_info.portnum);

    sprintf(ftp_log_info.username,"%s",string[3]);
    sprintf(ftp_log_info.pw,"%s",string[4]);
    LYVERBLOG("[+UP]: username:%s\n",ftp_log_info.username);
    LYVERBLOG("[+UP]: pw:%s\n",ftp_log_info.pw);

    sprintf(ftp_log_info.is_pasv_mode,"%s",string[5]);
    sprintf(ftp_log_info.file_type,"%s",string[6]);
    sprintf(ftp_log_info.put_opt,"%s",string[7]);

    sprintf(ftp_log_info.getfilename_path,"%s",string[8]);
    sprintf(ftp_log_info.getfilename,"%s",string[9]);
    LYVERBLOG("[+UP]: getfilename_path:%s\n",ftp_log_info.getfilename_path);

    LYVERBLOG("[+UP]: Download the FTP data start\n");
    lynq_ftp_login(&ftp_log_info);
    lynq_ftp_download(&ftp_log_info);
    LYVERBLOG("[+UP]: Download the FTP data end\n");

    return 0;
}
#endif

int lynq_md5_fota_package(char *string[])
{
    int ret = 0;
    int fd_down,size,fd_target;
    char delta_data[READ_BLOCK_SIZE];
    char input_md5_data[64] = {0};
	
    sprintf(input_md5_data,"%s",string[0]);
//LYVERBLOG("[+UP]: input_md5_data:%s\n",input_md5_data);
    lynq_fota_md5_flag = lynq_md5_file_verfy(UPDATA_ADDR, input_md5_data);
    if(lynq_fota_md5_flag == 0)
    {
        LYVERBLOG("[+UP]: md5 fota package success\n");
    }
    else
    {
        LYVERBLOG("[+UP]: md5 fota package fail\n");
        return 1;
    }

    fd_down = open(UPDATA_ADDR,O_RDONLY);
    if (fd_down < 0) {
        LYVERBLOG("[+UP]: open source  error\n");
        return 1;
    }

    fd_target = mtk_device_wrap_open(FLASH_DEV_DELTA,O_RDWR);

    if (fd_target < 0) {
        close(fd_down);
        LYERRLOG("+[UA]: open target  error\n");
        return 1;
    } 

    LYVERBLOG("[+UP]: Get ftp data write to delta\n");
    while(( size = read(fd_down,delta_data,READ_BLOCK_SIZE))>0) {
        mtk_device_wrap_write(fd_target,delta_data,READ_BLOCK_SIZE);
        memset(delta_data,0,READ_BLOCK_SIZE);
    }

    LYVERBLOG("[+UP]: Store upgrade data to delta success\n");

    mtk_device_wrap_close(fd_target);
    close(fd_down);

    return 0;
}

int lynq_fota_func_test(void)
{
    int first_run = 1; 
    LYVERBLOG("+[UA]: Upgrade to start\n");
    if(lynq_fota_md5_flag == 0)
    {
        lynq_rock_main(first_run);
    }
    else
    {
        LYVERBLOG("+[UA]: MD5 verify fail\n");
        return 1;
    }
    LYVERBLOG("+[UA]: Upgrade to end\n");
    return 0;
}

int fota_test(char *api,char *string) 
{
    char *argv[100] = {0};
    parseParameters(string,argv);
    if(!strcmp(api, "download"))
    {
        if(!(strcmp(argv[0], "ftp")))
        {
  //       lynq_ftp_download_fota_package(argv);
        }
    }
    else if(!(strcmp(api, "md5")))
    {
        lynq_md5_fota_package(argv);
    }
    else if(!(strcmp(api, "upgrade")))
    {
        lynq_fota_func_test();
    }
    else
    {
        LYVERBLOG("+[fota][fota_test]: fota api error!!!\n");
    }
    return 0;
}


