#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

if [ "$1" == "-h" ]
then
    echo -E "Usage1:$0 <list_with_card> <list_without_card> :Set ecc number"
    echo -E "Usage2:$0 <list_with_card> : Set ecc number"
    echo -E "list_with_card, list_without_card: the format of ECC list string is: <category1>+<Eccnum1>,<category2>+<Eccnum2>,...,<categoryX>+<EccnumX>"
    exit 0
fi

if [ "$#" -gt 2 ]
then
    echo -E "parameter is invaild!"
    echo -E "Usage1:$0 <list_with_card> <list_without_card> :Set ecc number"
    echo -E "Usage2:$0 <list_with_card> : Set ecc number"
    echo -E "list_with_card, list_without_card: the format of ECC list string is: <category1>+<Eccnum1>,<category2>+<Eccnum2>,...,<categoryX>+<EccnumX>"
    exit 0
fi

if [ "$#" -eq 2 ]
then
    list_with_card=$1
    list_without_card=$2
    echo -E "RIL_REQUEST_SET_ECC_NUM ${list_with_card} ${list_without_card}"
elif [ "$#" -eq 1 ]
then
    list_with_card=$1
    echo -E "RIL_REQUEST_SET_ECC_NUM ${list_with_card}"
else
    echo -E "wrong parameters"
    exit 0
fi



#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

if [ "$#" -eq 2 ]
then
    echo "RIL_REQUEST_SET_ECC_NUM ${list_with_card} ${list_without_card}"  >&9
elif [ "$#" -eq 1 ]
then
    echo "RIL_REQUEST_SET_ECC_NUM ${list_with_card}"  >&9
else
    exit 0
fi

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
