#!/bin/bash
#Copyright (c) [Year], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.
help()
{
    echo -e "\033[34m"
    echo "Usage:$0 <fromServiceId> <toServiceId> <fromCodeScheme> <toCodeScheme> <selected>"
    echo "fromServiceId - toServiceId defines a range of CBM message identifiers whose value is 0x0000 - 0xFFFF as defined in TS 23.041 9.4.1.2.2 for GMS and 9.4.4.2.2 for UMTS. All other values can be treated as empty CBM message ID"
   echo "fromCodeScheme - toCodeScheme defines a range of CBM data coding schemes whose value is 0x00 - 0xFF as defined in TS 23.041 9.4.1.2.3 for GMS and 9.4.4.2.3 for UMTS. All other values can be treated as empty CBM data coding scheme."
   echo "selected 0 means message types specified in <fromServiceId, toServiceId> and <fromCodeScheme, toCodeScheme>are not accepted, while 1 means accepted."
   echo -e "\033[0m"
}

fail_tip()
{
    echo -e "\033[31m"
    echo -E "parameter is invaild!"
    echo -e "\033[0m"
    help
}
is_num()
{
    re='^[+-]?[0-9]+$'
    if ! [[ $1 =~ $re ]]
    then
        return 0
    else
        return 1
    fi
}


if [ "$1" == "-h" ]
then
    help
    exit 0
fi

if [ "$#" != 5 ]
then
    fail_tip
    exit 0
fi

for var in "$1" "$2" "$3" "$4" "$5"
do
    if is_num $var
    then
        fail_tip
        exit 0
    fi
done

echo -E "Which types of Cell Broadcast Message (CBM) are to be received by the ME: $1 $2 $3 $4 $5"

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG $1 $2 $3 $4 $5" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
