/* ********************************
 * Author:       Warren
 * License:      MobileTek
 *//** @file link.h*//*
 *
 ********************************/
#include "link.h"
#include <stdlib.h>
#include <string.h>
#include <log/log.h>
COND_NODE* createCondLinkHead()
{
    COND_NODE *head = (COND_NODE *)malloc(sizeof(COND_NODE));
    if(head==NULL)
    {
         return NULL;
    }
    memset(head,0,sizeof(COND_NODE));
    head->next=NULL;
    return head;
}

COND_NODE* initConditionLink()
{
    COND_NODE* head = createCondLinkHead();
    if(head==NULL)
    {
        return NULL;
    }
    return head;
}

COND_NODE * addCondLinkNode(COND_NODE *head,int32_t token,int index,pthread_cond_t cond)
{
    COND_NODE* Node = (COND_NODE *)malloc(sizeof(COND_NODE));
    memset(Node,0,sizeof(COND_NODE));
    if (Node)
    {
        Node->token = token;
        Node->cond = cond;
        Node->cond_index=index;
        Node->next = head;
        head = Node;
        //LYDBGLOG("[%s] node->token is %x,request is %d\n",__FUNCTION__,Node->token,Node->request);
    }
    else 
    {
        //LYDBGLOG("[%s] malloc Node failed!\n",__FUNCTION__);
        return head;
    }
    return head;
}

COND_NODE * DeleteLinkNode(int32_t token,COND_NODE *head)
{
    COND_NODE *p,*temp;
    p = head;
    if((p ==NULL)||(p->next==NULL))
    {
       // LYDBGLOG("[%s] lynqDeQueue head is NULL\n",__FUNCTION__);
        return 0;
        //return head;
    }
    //delete head note
    if(p->token == token)
    {
        temp=p->next;
        free(p);
        p =NULL;
       // LYDBGLOG("[%s] delete head note!!\n",__FUNCTION__);
        return temp;
        //return head;
    }
    //delete intermediate node
    do
    {
        temp = p;
        p=p->next;
        if(p->token==token)
        {
            temp->next=p->next;
            free(p);
            p=NULL;
           // LYDBGLOG("[%s] delete intermediate node!!\n",__FUNCTION__);
            return head;
        }
    }while(p->next->next!=NULL);
   // LYDBGLOG("[%s] Not find this token,token is %d!!\n",__FUNCTION__,token);
    return head;
}

COND_NODE * searchRequestinCondLink(int32_t token,COND_NODE *head)
{
    COND_NODE *p;
    p=head;
    if(p!=NULL)
    {
       do
       {
           if(p->token == token)
           {
               RLOGD("[searchRequestinCondLink] search  request %x success",token);
               return p;
           }
           p = p->next;
       } while (p != NULL);
    }
    return NULL;
}

