// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "rfdesense/RfDesenseTxTestNr.h"

#include <algorithm>
#include <iterator>
#include <stdexcept>

#include "rfdesense/RfDesenseTxTestBase.h"
#include "util/log_extra.h"
#include "em.h"

#undef LOG_TAG
#define LOG_TAG "EM_RfDesenseTxTestNr"

const int RfDesenseTxTestNr::INDEX_TX_MODE = 0;
const int RfDesenseTxTestNr::INDEX_BAND = 1;
const int RfDesenseTxTestNr::INDEX_BAND_WIDTH = 2;
const int RfDesenseTxTestNr::INDEX_FREQ = 3;
const int RfDesenseTxTestNr::INDEX_VRB_START = 4;
const int RfDesenseTxTestNr::INDEX_VRB_LENGTH = 5;
const int RfDesenseTxTestNr::INDEX_MCS = 6;
const int RfDesenseTxTestNr::INDEX_SCS = 7;
const int RfDesenseTxTestNr::INDEX_POWER = 8;
const int RfDesenseTxTestNr::INDEX_TDD_SLOT_CONFIG = 9;
const int RfDesenseTxTestNr::INDEX_ANT_MODE = 10;

std::string RfDesenseTxTestNr::mTxMode="";
int RfDesenseTxTestNr::mBandIdx=0;
std::string RfDesenseTxTestNr::mBand="";
int RfDesenseTxTestNr::mBandWidthIdx=0;
std::string RfDesenseTxTestNr::mBandWidth="";
std::string RfDesenseTxTestNr::mFreq="";
std::string RfDesenseTxTestNr::mVrbStart="";
std::string RfDesenseTxTestNr::mVrbLength="";
std::string RfDesenseTxTestNr::mMcs="";
std::string RfDesenseTxTestNr::mScs="";
std::string RfDesenseTxTestNr::mPower="";
std::string RfDesenseTxTestNr::mTddSlotConfig="";
int RfDesenseTxTestNr::mAntMode=0;

std::shared_ptr<RfDesenseTxTestNr> RfDesenseTxTestNr::m_instance;
std::mutex RfDesenseTxTestNr::mutex;

std::string RfDesenseTxTestNr::DEFAULT_TX_MODE = "0";//TONE
int RfDesenseTxTestNr::DEFAULT_BAND_IDX = 0;//BAND1
int RfDesenseTxTestNr::DEFAULT_BAND_WIDTH_IDX = 1;//10MHZ
std::string RfDesenseTxTestNr::DEFAULT_NR_FREQ = "1950000";
std::string RfDesenseTxTestNr::DEFAULT_VRB_START = "0";
std::string RfDesenseTxTestNr::DEFAULT_VRB_LENGTH = "1";
std::string RfDesenseTxTestNr::DEFAULT_MCS = "0";//DFT-S BPSK
std::string RfDesenseTxTestNr::DEFAULT_SCS_CONFIG = "0";//15KHZ
std::string RfDesenseTxTestNr::DEFAULT_POWER = "23";
std::string RfDesenseTxTestNr::DEFAULT_TDD_SLOT_CONFIG = "1";
int RfDesenseTxTestNr::DEFAULT_ANT_MODE= 0;

int VRB_START_MIN = 0;
int VRB_START_MAX = 272;
int VRB_LENGTH_MIN = 0;
int VRB_LENGTH_MAX = 273;
int POWER_MIN = -50;
int POWER_MAX_PUSCH = 23;
int POWER_MAX_TONE = 26;
int TDD_SLOT_CONFIG_MIN = 1;
int TDD_SLOT_CONFIG_MAX = 44;

const std::vector<std::string> RfDesenseTxTestNr::mBandMapping = {"1", "3", "7", "8", "20", "28", "38", "41", "77", "78", "79"};
const std::vector<std::string> RfDesenseTxTestNr::mBandWidthMapping = {"5000", "10000", "15000", "20000", "25000", "30000",
        "35000", "40000", "45000", "50000", "55000", "60000", "65000", "70000", "75000", "80000", "85000", "90000",
        "95000", "100000"};

RfDesenseTxTestNr::RfDesenseTxTestNr() {
    LOG_D(LOG_TAG, "RfDesenseTxTestNr()");

    mTxMode = DEFAULT_TX_MODE;
    mBandIdx = DEFAULT_BAND_IDX;
    mBand = mBandMapping[mBandIdx];
    mBandWidthIdx = DEFAULT_BAND_WIDTH_IDX;
    mBandWidth = mBandWidthMapping[mBandWidthIdx];
    mFreq = DEFAULT_NR_FREQ;
    mVrbStart = DEFAULT_VRB_START;
    mVrbLength = DEFAULT_VRB_LENGTH;
    mMcs = DEFAULT_MCS;
    mScs = DEFAULT_SCS_CONFIG;
    mPower = DEFAULT_POWER;
    mTddSlotConfig = DEFAULT_TDD_SLOT_CONFIG;
    mAntMode = DEFAULT_ANT_MODE;
}

void RfDesenseTxTestNr::show_default() {
    std::string str;
    std::string tx_mode_str(rfdesense_nr_tx_mode[std::stoi(mTxMode)].name);
    std::string band_str(rfdesense_nr_band[mBandIdx].name);
    std::string band_width_str(rfdesense_nr_bandwidth[mBandWidthIdx].name);
    std::string mcs_str(rfdesense_nr_mcs[std::stoi(mMcs)].name);
    std::string scs_str(rfdesense_nr_scs[std::stoi(mScs)].name);

    str = "\nTx mode: " + tx_mode_str
            + "\nBand: " + band_str
            + "\nUL Bandwidth: " + band_width_str
            + "\nUL Freq(1kHz): " + mFreq
            + "\nVRB Start(0~272): " + mVrbStart
            + "\nVRB Length(0~273): " + mVrbLength
            + "\nMCS: " + mcs_str
            + "\nSCS: " + scs_str
            + "\nPower Level(dBm)(-50-23): " + mPower
            + "\nTDD Slot Config: " + mTddSlotConfig;

    LOG_D(LOG_TAG, "show_default, str=%s", str.c_str());
    emResultNotifyWithDone(str);
}

RfDesenseTxTestNr::~RfDesenseTxTestNr() {
    // TODO Auto-generated destructor stub
}

std::shared_ptr<RfDesenseTxTestNr> RfDesenseTxTestNr::get_instance() {
    if(!m_instance) {
        mutex.lock();
        if(!m_instance) {
            m_instance = std::make_shared<RfDesenseTxTestNr>();
        }
        mutex.unlock();
    }
    return m_instance;
}

std::string RfDesenseTxTestNr::get_command() {
    std::string command;

    //Tone mode
    if (mTxMode == "0") {
        command = "AT+EGMC=1,\"NrForcedTx\",2,";
        command += mBand + "," + mFreq + "," + mPower;

    //PUSCH mode
    } else {
        command = "AT+EGMC=1,\"NrForcedTx\",1,";
        command += mBand + "," + mBandWidth + "," + mFreq + "," +
                mVrbStart + "," + mVrbLength + "," + mMcs + ","
                + mScs + "," + mPower + "," + mTddSlotConfig;
    }

    LOG_D(LOG_TAG, "NR command: %s\n", command.c_str());
    return command;
}

std::string RfDesenseTxTestNr::get_band() {
    return mBand;
}
std::string RfDesenseTxTestNr::get_power() {
    return mPower;
}

std::string RfDesenseTxTestNr::get_ant_mode() {
    std::string ant_str;
    int antStatustx = DEFAULT_ANT_MODE, antStatusrx = DEFAULT_ANT_MODE;

    if (mAntMode == 1)
        ant_str = utils::format("AT+EGMC=1,\"NrForceTxRx\",1,%d,%d,0", antStatustx, antStatusrx);
    else {
        ant_str = utils::format("AT+EGMC=1,\"NrForceTxRx\",0,,,0");
    }

    LOG_D(LOG_TAG, "ant_str: %s\n", ant_str.c_str());
    return ant_str;
}

bool RfDesenseTxTestNr::set_tx_mode(int mode){
    std::string s;
    if(mode !=0 && mode != 1) {
        s = utils::format("set_mode: mode(%d) is out of range", mode);
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    mTxMode = std::to_string(mode);
    // For PUSCH mode, we adjust parameter to pass tx
    if (mTxMode == "1") {
        mBandIdx = 7;
        mBand = mBandMapping[mBandIdx]; //Band 41
        mFreq = "2593010";
        LOG_D(LOG_TAG, "For PUSCH mode, adjust parameter band=%s, freq=%s", mBand.c_str(), mFreq.c_str());
    }

    std::string tx_mode_str(rfdesense_nr_tx_mode[std::stoi(mTxMode)].name);
    em_result_notify_ok("Tx mode=" + tx_mode_str);

    return true;
}

bool RfDesenseTxTestNr::set_band_idx(int bandidx){
    std::string s;

    if(bandidx < 0 || bandidx >= mBandMapping.size()){
        s = utils::format("set_band_idx: bandidx(%d) is out of range", bandidx);
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    mBandIdx = bandidx;
    mBand = mBandMapping[bandidx];

    em_result_notify_ok("mBand=" + mBand);
    return true;
}

bool RfDesenseTxTestNr::set_bandwith_idx(int bandwidthidx){
    std::string s;
    if (bandwidthidx < 0 || bandwidthidx >= mBandWidthMapping.size()) {
        s = utils::format("set_bandwith_idx value range is [%d, %d], input value is %d", 0, mBandWidthMapping.size(), bandwidthidx);
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    mBandWidthIdx = bandwidthidx;
    mBandWidth = mBandWidthMapping[mBandWidthIdx];

    em_result_notify_ok("mBandWidth=" + mBandWidth);
    return true;
}

bool RfDesenseTxTestNr::set_freq(std::string str){
    mFreq = str;
    em_result_notify_ok("freq=" + mFreq);
    return true;
}

bool RfDesenseTxTestNr::set_vrb_start(std::string start){
    std::string s;
    int value = -1;
    try {
        value = std::stoi(start);
    } catch (std::invalid_argument &err) {
        s = utils::format("set_vrb_start, vrb_start=%s is invalid, reason: %s", start.c_str(), err.what());
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    if (value < VRB_START_MIN || value > VRB_START_MAX) {
        s = utils::format("set_vrb_start value range is [%d, %d], input value is %d", VRB_START_MIN, VRB_START_MAX, value);
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    mVrbStart = start;
    em_result_notify_ok("vrb_start=" + mVrbStart);
    return true;
}

bool RfDesenseTxTestNr::set_vrb_length(std::string length){
    std::string s;
    int value = -1;
    try {
        value = std::stoi(length);
    } catch (std::invalid_argument &err) {
        s = utils::format("set_vrb_length, vrb_length=%s is invalid, reason: %s", length.c_str(), err.what());
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    if (value < VRB_LENGTH_MIN || value > VRB_LENGTH_MAX) {
        s = utils::format("set_vrb_length value range is [%d, %d], input value is %d", VRB_LENGTH_MIN, VRB_LENGTH_MAX, value);
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    mVrbLength = length;
    em_result_notify_ok("vrb_length=" + mVrbLength);
    return true;
}

bool RfDesenseTxTestNr::set_mcs(int mcs) {
    if (mcs < 0 || mcs > 8) {
        std::string s;
        s = utils::format("check_mcs value range is [%d, %d], input value is %d", 0, 8, mcs);
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    mMcs = std::to_string(mcs);
    em_result_notify_ok(std::string("mcs=") + rfdesense_nr_mcs[mcs].name);
    return true;
}

bool RfDesenseTxTestNr::set_scs(int scs) {
    if (scs < 0 || scs > 4) {
        std::string s;
        s = utils::format("check_mcs value range is [%d, %d], input value is %d", 0, 4, scs);
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    mScs = std::to_string(scs);
    em_result_notify_ok(std::string("scs=") + rfdesense_nr_scs[scs].name);
    return true;
}

bool RfDesenseTxTestNr::set_power(std::string power){
    std::string s;
    int value = -1, powerMax = POWER_MAX_TONE;

    powerMax = (mTxMode == "0")? POWER_MAX_TONE: POWER_MAX_PUSCH;

    try {
        value = std::stoi(power);
    } catch (std::invalid_argument &err) {
        s = utils::format("set_power,check_power(%s) is invalid, reason: %s", power.c_str(), err.what());
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    if (value < POWER_MIN || value > powerMax) {
        s = utils::format("check_power value range is [%d, %d], input value is %d", POWER_MIN, powerMax, value);
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    mPower = power;
    em_result_notify_ok("power=" + power);
    return true;
}

bool RfDesenseTxTestNr::set_tdd_slot_config(std::string config){
    std::string s;
    int value = -1;

    try {
        value = std::stoi(config);
    } catch (std::invalid_argument &err) {
        s = utils::format("set_tdd_slot_config, config(%s) is invalid, reason: %s", config.c_str(), err.what());
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    if(value < TDD_SLOT_CONFIG_MIN || value > TDD_SLOT_CONFIG_MAX){
        s = utils::format("check_tdd_config value range is [%d, %d], input value is %d", TDD_SLOT_CONFIG_MIN, TDD_SLOT_CONFIG_MAX, value);
        LOG_E(LOG_TAG, "%s", s.c_str());
        em_result_notify_fail(s);
        return false;
    }

    mTddSlotConfig = config;
    em_result_notify_ok("tdd_config=" + mTddSlotConfig);
    return true;
}

void RfDesenseTxTestNr::show_freq(){
    emResultNotifyWithDone("UL Freq(1kHZ): " + mFreq);
}

void RfDesenseTxTestNr::show_start(){
    emResultNotifyWithDone("VRB Start(0~272): " + mVrbStart);
}

void RfDesenseTxTestNr::show_length(){
    emResultNotifyWithDone("VRB Length(0~273): " + mVrbLength);
}

void RfDesenseTxTestNr::show_power(){
    emResultNotifyWithDone("Power Level(dBm)(-50~23): " + mPower);
}

void RfDesenseTxTestNr::show_config(){
    emResultNotifyWithDone("TDD slot config(1~44): " + mTddSlotConfig);
}

