/*============================================================================= 
**     FileName: lynq_common.h
**     Desc: lynq common
**     Author: Warren
**     Version: V1.0
**     LastChange: 2021-09-27 
**     History: 
**=============================================================================*/
#ifndef LYNQ_COMMON
#define LYNQ_COMMON
#include <stdlib.h>
#include <stdio.h>
#include <log/log.h>
#include <stdint.h>
#include <unistd.h>
#include "common.h"
#include <stateManager/stateManager.h>
#include <liblog/lynq_deflog.h>
# include <pthread.h>

#define LYNQ_GOTO_AT 1
/*telephony*/
#define LYNQ_GOTO_TELE_REQ 2
/*Other-for-User*/
#define LYNQ_GOTO_USER_REQ 3
/*audio/etc*/
#define LYNQ_GOTO_PLAT_REQ 4
/*rndis/*/
#define LYNQ_GOTO_RNDIS_REQ 5
/*factory*/
#define LYNQ_GOTO_FACTORY 6
/*info output*/
#define LYNQ_GOTO_LINFO_REQ 7
/*fota*/
#define LYNQ_GOTO_FOTA 8
/*TEMP*/
#define LYNQ_GOTO_TEMP 10

#define LYNQ_APN_LEN_MAX 100
#define LYNQ_APNTPYE_LEN_MAX 50
#define LYNQ_APN_CHANNEL_MAX 7//max is 7
#define LYNQ_AT_LEN_MAX 20
#define LYNQ_EVENT_WAIT_TIME_MAX 25 //m

#define LYNQ_VERSION 8500
#define LYNQ_REQUEST_CGMI (LYNQ_VERSION+1)
#define LYNQ_REQUEST_GMI (LYNQ_VERSION+2)
#define LYNQ_REQUEST_CGMM (LYNQ_VERSION +3)
#define LYNQ_REQUEST_GMM (LYNQ_VERSION +4)
#define LYNQ_REQUEST_ATD (LYNQ_VERSION +5)
#define LYNQ_REQUEST_CGCMOD (LYNQ_VERSION +6)
#define LYNQ_REQUEST_CGAUTO (LYNQ_VERSION +7)
#define LYNQ_REQUEST_CGACT (LYNQ_VERSION +8)
#define LYNQ_REQUEST_CGDCONT (LYNQ_VERSION +9)
#define LYNQ_REQUEST_LAPNACT (LYNQ_VERSION +10)
#define LYNQ_REQUEST_ELAPNACT (LYNQ_VERSION +11)
#define LYNQ_REQUEST_SWITCH_SIM (LYNQ_VERSION +12)
#define LYNQ_REQUEST_SEND_LOG_DATA (LYNQ_VERSION +13)
#define LYNQ_PLAT_LGMDS (LYNQ_VERSION +14)
#define LYNQ_REQUEST_RNDIS (LYNQ_VERSION +15)
#define LYNQ_REQUEST_FACTORY (LYNQ_VERSION +16)
#define LYNQ_REQUEST_LINFO (LYNQ_VERSION +17)
#define LYNQ_REQUEST_SCREEN_STATE (LYNQ_VERSION +18)
#define LYNQ_REQUEST_FOTA (LYNQ_VERSION +19)
#define LYNQ_REQUEST_INSIDE_VERSION (LYNQ_VERSION +20)
/*rita add*/
#define LYNQ_REQUEST_TEMP (LYNQ_VERSION +26)
#define LYNQ_REQUEST_APN (LYNQ_VERSION +27)
#define LYNQ_USER_REQUEST_GNSS (LYNQ_VERSION +100)
#define LYNQ_USER_REQUEST_OTHRE (LYNQ_VERSION +101)

typedef struct
{
    int cmdId;
    char * cmdName;
    int support;
}usb_at_transfer_t;

typedef struct
{
    int cmdId;
    char* rilRequest;
    char * cmdName;
    int (*fun)(int argc,char*argv[],char *rilReq,int uToken);
    void* (*ufun)(int argc,char *argv[],int uToken);
}usb_cmd_t;
typedef struct
{
    char apn[LYNQ_APN_LEN_MAX];
    char apntype[LYNQ_APNTPYE_LEN_MAX];
    char ifaceName[LYNQ_APNTPYE_LEN_MAX];
    int netId;
    int used;//0:not use,1:used.
    int apnstatus;//1:has enable;0:need disable.
    int pdpstate;//lei add for at+elapnact?  refer to T800 AT COMMANDS:+lapnact
    char address[LYNQ_APNTPYE_LEN_MAX];
}apn_table_t;
extern apn_table_t apn_table[LYNQ_APN_CHANNEL_MAX];
extern int apn_count;
extern char lynq_at[LYNQ_AT_LEN_MAX];
extern char mccmnc[8];
usb_at_transfer_t *lynqFindId(char *cmd);
usb_cmd_t * lynqFindUsbEvent(char *cmd);
int transferAtToRequest(char *cmd);
//argv[2]:0 send,1 list,2 get
int lynqParseUsbCommand(const char* cmd,char *argv[],char test[],char* parser_buf,int maxArgc);
void lynq_req_mccmnc(int uToken);
int routeCmd(int request);

int CGMI(int argc,char*argv[],char *rilReq, int uToken);
int dialACall(int argc,char*argv[],char *rilReq, int uToken);
int setupData(int argc,char*argv[],char *rilReq, int uToken);
int setupData_e(int argc,char*argv[],char *rilReq, int uToken);
int lynq_dsds_support(int argc,char*argv[],char *rilReq, int uToken);
int lynq_screen(int argc,char*argv[],char *rilReq, int uToken);
void* getMDstate(int argc,char*argv[],int uToken);
void* lynq_get_inside_version(int argc,char*argv[],int uToken);
int lynqATWaitWithTime(int time);//time(s)
void lynqAtRespWatingEvent();
int syncRespToUsb(int error_code);
void lynqInfo(char*argv[]);
int lynq_modify_apn_info(int argc,char*argv[],char *rilReq, int uToken);
void sendSignalApnChange();
int waitApnResult();
#endif
