//SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <alloca.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>

#include "common.h"
#include "network.h"

#undef LOG_TAG
#define LOG_TAG "DEMO_NETWORK"

//if signal_strength_printf isn't 0, open signal strength printf log.
//otherwise close.
int signal_strength_printf = 0;

int getSignalStrength (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if(1 != argc)
    {
        free(pRI);
        RLOGD("getSignalStrength param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int getOperator (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if (1 != argc) {
        free(pRI);
        RLOGD("getOperator param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int getNetworkSelectionMode (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if (1 != argc) {
        free(pRI);
        RLOGD("getNetworkSelectionMode param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int setNetworkSelectionModeAutomatic (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if (1 != argc) {
        free(pRI);
        RLOGD("setNetworkSelectionModeAutomatic param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int setNetworkSelectionModeManual(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;
    size_t pos =  p.dataPosition();

    writeStringToParcel(p, (const char *)argv[1]);

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int getAvailableNetworks (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if (1 != argc) {
        free(pRI);
        RLOGD("getAvailableNetworks param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int getVoiceRegistrationState (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if (1 != argc) {
        free(pRI);
        RLOGD("getVoiceRegistrationState param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int getDataRegistrationState (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if(1 != argc)
    {
        free(pRI);
        RLOGD("getVoiceRegistrationState param num should be 0");
        return -1;
    }

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int getImsRegistrationState (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if(1 != argc)
    {
        free(pRI);
        RLOGD("getImsRegistrationState param num should be 0");
        return -1;
    }

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int getPreferredNetworkType (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if(1 != argc)
    {
        free(pRI);
        RLOGD("getPreferredNetworkType param num should be 0");
        return 0;
        //TBD check;
    }

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int setPreferredNetworkType(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;
    size_t pos =  p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    update_preferred_network_type(atoi(argv[1]), socket_id);
    return 0;
}

int setLocationUpdates(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;
    size_t pos =  p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1])? 1 : 0);
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int getCellInfoList (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if (1 != argc) {
        free(pRI);
        RLOGD("getCellInfoList param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int setCellInfoListRate(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;
    size_t pos =  p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int getNeighboringCids (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if (1 != argc) {
        free(pRI);
        RLOGD("getNeighboringCids param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int setBandMode (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;
    size_t pos =  p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int queryAvailableBandMode (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if (1 != argc) {
        free(pRI);
        RLOGD("queryAvailableBandMode param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int setRadioPower (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;
    size_t pos =  p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1])? 1 : 0);
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

int getVoiceRadioTechnology (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;

    if (1 != argc) {
        free(pRI);
        RLOGD("getNeighboringCids param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}
//RIL_REQUEST_SET_RADIO_CAPABILITY
int setRadioCapability(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(7 != argc)
    {
        RLOGD("setRadioCapability param should be lost!");
        return 0;
    }
    android::Parcel p;
    size_t pos =  p.dataPosition();

    //version
    p.writeInt32(atoi(argv[1]));
    //session
    p.writeInt32(atoi(argv[2]));
    //phase
    p.writeInt32(atoi(argv[3]));
    //rat
    p.writeInt32(atoi(argv[4]));
    //logicalModemUuid
    writeStringToParcel(p,(const char *) argv[5]);
    //status
    p.writeInt32(atoi(argv[6]));

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}
//RIL_REQUEST_GET_RADIO_CAPABILITY
int getRadioCapability(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;

    if(1 != argc)
    {
        free(pRI);
        RLOGD("getRadioCapability param num should be 0");
        return 0;
    }

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int updateSignalPrintf(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    signal_strength_printf=atoi(argv[1]);
    printf("\nthe signal strength printf log will %s\n", signal_strength_printf == 0 ? "close" : "open");
    free(pRI);
    return 0;
}
//RIL_REQUEST_MODEM_POWEROFF
int setModemPowerOFF (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}
//RIL_REQUEST_MODEM_POWERON
int setModemPowerON (int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION
int supplyNetworkDepersonalization(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 2)
    {
        free(pRI);
        RLOGD("the peremeters numbers isn't right , so return");
        return -1;
    }
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(1);
    writeStringToParcel(p, argv[1]);
    p.setDataPosition(pos);

    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_REPORT_AIRPLANE_MODE
int setReportAirplaneMode(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 2) {
      RLOGW("parameter is invalid");
      free(pRI);
      return 0;
    }

    int state = (atoi(argv[1])!= 0) ? 1 : 0;

    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(state);
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_QUERY_AVAILABLE_NETWORKS_WITH_ACT
/**
* "data" is NULL
*"response" is const char ** that should be an arry of n*6, where n is the number of available networks
*
*((const char **)response)[n+0] is long alpha ONS or EONS
*((const char **)response)[n+1] is short alpha ONS or EONS
*((const char **)response)[n+2] is 5 or 6 digit numeric code
*((const char **)response)[n+3] is a string value of :
*  "unkonwn"
*  "available"
*  "current"
*  "forbidden"
*((const char **)response)[n+4] is lac
*((const char **)response)[n+5] is a string value of the Act: "2G", "3G", "4G"
**/
int getAvailableNetworksWithAct(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

