/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <string>
#include "WorldPhoneUtil.h"
#include "RatConfiguration.h"
#include "utils.h"
#include "log_extra.h"

#undef LOG_TAG
#define LOG_TAG "DEMO_WorldPhoneUtil"
const int WorldPhoneUtil::ACTIVE_MD_TYPE_UNKNOWN = 0;
const int WorldPhoneUtil::ACTIVE_MD_TYPE_WG   = 1;//3G(WCDMA)+2G(GSM)
const int WorldPhoneUtil::ACTIVE_MD_TYPE_TG   = 2;//3G(TDS-CDMA)+2G(GSM)
const int WorldPhoneUtil::ACTIVE_MD_TYPE_LWG  = 3;//4G(TDD-LTE+FDD-LTE)+3G(WCDMA)+2G(GSM)
const int WorldPhoneUtil::ACTIVE_MD_TYPE_LTG  = 4;//4G(TDD-LTE+FDD-LTE)+3G(TDS-CDMA)+2G(GSM)
    //4G(TDD-LTE+FDD-LTE)+3G(WCDMA+EVDO)+2G(GSM+CDMA2000)
const int WorldPhoneUtil::ACTIVE_MD_TYPE_LWCG = 5;
const int WorldPhoneUtil::ACTIVE_MD_TYPE_LtTG = 6;//4G(TDD-LTE)+3G(TDS-CDMA)+2G(GSM)
const int WorldPhoneUtil::ACTIVE_MD_TYPE_LfWG = 7;//4G(FDD-LTE)+3G(WCDMA)+2G(GSM)


const int WorldPhoneUtil::MD_TYPE_UNKNOWN = 0;
const int WorldPhoneUtil::MD_TYPE_WG      = 3;
const int WorldPhoneUtil::MD_TYPE_TG      = 4;
const int WorldPhoneUtil::MD_TYPE_LWG     = 5;
const int WorldPhoneUtil::MD_TYPE_LTG     = 6;
const int WorldPhoneUtil::MD_TYPE_FDD     = 100;
const int WorldPhoneUtil::MD_TYPE_TDD     = 101;

const int WorldPhoneUtil::MD_WORLD_MODE_UNKNOWN = 0;
const int WorldPhoneUtil::MD_WORLD_MODE_LTG     = 8;   //uLTG
const int WorldPhoneUtil::MD_WORLD_MODE_LWG     = 9;   //uLWG
const int WorldPhoneUtil::MD_WORLD_MODE_LWTG    = 10;  //uLWTG
const int WorldPhoneUtil::MD_WORLD_MODE_LWCG    = 11;  //uLWCG
const int WorldPhoneUtil::MD_WORLD_MODE_LWCTG   = 12;  //uLWTCG(Auto mode)
const int WorldPhoneUtil::MD_WORLD_MODE_LTTG    = 13;  //LtTG
const int WorldPhoneUtil::MD_WORLD_MODE_LFWG    = 14;  //LfWG
const int WorldPhoneUtil::MD_WORLD_MODE_LFWCG   = 15;  //uLfWCG
const int WorldPhoneUtil::MD_WORLD_MODE_LCTG    = 16;  //uLCTG
const int WorldPhoneUtil::MD_WORLD_MODE_LTCTG   = 17;  //uLtCTG
const int WorldPhoneUtil::MD_WORLD_MODE_LTWG    = 18;  //uLtWG
const int WorldPhoneUtil::MD_WORLD_MODE_LTWCG   = 19;  //uLTWCG
const int WorldPhoneUtil::MD_WORLD_MODE_LFTG    = 20;  //uLfTG
const int WorldPhoneUtil::MD_WORLD_MODE_LFCTG   = 21;  //uLfCTG

std::string WorldPhoneUtil::PROPERTY_RAT_CONFIG = "ro.boot.opt_ps1_rat";
std::string WorldPhoneUtil::PROPERTY_ACTIVE_MD = "vendor.ril.active.md";
std::string WorldPhoneUtil::WCDMA = "W";
std::string WorldPhoneUtil::TDSCDMA = "T";
std::string WorldPhoneUtil::CDMA = "C";
const int WorldPhoneUtil::UTRAN_DIVISION_DUPLEX_MODE_UNKNOWN = 0;
const int WorldPhoneUtil::UTRAN_DIVISION_DUPLEX_MODE_FDD = 1;
const int WorldPhoneUtil::UTRAN_DIVISION_DUPLEX_MODE_TDD = 2;

    // World mode result cause for EN.
const int WorldPhoneUtil::WORLD_MODE_RESULT_SUCCESS            = 100;
const int WorldPhoneUtil::WORLD_MODE_RESULT_ERROR              = 101;
const int WorldPhoneUtil::WORLD_MODE_RESULT_WM_ID_NOT_SUPPORT  = 102;

    /* bitmask */
    /* the defination must be sync with ratconfig.c */
const int WorldPhoneUtil::MASK_CDMA    = (1 << 5);
const int WorldPhoneUtil::MASK_LTEFDD  = (1 << 4);
const int WorldPhoneUtil::MASK_LTETDD  = (1 << 3);
const int WorldPhoneUtil::MASK_WCDMA   = (1 << 2);
const int WorldPhoneUtil::MASK_TDSCDMA = (1 << 1);
const int WorldPhoneUtil::MASK_GSM     = (1);

const int WorldPhoneUtil::MODEM_FDD = 1;
const int WorldPhoneUtil::MODEM_TD = 2;
const int WorldPhoneUtil::MODEM_NO3G = 3;

WorldPhoneUtil::WorldPhoneUtil() {
    // TODO Auto-generated constructor stub

}

WorldPhoneUtil::~WorldPhoneUtil() {
    // TODO Auto-generated destructor stub
}

bool WorldPhoneUtil::isWorldPhoneSupport() {
    return (RatConfiguration::isWcdmaSupported()
            && RatConfiguration::isTdscdmaSupported());
}

bool WorldPhoneUtil::isLteSupport() {
    return (RatConfiguration::isLteFddSupported()
            || RatConfiguration::isLteTddSupported());
}

bool WorldPhoneUtil::isWorldModeSupport() {
    //bool is_support = (utils::mtk_property_get_int32("ro.vendor.mtk_md_world_mode_support", 0) == 1);
    //return is_support;
    return true;
}

int WorldPhoneUtil::get3GDivisionDuplexMode() {
    int duplexMode = UTRAN_DIVISION_DUPLEX_MODE_UNKNOWN;
    int activeMdType = getActiveModemType();

    switch (activeMdType) {
        case ACTIVE_MD_TYPE_WG:
        case ACTIVE_MD_TYPE_LWG:
        case ACTIVE_MD_TYPE_LWCG:
        case ACTIVE_MD_TYPE_LfWG:
            duplexMode = UTRAN_DIVISION_DUPLEX_MODE_FDD;
            break;
        case ACTIVE_MD_TYPE_TG:
        case ACTIVE_MD_TYPE_LTG:
        case ACTIVE_MD_TYPE_LtTG:
            duplexMode = UTRAN_DIVISION_DUPLEX_MODE_TDD;
            break;
        default:
            duplexMode = UTRAN_DIVISION_DUPLEX_MODE_UNKNOWN;
        break;
    }
    LOG_D(LOG_TAG, "get3GDivisionDuplexMode= %d", duplexMode);
    return duplexMode;
}

int WorldPhoneUtil::getActiveModemType() {
    int modemType = 0;
    int activeMdType = ACTIVE_MD_TYPE_UNKNOWN;
    int activeMode = -1;
    if (!isWorldModeSupport()) {
        modemType = getWorldModeId();
        switch (modemType) {
            case MD_TYPE_WG:
                activeMdType = ACTIVE_MD_TYPE_WG;
                break;
            case MD_TYPE_TG:
                activeMdType = ACTIVE_MD_TYPE_TG;
                break;
            case MD_TYPE_LWG:
                activeMdType = ACTIVE_MD_TYPE_LWG;
                break;
            case MD_TYPE_LTG:
                activeMdType = ACTIVE_MD_TYPE_LTG;
                break;
            default:
                activeMdType = ACTIVE_MD_TYPE_UNKNOWN;
            break;
        }
    } else {
        modemType = getWorldModeId();
        activeMode = utils::mtk_property_get_int32("vendor.ril.nw.worldmode.activemode",ACTIVE_MD_TYPE_UNKNOWN);
        switch (modemType) {
            case MD_WORLD_MODE_LTG:
            case MD_WORLD_MODE_LCTG:
            case MD_WORLD_MODE_LFTG:
            case MD_WORLD_MODE_LFCTG:
                activeMdType = ACTIVE_MD_TYPE_LTG;
                break;
            case MD_WORLD_MODE_LWG:
            case MD_WORLD_MODE_LTWG:
                activeMdType = ACTIVE_MD_TYPE_LWG;
                break;
            case MD_WORLD_MODE_LWTG:
            case MD_WORLD_MODE_LWCTG:
                if (activeMode > 0){
                    if (activeMode == 1){
                        //FDD mode
                        activeMdType = ACTIVE_MD_TYPE_LWG;
                    } else if (activeMode == 2){
                        //TDD mode
                        activeMdType = ACTIVE_MD_TYPE_LTG;
                    }
                }
                break;
            case MD_WORLD_MODE_LWCG:
            case MD_WORLD_MODE_LFWCG:
            case MD_WORLD_MODE_LTWCG:
                activeMdType = ACTIVE_MD_TYPE_LWCG;
                break;
            case MD_WORLD_MODE_LTTG:
            case MD_WORLD_MODE_LTCTG:
                activeMdType = ACTIVE_MD_TYPE_LtTG;
                break;
            case MD_WORLD_MODE_LFWG:
                activeMdType = ACTIVE_MD_TYPE_LfWG;
                break;
            default:
                activeMdType = ACTIVE_MD_TYPE_UNKNOWN;
            break;
        }
    }
    LOG_D(LOG_TAG, "getActiveModemType=%d activeMode=%d",activeMdType , activeMode);
    return activeMdType;
}

int WorldPhoneUtil::getWorldModeId() {
    int modemType = 0;
    modemType = utils::mtk_property_get_int32(PROPERTY_ACTIVE_MD.c_str(),MD_TYPE_UNKNOWN);
    return modemType;
}

int WorldPhoneUtil::getModemType() {
    int mode = MODEM_NO3G;
    int mask = get3GDivisionDuplexMode();
    if ((1 == mask) || (2 == mask)) {
        mode = mask;
    }
    LOG_D(LOG_TAG, "mode = %d", mode);
    return mode;
}
