/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef INDIVIDUALRECORD_H_
#define INDIVIDUALRECORD_H_

#include <cstdint>
#include <string>
#include <vector>
#include <memory>
#include <atomic>

#include "IndividualSubRecord.h"

//p23, table14
class IndividualRecord {
public:
    IndividualRecord();
    virtual ~IndividualRecord();
    int decodeAllSubRecords();
    std::string encodeAllSubRecords(std::uint8_t sst, std::uint8_t rst,std::uint8_t srt, std::string msd);
    std::uint8_t getEvfe() const;
    void setEvfe(std::uint8_t evfe);
    std::uint32_t getEvid() const;
    void setEvid(std::uint32_t evid);
    std::uint8_t getObfe() const;
    void setObfe(std::uint8_t obfe);
    std::uint32_t getOid() const;
    void setOid(std::uint32_t oid);
    //const std::vector<std::uint8_t>& getRd() const;
    //void setRd(const std::vector<std::uint8_t> &rd);
    std::uint8_t getRfl() const;
    void setRfl(std::uint8_t rfl);
    std::uint16_t getRl() const;
    void setRl(std::uint16_t rl);
    std::uint16_t getRn() const;
    void setRn(std::uint16_t rn);
    std::uint8_t getRpp() const;
    void setRpp(std::uint8_t rpp);
    std::uint8_t getRsod() const;
    void setRsod(std::uint8_t rsod);
    std::uint8_t getSsod() const;
    void setSsod(std::uint8_t ssod);
    std::uint32_t getTm() const;
    void setTm(std::uint32_t tm);
    std::uint8_t getTmfe() const;
    void setTmfe(std::uint8_t tmfe);
    const std::string& getRd() const;
    void setRd(const std::string rd);
    std::uint8_t getRst() const;
    void setRst(std::uint8_t rst);
    std::uint8_t getSst() const;
    void setSst(std::uint8_t sst);
    bool isIncludedCmdCode(std::uint16_t cmd);
    std::string encodeAck(std::uint8_t sst_value, std::uint8_t rst_value, std::uint8_t subType, std::uint16_t cmd, bool ack);
    bool isNeedNewSms();
    int getEcallReqPara();
private:
    std::uint16_t RL; //little-endian;
    std::uint16_t RN; //little-endian;

    std::uint8_t RFL;
    std::uint8_t SSOD;
    std::uint8_t RSOD;
    std::uint8_t RPP;
    std::uint8_t TMFE;
    std::uint8_t EVFE;
    std::uint8_t OBFE;

    std::uint32_t OID; //O, depends: OBFE
    std::uint32_t EVID; //O,depends: EVFE
    std::uint32_t TM; //O, depends: TMFE
    std::uint8_t SST;
    std::uint8_t RST;
    //std::vector<std::uint8_t> RD; // depends RL, 3-65498 byte;
    std::string RD; // depends RL, 3-65498 byte;

    std::vector<std::shared_ptr<IndividualSubRecord>> deSubRecords;
    std::shared_ptr<IndividualSubRecord> enSubRecords;

    static std::atomic_uint16_t initRecNum;
    static std::uint16_t generalRecodeNum();
};

#endif /* INDIVIDUALRECORD_H_ */
