/*============================================================================= 
#     FileName: lynq_sim.cpp
#     Desc: about SIMAPI
#     Author: mobiletek 
#     Version: V1.0
#     LastChange: 2020-07-29 
#     History: 
# If you need to use any API under lynq_sim, you must first call the init_sim() function to initialize these functions.
=============================================================================*/
#ifndef __LYNQ_SIM__
#define __LYNQ_SIM__
#include <sys/types.h>
#include "lib_tele.h"
#define MAX_IMSI 20
#ifdef __cplusplus
extern "C" {
#endif
typedef struct
{
    lynqBase base;
    RIL_CardState card_status;
    RIL_AppType  card_type;
    RIL_PinState pin_state;
}simStatus;
typedef struct
{
    lynqBase base;
    char imsi[MAX_IMSI];
    //char *imsi;
}simImsi;
int init_sim();
int lynq_get_sim_status(simStatus *msg);
int lynq_get_imsi(simImsi * msg);

#ifdef __cplusplus
}
#endif

#endif

