#include "ftp_manager.h"
#include "common.h"
#include <unistd.h>
#include <stdio.h>
#include <string.h>


enum FTP_ID { 
	FTP_LOGIN_ID = 0, 
	FTP_GET_ID, 
	FTP_UP_ID, 
	FTP_QUIT_ID, 
	FTP_LS_ID,
	FTP_CD_ID = 5,
	FTP_MKDIR_ID, 
	FTP_RMD_ID,
	FTP_DELETE_ID
};



FTP_MAG_S ftp_manager[] = {
	{FTP_LOGIN_ID, "login", lynq_ftp_login},
	{FTP_GET_ID, "get", lynq_ftp_download},
	{FTP_UP_ID, "up", lynq_ftp_up},
	{FTP_QUIT_ID, "quit", lynq_ftp_quit},
	{FTP_LS_ID, "ls", lynq_ftp_ls},
	{FTP_CD_ID, "cd", lynq_ftp_cd},
	{FTP_MKDIR_ID, "mkdir", lynq_ftp_creat_mkd},
	{FTP_RMD_ID, "rmd", lynq_ftp_delete_mkd},
	{FTP_DELETE_ID, "delete", lynq_ftp_deletefile_mkd},
};


static int ftp_init = 0;
static struct list_head lynq_ftp_list;
static FTP_LIST_LINK_S* ftp_slider;
static lynq_ftp_socker_info ftp_cmd = {0};

FTP_MAG_S *ftp_mag_ret = NULL;


void *ftp_handler(void * list)
{
	FTP_LIST_LINK_S* pos_list  = (FTP_LIST_LINK_S *)list;
	int ftp_login = 0; 
	char cmpybuf[64] = "";
	
	while(1)
	{
		if (pos_list->data.modify_thread != 1 && pos_list->data.add_thread != 1)
			continue;
		
		//LYDBGLOG("[%s-%d] rita thread_id %lu start.\n",__FUNCTION__, __LINE__, pthread_self());

		pos_list->data.add_thread = 0;
		pos_list->data.modify_thread = 0;
#if 0
		LYDBGLOG("**************************ftp_handler debug************************************\n");
		LYDBGLOG("[%s %d] ---------- > pos_list->data.session = %d\n", __FUNCTION__, __LINE__, pos_list->data.session);
		LYDBGLOG("[%s %d] ---------- > pos_list->data.sevname = %s\n", __FUNCTION__, __LINE__, pos_list->data.sevname);
		LYDBGLOG("[%s %d] ---------- > pos_list->data.username = %s\n", __FUNCTION__, __LINE__, pos_list->data.username);
		LYDBGLOG("[%s %d] ---------- > pos_list->data.pw = %s\n", __FUNCTION__, __LINE__, pos_list->data.pw);
		LYDBGLOG("[%s %d] ---------- > pos_list->data.is_pasv_mode = %s\n", __FUNCTION__, __LINE__, pos_list->data.is_pasv_mode);
		LYDBGLOG("[%s %d] ---------- > pos_list->data.action = %s\n", __FUNCTION__, __LINE__, pos_list->data.action);
		LYDBGLOG("[%s %d] ---------- > pos_list->data.id = %d\n", __FUNCTION__, __LINE__, pos_list->data.id);
		LYDBGLOG("**************************debug end************************************\n");
#endif
		if (ftp_login == 0 && FTP_QUIT_ID != pos_list->data.id) {
			ftp_login = lynq_ftp_login(&pos_list->data);
			LYDBGLOG("[%s-%d] rita test for debuging ftp,ftp_login = %d\n", __FUNCTION__, __LINE__, ftp_login);
			if(!ftp_login)//rita add @2021.7.19 for error connect,reconnect failure
			{
				LYDBGLOG("[%s-%d] rita test for debuging ftp,error!!!\n", __FUNCTION__, __LINE__);
				list_del((struct list_head* )pos_list);
			}
		} 
		else {
			LYDBGLOG("[%s-%d] +ftplogin: Device logged in before !!!\n", __FUNCTION__, __LINE__);
		}

		ftp_mag_ret->ftp_action(&pos_list->data);
	}
}


int ftp_act_handler(thread_pool_t *pool)
{
	FTP_LIST_LINK_S* tmp_list = (FTP_LIST_LINK_S *)ftp_slider;
	struct list_head* slider = NULL;
	FTP_LIST_LINK_S* tmp = NULL;
	if(tmp == NULL)
	{
		tmp = (FTP_LIST_LINK_S*)malloc(sizeof(FTP_LIST_LINK_S));
		if(tmp == NULL)
		{
			LYVERBLOG("+[thhandle]: error num = %d\n", ERR_MALLOCVALID);
			return ERR_MALLOCVALID;
		}
	}
	memset(tmp, 0, sizeof(FTP_LIST_LINK_S));
	LYDBGLOG("[%s-%d] ftp_cmd.id = %d\n", __FUNCTION__, __LINE__, ftp_cmd.id);

	switch(ftp_cmd.id)
	{
		case FTP_LOGIN_ID:
		case FTP_GET_ID:
		case FTP_UP_ID:
		case FTP_QUIT_ID:
		case FTP_LS_ID:
		case FTP_CD_ID:
		case FTP_MKDIR_ID:
		case FTP_RMD_ID:
		case FTP_DELETE_ID:
			if (tmp_list == NULL ) {
				LYDBGLOG("[%s-%d] first time\n", __FUNCTION__, __LINE__);
				tmp->data = ftp_cmd;
				tmp->data.add_thread = 1;
				list_add_tail(&tmp->list, &lynq_ftp_list);
					
				ftp_list_locate();
				if (!threadpool_add(pool, ftp_handler, (void *)ftp_slider)) {
					LYDBGLOG("add error!!!\n");
					LYVERBLOG("+[thhandle]: error num = %d\n", ERR_INVOKE);
					return ERR_INVOKE;
				}
			}
			else {
				LYDBGLOG("[%s-%d] change ftp_cmd.file_type = %s \n",__func__, __LINE__, ftp_cmd.file_type);
				LYDBGLOG("[%s-%d] change ftp_cmd.is_pasv_mode = %s \n",__func__, __LINE__, ftp_cmd.is_pasv_mode);
				LYDBGLOG("[%s-%d] tmp_list->data.control_sockfd = %d \n", __FUNCTION__, __LINE__, tmp_list->data.control_sockfd);

				//	Save sockfd. If you don't save it, it will be overridden to 0, resulting in unable to connect
				ftp_cmd.control_sockfd = tmp_list->data.control_sockfd;
				tmp_list->data = ftp_cmd;
				tmp_list->data.modify_thread = 1;
			}

			break;
		default:
			LYDBGLOG("[%s-%d] cmd error \n", __FUNCTION__, __LINE__);
			LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);

			if (tmp != NULL)
				free(tmp);
			return ERR_CMDVALID;
	}

	tmp = NULL;
	return NO_ERROR;
}


FTP_MAG_S *ftp_manager_proc(const char *action)
{
    int type_num = sizeof(ftp_manager) / sizeof(FTP_MAG_S);
    int i = 0;
    for (i = 0; i < type_num; i++)
    {
        if (0 == strcmp(ftp_manager[i].action, action))
        {
			//LYDBGLOG("[%s-%d] action is ftp %s\n",  __FUNCTION__, __LINE__, ftp_manager[i].action);//rita add @2021.07.19 for debug description
            return &ftp_manager[i];
        }
    }
	//LYDBGLOG("[%s-%d] error action %s\n", __FUNCTION__, __LINE__, action);
	return NULL;
}


int ftp_param_verification(char result[][BUF_SIZE] , int line)
{

	for (int i = 0; i < line; i++) {
	        LYDBGLOG("[%s-%d]=======>rita,str[%d] = %s \n", __FUNCTION__, __LINE__, i, result[i]);
	}

	if (line < 3) {
		LYDBGLOG("[%s-%d] command error\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
		return ERR_CMDVALID;
	}


	memcpy(ftp_cmd.protocol, result[0], sizeof(ftp_cmd.protocol));//rita add @2021.07.19 for protocol type mismatch

	if(!atoi(result[2])) {
		LYDBGLOG("[%s %d] session error\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[thhandle]: error num = %d\n", ERR_SESSIONVALID);
		return ERR_SESSIONVALID;
	}
	ftp_cmd.session = atoi(result[2]);
	memcpy(ftp_cmd.action, result[1], sizeof(ftp_cmd.action));//rita add @2021.07.19 for action type mismatch
	strcpy(ftp_cmd.sevname, result[3]);

	ftp_cmd.portnum = atoi(result[4]);
	strcpy(ftp_cmd.username, result[5]);
	strcpy(ftp_cmd.pw, result[6]);
	
	//LYDBGLOG("[%s-%d] sevname=%s, portnum=%d, username=%s,pw=%s \n", __FUNCTION__, __LINE__, ftp_cmd.sevname, ftp_cmd.portnum, ftp_cmd.username, ftp_cmd.pw);

	ftp_mag_ret = ftp_manager_proc(ftp_cmd.action);	

	
	ftp_cmd.id = ftp_mag_ret->id;

	LYDBGLOG("[%s-%d] ftp_cmd.id = %d\n", __FUNCTION__, __LINE__, ftp_cmd.id);

	switch (ftp_mag_ret->id)
	{
		case FTP_LOGIN_ID:
			if(line != 7)
			{
				LYDBGLOG("[%s-%d] command error\n", __FUNCTION__, __LINE__);
				LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
				return ERR_CMDVALID;
			}
			break;
			
		case FTP_GET_ID:
			if(line != 12)
			{
				LYDBGLOG("[%s-%d] command error\n", __FUNCTION__, __LINE__);
				LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
				return ERR_CMDVALID;
			}			
			strcpy(ftp_cmd.getfilename_path, result[9]);
			strcpy(ftp_cmd.getfilename, result[10]);
		case FTP_UP_ID:
			if (line != 12) {
				LYDBGLOG("[%s-%d] command error id = %d\n", __FUNCTION__, __LINE__, ftp_mag_ret->id);
				LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
				return ERR_CMDVALID;
			}
			strcpy(ftp_cmd.file_type, result[7]);
			strcpy(ftp_cmd.is_pasv_mode, result[8]);
			strcpy(ftp_cmd.put_opt , result[11]);

			if (ftp_mag_ret->id == FTP_UP_ID) {
				strcpy(ftp_cmd.putfilename_path, result[9]);
				strcpy(ftp_cmd.putfilename, result[10]);
			}
			break;

		case FTP_QUIT_ID:
			if (line < 8) {
				LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);				
				return ERR_CMDVALID;
			}
			break;

		case FTP_LS_ID:
			if (line !=9) {
				LYDBGLOG("[%s-%d] command error id = %d\n", __FUNCTION__, __LINE__, ftp_mag_ret->id);
				LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
				return ERR_CMDVALID;
			}

			strcpy(ftp_cmd.dir, result[8]);//rita add @2021.7.19 for ls bug
			strcpy(ftp_cmd.is_pasv_mode, result[7]);
			break;
		case FTP_CD_ID:
		case FTP_MKDIR_ID:
		case FTP_RMD_ID:
		case FTP_DELETE_ID:
			if (line != 8) {
				LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
				return ERR_CMDVALID;
			}
			strcpy(ftp_cmd.del_mkr_filename, result[7]);
			//strcpy(ftp_cmd.is_pasv_mode, result[7]);
			break;

		default:
			LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
			break;
			
	}

	return NO_ERROR;

}


int ftp_list_locate()
{
	struct list_head* slider = NULL;
	ftp_slider = NULL;
	list_for_each(slider, &lynq_ftp_list) {
		ftp_slider = (FTP_LIST_LINK_S*)slider;
		LYDBGLOG("[%s-%d]  =============START====================== \n", __func__, __LINE__);
		LYDBGLOG("[%s-%d]  protocol : %s \n", __FUNCTION__, __LINE__, ftp_slider->data.protocol);
		LYDBGLOG("[%s-%d]  session : %d \n", __FUNCTION__, __LINE__, ftp_slider->data.session);
		LYDBGLOG("[%s-%d]  action : %s \n", __FUNCTION__, __LINE__, ftp_slider->data.action);
		LYDBGLOG("[%s-%d]  port : %d \n", __FUNCTION__, __LINE__, ftp_slider->data.portnum);
		LYDBGLOG("[%s-%d]  sevname : %s \n", __FUNCTION__, __LINE__, ftp_slider->data.sevname);
		LYDBGLOG("[%s-%d]  username : %s \n", __FUNCTION__, __LINE__, ftp_slider->data.username);
		LYDBGLOG("[%s-%d]  pw : %s \n", __FUNCTION__, __LINE__, ftp_slider->data.pw);
		LYDBGLOG("[%s-%d]  index : %d \n", __FUNCTION__, __LINE__, ftp_slider->data.index);
		LYDBGLOG("[%s-%d]  ==============END===================== \n", __func__, __LINE__);

		if (!strcmp(ftp_slider->data.protocol, ftp_cmd.protocol) && ftp_slider->data.session == ftp_cmd.session) {
			//LYDBGLOG("[%s-%d] Node found\n", __FUNCTION__, __LINE__);
			if (strcmp(ftp_slider->data.sevname, ftp_cmd.sevname) != 0 || strcmp(ftp_slider->data.username, ftp_cmd.username) != 0 || strcmp(ftp_slider->data.pw, ftp_cmd.pw) != 0 || ftp_slider->data.portnum != ftp_cmd.portnum) {
				LYDBGLOG("[%s-%d] sevname  error\n", __FUNCTION__, __LINE__);
				LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
				return ERR_CMDVALID;
			}	
			LYDBGLOG("[%s-%d]=======> Node found\n", __FUNCTION__, __LINE__);
			return NO_ERROR;
		}		
	}
	ftp_slider = NULL;

	LYDBGLOG("[%s-%d] Not found\n", __FUNCTION__, __LINE__);
	return NO_ERROR;
}


void ftp_list_init()
{
	if (ftp_init == 0) {
		INIT_LIST_HEAD(&lynq_ftp_list);
		ftp_init = 1;
	}

}
