#inherit externalsrc package
inherit externalsrc package systemd
DESCRIPTION = "lynq ril service"
LICENSE = "MobileTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"
DEPENDS += "platform-libs audio-mixer-ctrl libvendor-ril  libpal gstreamer1.0 glib-2.0 dtmf libapn dbus liblynq-log liblynq-systime liblynq-uci liblynq-thermal liblynq-fota liblynq-protcl liblynq-shm liblynq-codec"
inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/common_src/framework/lynq-ril-service/src"

TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "lynq_ril_service.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_ril_service.service"
FILES_${PN} += "/system/etc/tele/ring ${bindir}"
#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	echo "lynq-ril-service PN ${PN}"
	echo "lynq-ril-service FILES_${PN} ${FILES_${PN}}"
	echo "lynq-ril-service D ${D}"
	echo "lynq-ril-service bindir ${bindir}"
	echo "lynq-ril-service ${D}${bindir}"
	echo "lynq-ril-service ${S}/lynq-ril-service"
	install -d ${D}${bindir}/
	install -m 0755 ${S}lynq-ril-service ${D}${bindir}/
	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system/
		install -m 0644 ${B}/lynq_ril_service.service ${D}${systemd_unitdir}/system
	fi
#	install -d ${D}${includedir}
#	install ${S}/atci/ATCI.h ${D}${includedir}
#	cp -R ${S}/demoscript ${D}${bindir}/
	if test "${TARGET_PLATFORM}" = "mt2731"; then
		install -d ${D}/system/etc/tele/ring
		cp -R ${TOPDIR}/../src/lynq/framework/lynq-ril-service/ringtone/*.wav ${D}/system/etc/tele/ring
	fi
}
