#ifndef LYNQ_GNSSHAL_H
#define LYNQ_GNSSHAL_H

#ifdef __cplusplus
extern "C" {
#endif

#include<pthread.h>
#include "lynq_gnss.h"
#include "hardware/gps_mtk.h"
#include "hal2mnl_interface.h"
#include "gpshal.h"
#include "gps_mtk.h"

#define LYNQ_GNSS_MODE "GNSS_MODE"
#define LYNQ_DEBUG_STATUS "debug.dbg2file"
#define LYNQ_EPO_STATUS  "EPO_enabled"
#define LYNQ_OUTPUT_FREQUENCY  "fix_interval"

#define LYNQ_CONF_GPS_GLONASS "0"
#define LYNQ_CONF_GPS_BEIDOU "1"
#define LYNQ_CONF_GPS_GLONASS_BEIDOU "2"
#define LYNQ_CONF_GPS "3"
#define LYNQ_CONF_BEIDOU "4"
#define LYNQ_CONF_GLONASS "5"
#define LYNQ_CONF_GPS_GLONASS_BEIDOU_GALILEO "6"
#define LYNQ_CONF_GPS_GALILEO "7"
#define LYNQ_CONF_GPS_GLONASS_GALILEO "8"
#define LYNQ_CONF_GPS_GALILEO_ONLY "9"
#define LYNQ_CONF_GPS_GLONASS_BEIDOU_GALILEO_NAVIC "10"

#define LYNQ_CONFIG_DISABLE "0"
#define LYNQ_CONFIG_ENABLE "1"

#define LYNQ_MAX_FRREQUENCY 16

GpsCallbacks_ext* lynq__get_gps_callbacks(void);

GpsMeasurementCallbacks_ext* lynq_gnss_get_raw_callbacks(void);

lynq_gnss_cb* lynq_at_get__gnss_callbacks(void);

extern lynq_atsvc_outcb atsvc_gnss_outcb;
extern int at_gpsnmea_status;

typedef enum{
    LYNQ_ATCMD_TEST = 0,
    LYNQ_ATCMD_READ,
    LYNQ_ATCMD_WRITE
}LYNQ_ATCMD_TYPE;

#ifdef __cplusplus
}
#endif

#endif