#include <stdio.h>
#include "lynq_misc.h"
#include "log/log.h"

#undef LOG_TAG
#define LOG_TAG "MISC"

int lynq_get_security_boot_flag(int * enabled_flag)
{
    int value, ret;
    if (enabled_flag == NULL)
    {
        RLOGE("input param is null ptr");
        return -1;
    }
    *enabled_flag = 0;
    FILE *pfile=fopen("/proc/device-tree/chosen/atag,devinfo", "r");
    if (pfile == NULL)
    {
        RLOGE("open devinfo fail");
        return -1;
    }
    ret = fseek(pfile, 0x428, 0);
    if (ret != 0)
    {
        RLOGE("seek file fail");
        fclose(pfile);
        return -1;
    }
    ret = fread(&value, sizeof (value), 1, pfile);
    if (ret != 1)
    {
        RLOGE("read file fail");
        fclose(pfile);
        return -1;
    }
    fclose(pfile);

    // the third bit of 32bits at 0x428 (index start with 0?), 1 for enabled, 0 not enabled
    *enabled_flag = (value & 0x8) == 0 ? 0 : 1;
    return 0;
}
