#ifndef LIBLYNQ_RTK_H
#define LIBLYNQ_RTK_H


#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	lynq_rtk_log_info,
	lynq_rtk_log_warn,
	lynq_rtk_log_err
} lynq_rtk_log_level;

typedef struct
{
    unsigned char  bPosFlag;
    unsigned char  bTrackNo;
    unsigned char  bSatNo;

    unsigned char  bRtkFlag;
    double         fDiffAge;
    unsigned int   uGpsWeek;
    double         fWeekSeconds;
    double         fUTC;
    double         fLeapSeconds;

    double         fPosX;
    double         fPosY;
    double         fPosZ;
    float          fPosXDelta;
    float          fPosYDelta;
    float          fPosZDelta;

    double         fLat;
    double         fLong;
    double         fAlt;
    double         fHeightOfGeoid;
    float          fLatStd;
    float          fLongStd;
    float          fAltStd;

    double         fVelX;
    double         fVelY;
    double         fVelZ;
    float          fVelXDelta;
    float          fVelYDelta;
    float          fVelZDelta;

    float          fVelN;
    float          fVelE;
    float          fVelU;
    float          fVelNDelta;
    float          fVelEDelta;
    float          fVelUDelta;

    float          fHorSpeed;
    float          fHorSpeedDelta;

    float          fTrueHeading;
    float          fTrueHeadingDelta;

    float          fHeading2Ant;
    float          fHeading2AntDelta;

    float          fRangeRms;
    float          fPhaseRms;

    float  	       fHDOP;
    float 	       fPDOP;
    float          fVDOP;
    float          fCN0;

    double         fClkTime;

    int            iBaseStatus;
    int            iRtkStatus;
}lynq_rtk_result_info;

typedef void (*lynq_rtk_out_debuginfo)(const char * pBuff, const int length, const int ilevel);
typedef void (*lynq_rtk_out_postdata)(const unsigned char * pBuff, const int length);
typedef void (*lynq_rtk_out_basesdkstatus)(const int status);
typedef void (*lynq_rtk_out_status)(const int status);

typedef void (*lynq_rtk_out_result)(const lynq_rtk_result_info * prtk);
typedef void (*lynq_rtk_out_result_nmea)(const char * strnmea, const int length);

extern void lynq_rtk_lib_version(char * version);
extern void lynq_rtk_init();
extern void lynq_rtk_set_userinfo(const char *username,const char *pwd);
extern void lynq_rtk_set_deviceID(const char* device_id);
extern void lynq_rtk_result_cb_reg(lynq_rtk_out_result result_cb);
extern void lynq_rtk_result_nmea_cb_reg(lynq_rtk_out_result_nmea nmea_cb);
extern void lynq_rtk_config_log_reg(lynq_rtk_out_debuginfo pdebuginfo);
extern void lynq_rtk_config_post_reg(lynq_rtk_out_postdata ppostdata);
extern void lynq_rtk_base_sdkstatus(lynq_rtk_out_basesdkstatus psdkstatus);
extern void lynq_rtk_base_status(lynq_rtk_out_status pstatus);
extern void lynq_rtk_rove_addnmea(const unsigned char * pBuff, const int iBuffLen);
extern void lynq_rtk_rove_addrawmess(GnssData_ext* data);
extern void lynq_rtk_setserverIP(const char* server_ip);


#ifdef __cplusplus
}
#endif

#endif 