#!/bin/sh

if [ "$1" == "start" ]; then
	ifconfig ap0 192.168.15.1 netmask 255.255.255.240

	if [ $? != 0 ]; then
		exit 1
	fi
	mkdir -p /run/wg870/dnsmasq.d
	conf_file="/run/wg870/dnsmasq.conf"
	echo "port=0" > $conf_file
	echo "interface=ap0" >> $conf_file
	echo "listen-address=192.168.15.1" >> $conf_file
	echo "bind-interfaces"  >> $conf_file
	echo "localise-queries" >> $conf_file
        echo "no-ping" >> $conf_file
        echo "dhcp-authoritative" >> $conf_file
	echo "dhcp-range=192.168.15.2,192.168.15.14,255.255.255.240,1h"  >> $conf_file
	echo "dhcp-option=3,192.168.15.1"  >> $conf_file
	echo "dhcp-option=6,192.168.15.1,114.114.114.114"  >> $conf_file
	echo "dhcp-range=192.168.15.2,192.168.15.14,255.255.255.240,1h"  >> $conf_file
	echo "dhcp-leasefile=/run/wg870/ap0.lease" >> $conf_file
	ps -eo "%p %a" | grep "/usr/bin/dnsmasq -x /run/wg870/dnsmasq.pid" | grep -v grep 
	if [ $? != 0 ]; then
		/usr/bin/dnsmasq -x /run/wg870/dnsmasq.pid -7 /run/wg870/dnsmasq.d --local-service -C $conf_file -r /run/wg870 --dhcp-broadcast
	fi

elif [ "$1" == "stop" ]; then
	ps -eo "%p %a" | grep "/usr/bin/dnsmasq -x /run/wg870/dnsmasq.pid" | grep -v grep | awk '{print "kill "$1}' | sh
	ifconfig ap0 down
	if [ $? != 0 ]; then
		exit 1
	fi
else
	exit 2
fi

exit 0
