#include"format_change.h"
#include<log/log.h>


/*****************************************************************************
*   Prototype    : format_change
*   Description  : convert the incoming fixed format string into the corresponding alarm seconds
*   Input        : char *buffer ;  input format : 2022-04-23-15-30-00 ( Mon-Day-Hour-Min-Sec ) Or  1200 ( seconds )              
*   Output       : None
*   Return Value : -1: match error ; >0: set to wake up the devices after seconds
*
*****************************************************************************/
ssize_t format_change(char *buffer)
{
    time_t rawtime;
    time_t alarm_tamp;
    struct tm *info = NULL;
    struct tm *set_alarm = NULL;
    char *time_buff = NULL;

    char ebuff[256];
    regex_t reg_alm,reg_sec;
    char *pattern_setalm = "^20[0-9][0-9]-[01]?[1-9]-[0-3]?[0-9]-[0-2]?[0-9]-[0-5]?[0-9]-[0-5]?[0-9]$";//regular expression 1 ,  in order that match alarm time string eg:Mon-Day-Hour-Min-Sec 
    char *pattern_setsec = "^[1-9][0-9]*$";//regular expression 2 ,  in order that match seconds 
    int cflags = REG_EXTENDED | REG_ICASE | REG_NOSUB;//POSIX extend,not care up and low letters,not store result

    int ret;
    ssize_t sec;

    ret = regcomp(&reg_alm,pattern_setalm,cflags);  //匹配规则1:\d\d\d\d\d-\d\d-\d\d-\d\d-\d\d-\d\d
    if(ret) // judge error code : 0 symbolize success ; other value symbolizes fail 
    {
        regerror(ret,&reg_alm,ebuff,256);
        ALOGI(ebuff);
        regfree(&reg_alm);  //free mattch pattern
        regfree(&reg_sec);
        return -1;
    }

    ret = regcomp(&reg_sec,pattern_setsec,cflags); //匹配规则2:^\d\d*$
    if(ret)// judge error code : 0 symbolize success ; other value symbolizes fail 
    {
        regerror(ret,&reg_sec,ebuff,256);
        ALOGI(ebuff);
        regfree(&reg_alm);  //free mattch pattern
        regfree(&reg_sec);
        return -1;
    }

    time(&rawtime);  //获取自1970年到现在一共过去了几秒，赋值给rawtime

    info =localtime(&rawtime); //转换为UTC时间

    bool leap_flag = (bool)(((info->tm_year%4==0)&&(info->tm_year%100!=0)) || (info->tm_year%400 == 0));  //判断当前是否为闰年
    int day_array[13] = {0,31, leap_flag?29:28,31,30,31,30,31,31,30,31,30,31};   //设置每个月的天数

    if((ret = regexec(&reg_alm,buffer,0,NULL,0)) == 0)   //Retrieve the incoming buffer string according to matching rule 1
    {
        set_alarm = (struct tm *)malloc(sizeof(struct tm));
        memset(set_alarm,0,sizeof(struct tm));
        memcpy(set_alarm,info,sizeof(struct tm));  //拷贝当前时间信息

        ret = sscanf(buffer,"%d-%d-%d-%d-%d-%d",&(set_alarm->tm_year),&(set_alarm->tm_mon),&(set_alarm->tm_mday),&(set_alarm->tm_hour),&(set_alarm->tm_min),&(set_alarm->tm_sec));//read data form formatted string
        
        if(ret == -1)  //sscanf no mattch
        {
            ALOGI("sscanf error code -1\n");
            free(set_alarm);
            return -1;
        }
        else if(ret == 6) //Success mattch 
        {
            if((set_alarm->tm_hour > 23) || (set_alarm->tm_hour < 0)) //judge hour 
            {
                ALOGI("hour error\n");
                ret = -1;
            }
            if((set_alarm->tm_mon > 12) || (set_alarm->tm_mon < 1))  //judge month
            {
                ALOGI("mon error\n");
                ret = -1;
            }
            if((set_alarm->tm_mday > day_array[set_alarm->tm_mon]) || (set_alarm->tm_mday < 1)) //judge day
            {
                ALOGI("day error\n");
                ret = -1;
            }
            if(ret == -1) //Error setting alarm time
            {
                free(set_alarm);
                return -1;
            }

            set_alarm->tm_mon -= 1; 
            sprintf(ebuff,"set alarm is %s\n",asctime(set_alarm)); //print log
            ALOGI(ebuff);
            alarm_tamp = mktime(set_alarm); //struct tm transform struct time_t
            time(&rawtime); 
            //printf("tamp: %ld\n",alarm_tamp);
            sec = alarm_tamp - rawtime; //set second
            free(set_alarm);

            if(sec <= 0) //the current alarm time is less than the current system time
            { 
                ALOGI("sec <= 0 setalarm error\n");
                return -1;
            }
        }
        else //sscanf mattch fail
        {
            ALOGI("sscanf error other\n");
            free(set_alarm);
            return -1;
        }
    }
    else if ((ret = regexec(&reg_sec,buffer,0,NULL,0)) == 0) //Retrieve the incoming buffer string according to matching rule 2
    {
        sec = (ssize_t)atoi(buffer); //string convert ssize_t
    }
    else //matching rule 1 and 2 all fail
    {
        regerror(ret,&reg_sec,ebuff,256); //free memony
        ALOGI(ebuff);
        regfree(&reg_alm); 
        regfree(&reg_sec);
        return -1;
    }

    regfree(&reg_alm);
    regfree(&reg_sec);
    
    return sec;
}
