#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<stdbool.h>
#include<log/log.h>
#include"./include/lynq_alarm.h"
#include"format_change.h"

#define LOG_TAG "libpoweralarm" 
#define RTCFILE_POWERALARM "/sys/class/rtc/rtc0/poweralarm"

#define RTCFILE_WAKEALARM "/sys/class/rtc/rtc0/wakealarm"


/*****************************************************************************
* 
*   Prototype    : poweralarm
*   Description  : set shutdown wake-up alarm clock 
*   Input        : char *buffer ;  input format : 04-23-15-30-00 ( Mon-Day-Hour-Min-Sec ) Or  1200 ( seconds )              
*   Output       : None
*   Return Value : -1: error ; >0: set to wake up the devices after seconds
*
*****************************************************************************/

ssize_t poweralarm(char *buffer)
{
    ssize_t sec;
    char *time_buff = NULL;

    sec = format_change(buffer); //computing seconds for shutdown alarm
    if(sec < 60)
    {
        ALOGI("No Mattch\n");
        return -1;
    }
    
    time_buff = (char*)malloc(100);
    bzero(time_buff,100);

    sprintf(time_buff,"echo +%ld > %s",sec,RTCFILE_POWERALARM); //write formatted data into time_buff
    system(time_buff);
    ALOGI(time_buff);

    free(time_buff);

    return sec; // wake-up devices after sec seconds
}


/*****************************************************************************
*   Prototype    : wakealarm
*   Description  : set the wake-up alarm clock in low power mode
*   Input        : char *buffer ;  input format : 04-23-15-30-00 ( Mon-Day-Hour-Min-Sec ) Or  1200 ( seconds )
*   Output       : None
*   Return Value : -1: error ; >0: set to wake up the devices after seconds
*
*****************************************************************************/
ssize_t wakealarm(char *buffer)
{
    ssize_t sec;
    char *time_buff = NULL;
    int ret;
    sec = format_change(buffer); //computing seconds for lowpower alarm
    if(sec < 60)
    {
        ALOGI("No Mattch\n");
        return -1;
    }
    ret = system("echo +0 > /sys/class/rtc/rtc0/wakealarm");
    RLOGD("close wakealarm ret= %d\n", ret);
    time_buff = (char*)malloc(100);
    bzero(time_buff,100);

    sprintf(time_buff,"echo +%ld > %s",sec,RTCFILE_WAKEALARM); //write formatted data into time_buff
    system(time_buff);
    ALOGI(time_buff);

    free(time_buff);

    return sec; // wake-up devices after sec seconds
}


/*****************************************************************************
*   Prototype    : cancel wakealarm
*   Description  : cancel the wake-up alarm clock in low power mode
*   Input        : void
*   Output       : int
*   Return Value : -1: error ; 0: cannel wakealarm success
*
*****************************************************************************/

int cancel_wakealarm(void)
{
    int ret;
    ret = system("echo +0 > /sys/class/rtc/rtc0/wakealarm");
    ret = system("echo +315360000 > /sys/class/rtc/rtc0/wakealarm");
    RLOGD("close wakealarm ret= %d\n", ret);
    return ret;

}

/*****************************************************************************
*   Prototype    : check wake up by rtc
*   Description  : check weather AP is waked up by RTC
*   Input        : void
*   Output       : int
*   Return Value : 1: AP is waked up by rtc ; 0: AP is not waked up by rtc
*
*****************************************************************************/

int check_wakeupbydtr(void)
{
    FILE *fp;
    char buf[4];
    int ret;
    fp = popen("cat /proc/driver/rtc_wakeup","r");
    fgets(buf, sizeof(buf), fp);
    RLOGD("buf=%s\n", buf);
    ret=atoi(buf);
    pclose(fp);
    return ret;

}
