
/*============================================================================= 
#     FileName: lynq-at-test
#     Desc: about SIMAPI
#     Author: lei 
#     Version: V1.0
#     LastChange: 2023-03-09 
#     History: 
# 
=============================================================================*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdint.h>

#include "mipc_msg.h"
#include "mipc_msg_tlv_api.h"
#include "mipc_msg_tlv_const.h"
#include "mipc_msg_host.h"

#ifdef __cplusplus
extern "C" {
#endif

char str[] = "AT;AT+CSQ;AT+ECSQ;AT+CREG;AT+CEREG;AT+C5GREG;AT+COPS;AT+CFUN;AT+ERAT";

int check_buf(char *str,char *cmd)
{
    char *q = (char *)calloc(64,sizeof(char));
    strcpy(q, str);
    char *name;
    char cmp[16] = {0};
    while(q != NULL)
    {
        name = strsep(&q,";");
        //printf("name %s\n", name);
        strcpy(cmp, name);
        //printf("cmp %s\n", cmp);
        if(!strncmp(cmp, cmd, strlen(cmp)))
        {
            //printf("equal\n");
            return 1;
        }
        // if(name != NULL)
        // {
        //     printf("%s\n", name);
        //     if(!strncmp(name, cmd, strlen(name)))
        //     {
        //         return 1;
        //     }
        // }
    }
    free(q);
    return 0;
}

void uper_char(char *cmd)
{
    char *p = cmd;
    while (*p != '\0')
    {
        if((*p >= 'a') && (*p <= 'z'))
        {
            *p = *p-32;
        }
        *p++;
    }
}

void sendcmd(char *cmd)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, (mipc_msg_sim_ps_id_enum)MIPC_PS0);
    mipc_msg_t *msg_cnf_ptr = NULL;
    mipc_result_enum result;
    char *atcmd_res_ptr = NULL;//, *atci_res = NULL;
    uint16_t atcmd_res_len;
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_AT_REQ_T_ATCMD, strlen(cmd), cmd);
    msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    mipc_msg_deinit(msg_req_ptr);
    result = mipc_get_result(msg_cnf_ptr);
    if (result == MIPC_RESULT_SUCCESS) {
        atcmd_res_ptr = (char *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SYS_AT_CNF_T_ATCMD, &atcmd_res_len);
        //int res_len = strlen(atcmd_res_ptr);
        //printf( "res_len is:%d, atcmd_res_len is %d\n", res_len, atcmd_res_len);
        //strncpy(response, atcmd_res_ptr, res_len);
        //response[res_len] = '\0';
        //atcmd_res_ptr[atcmd_res_len] = '\0';
        printf( "%s\n", atcmd_res_ptr);
    } else {
        printf( "Failed to execute:%d\n", result);
    }
    mipc_msg_deinit(msg_cnf_ptr);
}

int main(void)
{
    SETCOM("/dev/ttyCMIPC2");
    mipc_init("atci");
    printf( "set mipc_inited true (UANT)\n");
    char cmd[256] = {0};
    while (1)
    {
        printf("please input at cmd:\n");
        fgets(cmd, 256, stdin);
        cmd[strlen(cmd)-1]='\0';
        uper_char(cmd);
        if(check_buf(str, cmd))
        {
            sendcmd(cmd);
        }
        else
        {
            printf("we just support AT+CSQ AT+ECSQ AT+CREG AT+CEREG AT+C5GREG AT+COPS AT+CFUN AT+ERAT\n");
        }
        
    }
}
#ifdef __cplusplus
}
#endif 
