#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include<stdlib.h>
#include <netinet/in.h>
#include <strings.h>
#include <stdlib.h>
#include <dlfcn.h>
#include "nadif.h"
#include "nadif_hal_service.h"
#include "nadif_hal_service_types.h"
#include "liblog/liblog.h"
#include "liblog/lynq_deflog.h"
#include <vendor-ril/telephony/ril.h>
#include <errno.h>
#include "lynq-conti-plugin-response.h"

#define USER_LOG_TAG "CONTI-PLUGIN-TEST"

NADIF_HAL_SVC_ID req_sv_id = 0;

typedef const NADIF_HAL_PluginFunctions *(*PLUGIN_INIT)(const NADIF_HAL_Callbacks *callbacks, void *token);

const char *conti_plugin_path = "/lib64/liblynq-conti-plugin.so";

static void conti_plugin_response(void *data, size_t datalen, NADIF_RESULT res, void *token);

static void conti_plugin_unsol_response(NADIF_HAL_SVC_ID command, void *data, size_t datalen);

static NADIF_RESULT conti_plugin_db_write(const gchar *key, const void *data, const size_t datalen);

static NADIF_RESULT conti_plugin_db_read(const gchar *key, void *data, size_t datalen);

static void conti_plugin_status(void *data, size_t datalen, void *init_token);

NADIF_HAL_PluginFunctions *pluginFunctions = NULL;
NADIF_HAL_Callbacks conti_callbacks =
        {
                conti_plugin_response,
                conti_plugin_unsol_response,
                conti_plugin_db_write,
                conti_plugin_db_read,
                conti_plugin_status,
        };

int main(int argc, const char *argv[]) {
    //LYLOGEINIT(USER_LOG_TAG);
    printf("conti Plugin test demo\n");

#if 1
    void *handle = dlopen(conti_plugin_path, RTLD_LAZY);
    printf("conti Plugin test demo: %d\n", __LINE__);
    if (!handle) {
        printf("[%s][%d]dlopen get error: %s\n", __FILE__, __LINE__, dlerror());
        exit(EXIT_FAILURE);
    }
    printf("conti Plugin test demo: %d\n", __LINE__);


    PLUGIN_INIT plugin_init = (PLUGIN_INIT) dlsym(handle, "plugin_init");
    printf("conti Plugin test demo: %d\n", __LINE__);
    if (!plugin_init) {
        printf("plugin_init error:%s\n", dlerror());
    }

    pluginFunctions = plugin_init(&conti_callbacks, "test");
    printf("conti Plugin test demo: %d\n", __LINE__);


    if (NULL != pluginFunctions)
        printf("plugin init is ok\n");
#endif

    while (1) {
        req_sv_id = NADIF_HAL_SVC_GET_IMSI;
        char test_buf[10] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        pluginFunctions->plugin_request(req_sv_id, test_buf, 10, "test");
        printf("conti-test: sv_iid=%d\n", req_sv_id);
        sleep(2);
        req_sv_id = NADIF_HAL_SVC_GET_VOICE_CALL_INFO;
        char *phone_num = "+8615826484140";
        pluginFunctions->plugin_request(req_sv_id, phone_num, strlen(phone_num), "test");
        sleep(2);
    }
    return 0;
}

static void conti_plugin_response(void *data, size_t datalen, NADIF_RESULT res, void *token) {
    list_param_for_sv_id(req_sv_id, data);
    printf("[%s][%s][%d]:dataLen=%d, res=%d\n", __FILE__, __FUNCTION__, __LINE__, datalen, res);
}

static void conti_plugin_unsol_response(NADIF_HAL_SVC_ID command, void *data, size_t datalen) {
    list_param_for_sv_id(command, data);
    printf("[%s][%s][%d]:id=%d, dataLen=%d\n", __FILE__, __FUNCTION__, __LINE__, command, datalen);
}

static NADIF_RESULT conti_plugin_db_write(const gchar *key, const void *data, const size_t datalen) {
    printf("[%s][%s][%d]:key=%s, dataLen=%d\n", __FILE__, __FUNCTION__, __LINE__, key, datalen);
    return NADIF_RESULT_SUCCESS;
}

static NADIF_RESULT conti_plugin_db_read(const gchar *key, void *data, size_t datalen) {
    printf("[%s][%s][%d]:key=%s, res=%d\n", __FILE__, __FUNCTION__, __LINE__, key, datalen);
    return NADIF_RESULT_SUCCESS;
}

static void conti_plugin_status(void *data, size_t datalen, void *init_token) {
    printf("[%s][%s][%d]:dataLen=%d\n", __FILE__, __FUNCTION__, __LINE__, datalen);
}
