#include "rfAutomaticTest.h"
#include<common.h>
/*
#ifdef __cplusplus
extern "C" {
#endif
#include "gps/gps_test.h"
#ifdef __cplusplus
}
#endif
*/
#include <log/log.h>
#include "libtel/lynq_call.h"
#include "libtel/lynq_sim.h"
#undef LOG_TAG
#define LOG_TAG "Factory_RfAutomaticTxTest"
//extern void get_gps_test();
//extern C lynq_get_sim_status();
const int RfAutomaticTest::MSG_TELE = 3;
const int RfAutomaticTest::MSG_GPS = 2;
const int RfAutomaticTest::MSG_SIM = 1;
const int RfAutomaticTest::MSG_NULL = 0;

RfAutomaticTest* RfAutomaticTest::m_instance = NULL;
std::mutex RfAutomaticTest::mMutex;
// Method implements of RequestHandleThread
RfAutomaticTest::RequestHandleThread::RequestHandleThread(RfAutomaticTest* tx) : m_looper(NULL) {
    mTx = tx;
    RLOGD( "RequestHandleThread created");
}

RfAutomaticTest::RequestHandleThread::~RequestHandleThread() {
    mTx = NULL;
    RLOGD( "RequestHandleThread destroyed");
}
RfAutomaticTest::RfRequestMessage::RfRequestMessage(RfAutomaticTest* tx) : mTx(tx),mMsgType(0),
        response(""),responselen(0), slot(0), e(ERROR) {
}

RfAutomaticTest::RfRequestMessage::~RfRequestMessage() {
    RLOGD( "RequestHandleThread destroyed");
}

void RfAutomaticTest::RfRequestHandler::handleMessage(const Message& message) {
    RLOGD( "handleMessage msg->mMsgType: %d", mMsg->mMsgType);
    if(mTx != NULL) {
        mTx->factory_test_onebyone(mMsg);
    } else {
        RLOGD( "handleMessage mTx is null");
    }
}
void RfAutomaticTest::factory_test_onebyone(sp<RfRequestMessage> msg){
  RLOGD( "FactoryTestOneByOne, type: %d,slot:%d,auto_reqId:%d", msg->mMsgType,msg->slot,auto_reqId);
  int responselen = msg->responselen;
  std::string response = msg->response;
  if(msg->slot != 0){
  	RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
    if(msg->slot == auto_reqId){
  	RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
      switch (msg->mMsgType) {
  //    case MSG_NULL: {
	//  	  mCurrentFlag = MSG_SIM;
	  	//  auto_reqId = lynq_get_sim_status();
    //  	} 	
      case MSG_SIM: {
	  	  	RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);

        if(msg->e == SUCCESS){
          mFactoryResult[0] = 1;
        }else{
          mFactoryResult[0] = 0;
          mFactoryResult[1] = 0;  
          mCurrentFlag = MSG_GPS;
      //    get_gps_test();
          break;
  	    }
        mCurrentFlag = MSG_TELE;
       // auto_reqId = get_call();
		  auto_reqId = 88;
        RLOGD( "get_call,auto_reqId:%d",auto_reqId);
        break;
      }
      case MSG_TELE:{
        if(msg->e == SUCCESS){
          mFactoryResult[1] = 1;
          RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
        }else{
          mFactoryResult[1] = 0;
          RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);

        }  
        mCurrentFlag = MSG_GPS;
  	  //  get_gps_test();
        break ;
      }
      default:
        break; 
    }
  }
}else if(msg->mMsgType == MSG_NULL ){
  	RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
	mCurrentFlag = MSG_SIM;
	auto_reqId = 99;
    //auto_reqId = lynq_get_sim_status();
    RLOGD( "lynq_get_sim_status,auto_reqId:%d",auto_reqId);

  }
else if(MSG_GPS == msg->mMsgType){
	int i;
  	RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);

  if(msg->e == SUCCESS){
    mFactoryResult[2] = 1;
  }else{
    mFactoryResult[2] = 0;
  }
  mCurrentFlag = 0;
  for(i = 0; i<3;i++){
    RLOGD("mFactoryResult[%d]:%d",i,mFactoryResult[i]);
  }
  unregister_factory_auto_hook_raw();
  }else{
	RLOGE("Error11111,Unknown location");
  }
}
  
sp<RfAutomaticTest::RfRequestHandler> RfAutomaticTest::sendMessage(sp<RfRequestMessage> msg, int delayms) {
    RLOGD( "sendMessage msg token=%d delayms=%d", msg->mMsgType, delayms);
    sp<RfRequestHandler> handler = new RfRequestHandler(this);
    handler->mMsg = msg;
    if(mRequestHandleThread.get()) {
        sp<Looper> looper = mRequestHandleThread->getLooper();
        if(looper.get()) {
            if (delayms > 0) {
                looper->sendMessageDelayed(ms2ns(delayms),handler, handler->m_dummyMsg);
            } else {
                looper->sendMessage(handler, handler->m_dummyMsg);
            }
        } else {
            RLOGD( "looper fail");
        }
    } else {
        RLOGD( "mRequestHandleThread fail");
    }

    return handler;
}

RfAutomaticTest::RfRequestHandler:: ~RfRequestHandler() {
    mTx = NULL;
    RLOGD( "RfRequestHandler destroyed");
}

bool RfAutomaticTest::RequestHandleThread::threadLoop() {
    RLOGD( "RequestHandleThread threadLoop");
    // start message loop
    m_looper = Looper::prepare(0);
    int result;
    do {
        result = m_looper->pollAll(-1);
        RLOGD( "RequestHandleThread threadLoop, pull message result = %d", result);
    } while (result == Looper::POLL_WAKE || result == Looper::POLL_CALLBACK);
    return true;
}

sp<Looper> RfAutomaticTest::RequestHandleThread::getLooper() {
    return m_looper;
}
RfAutomaticTest::RfAutomaticTest(): mCurrentFlag(0) {
  
}

RfAutomaticTest::~RfAutomaticTest() {
    RLOGD("RfDesenseTxTest destroyed");
}

void RfAutomaticTest::handle_request(string response,int responselen,int slot, RIL_Errcode e) {
	sp<RfRequestMessage> msg = new RfRequestMessage(this);
	RLOGD("RfDesenseTxTest handle_request");
    msg->mMsgType = mCurrentFlag;
    msg->response = response;
    msg->responselen = responselen;
    msg->slot = slot;
    msg->e = e;
    sendMessage(msg, 1000);
}
void RfAutomaticTest::init() {
    register_factory_auto_hook_raw(m_instance);
    mRequestHandleThread = new RequestHandleThread(this);
    mRequestHandleThread->run();
}
RfAutomaticTest* RfAutomaticTest::getInstance() {
    if(!m_instance) {
        mMutex.lock();
        if(!m_instance) {
            m_instance = new RfAutomaticTest();
            m_instance->init();
        }
        mMutex.unlock();
    }
    return m_instance;
}
