#include "common.h"
#include <log/log.h>
#include "libtel/lib_tele.h"
#include <libtel/lynq_call.h>
#include <libtel/lynq_sim.h>
#include <libtel/lynq_network.h>
#include <libtel/lynq_data.h>
#include <libtel/lynq_sms.h>
#include <ril/ril_test.h>
#include <cutils/properties.h>
#define MAX_P 10
static int strUpper(char * str)
{
    int i=0;
    while(1)
    {
        if(str[i]=='\0')
        {
            break;
        }
        if(str[i]>='a'&&str[i]<='z')
        {
             //printf("str %c\n",str[i]-32);
             str[i]=str[i]-32;
        }
        i++;
    }
    return 0;
}

int eventDial(const char *addr,int command)
{
    int32_t token;
    //const char* addr = "10086";
    char output[1024] = {0};
    lynqCallList *msg = (lynqCallList*)malloc(sizeof(lynqCallList));
    memset(msg,0,sizeof(lynqCallList));
    msg->addr=(char *)malloc(sizeof(char));
    memset(msg->addr,0,sizeof(char));
    //printf("call start \n");
    token = lynq_call(addr, msg);
    RLOGD("[MAIN_LOG] request is %d,phone number is %s,token is %x,error is %d,call_state is %d",
        msg->base.request,msg->addr,msg->base.token,msg->base.e,msg->call_state);
    sprintf(output, "Factory_result  error_code:%d\n",msg->base.e);
    emResultNotify(output,command);
    free(msg->addr);
    msg->addr=NULL;
    free(msg);
    msg=NULL;
    return 0;
}

int eventAnswer(int command)
{
    int32_t token;
    char output[1024] = {0};
    lynqCallList *msg = (lynqCallList*)malloc(sizeof(lynqCallList));
    memset(msg,0,sizeof(lynqCallList));
    msg->addr=(char *)malloc(sizeof(char));
    memset(msg->addr,0,sizeof(char));
    //printf("call start \n");
    token = lynq_call_answer(msg);
    //printf("[MAIN_LOG] request is %d,phone number is %s,token is %x,error is %d,call_state is %d\n",
        //msg->base.request,msg->addr,msg->base.token,msg->base.e,msg->call_state);
    RLOGD("[MAIN_LOG] request is %d,phone number is %s,token is %x,error is %d,call_state is %d",
        msg->base.request,msg->addr,msg->base.request,msg->base.e,msg->call_state);
    sprintf(output, "Factory_result  error_code:%d\n",msg->base.e);
    emResultNotify(output,command);
    free(msg->addr);
    msg->addr=NULL;
    free(msg);
    msg=NULL;
    return 0;
}
int eventAutoAnswer(const int  status,int command)
{
    int32_t token=0;
    int mode=0;
    char output[1024] = {0};
    token = lynq_set_auto_answercall(status,&mode);
    RLOGD("Auto answer mode is %d",mode);
    sprintf(output, "Factory_result auto answer mode:%d\n",mode);
    emResultNotify(output,command);
    return 0;
}
int eventSetMute(const int mute,int command)
{
    int32_t token = 0;
    int status =0;
    char output[1024] = {0};
    token = lynq_set_mute_mic(mute, &status);
    RLOGD("set mute status is %s,current mute status is %s",mute>0?"mute on":"mute off",status>0?"mute on":"mute off");
    //printf("set mute status is %s,current mute status is %s\n",mute>0?"mute on":"mute off",status>0?"mute on":"mute off");
    sprintf(output, "Factory_result set mute status is %s,current mute status is %s\n",mute>0?"mute on":"mute off",status>0?"mute on":"mute off");
    emResultNotify(output,command);
    return 0;
}
int eventGetMute(int command)
{
    int32_t token = 0;
    int status =0;
    char output[1024] = {0};
    token = lynq_get_mute_status(&status);
    RLOGD("current mute status is %s",status>0?"mute on":"mute off");
    //printf("current mute status is %s\n",status>0?"mute on":"mute off");
    sprintf(output, "Factory_result current mute status is %s\n",status>0?"mute on":"mute off");
    emResultNotify(output,command);
    return 0;
}
int eventLastCallFailCause(int command)
{
    int32_t token = 0;
    int status =0;
    char output[1024] = {0};
    lynqLastCallFailCause * msg = (lynqLastCallFailCause*)malloc(sizeof(lynqLastCallFailCause));
    memset(msg,0,sizeof(lynqLastCallFailCause));
    msg->vendor_cause = (char *)malloc(sizeof(char));
    memset(msg->vendor_cause,0,sizeof(char));
    token = lynq_get_last_call_fail_cause(msg);
    RLOGD("token is %x,request is %d,error_code is %d,cause_code is %d,vendor_cause  is %s",msg->base.token,
        msg->base.request,msg->base.e,msg->cause_code,msg->vendor_cause);
    //printf("token is %x,request is %d,error_code is %d,cause_code is %d,vendor_cause  is %s\n",msg->base.token,
        //msg->base.request,msg->base.e,msg->cause_code,msg->vendor_cause);
    sprintf(output, "Factory_result error code %d\n",msg->base.e);
    emResultNotify(output,command);
    free(msg->vendor_cause);
    free(msg);
    return 0;
}
int eventCallHangUp(int index,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_call_hang_up(index,&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result  erro code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventRejectCall(int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_reject_call(&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result  erro code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventSetDTMF(const char value,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_set_DTMF(value,&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result  erro code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventSetDTMFVolume(const int volume,int command)
{
    int32_t token =0;
    char output[1024] = {0};
    token = lynq_set_DTMF_volume(volume);
    //printf("set DTMF Volume is %s\n",(token>0?"success":"fail"));
    sprintf(output, "Factory_result set DTMF Volume is %s\n",(token>0?"success":"fail"));
    emResultNotify(output,command);
    return 0;
}
int eventDoMultiConference(int command)
{
    lynqCallList msg;
    msg.addr=NULL;
    char output[1024] = {0};
    lynq_do_multi_conference(&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.base.request,msg.base.token,msg.base.e);
    //RLOGD("request is %d,token is %x,error is %d\n",msg.reqNumber,msg.token,msg.error_code);
    //printf("[MAIN_LOG] request is %d,call id is %d,phone number is %s,type of address is %d,token is %x,error is %d,call_state is %d\n",
        //msg.base.request,msg.call_id,msg.addr,msg.toa,msg.base.e,msg.base.e,msg.call_state);
    RLOGD("[MAIN_LOG] request is %d,call id is %d,phone number is %s,type of address is %d,token is %x,error is %d,call_state is %d",
        msg.base.request,msg.call_id,msg.addr,msg.toa,msg.base.token,msg.base.e,msg.call_state);
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventOthercallHold(const int call_id,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_othercall_hold(call_id,&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventHangupWatingForCall(int command)
{
    lynqCallList msg;
    msg.addr=NULL;
    char output[1024] = {0};
    lynq_hangup_wating_for_call(&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.base.request,msg.base.token,msg.base.e);
    //RLOGD("request is %d,token is %x,error is %d\n",msg.reqNumber,msg.token,msg.error_code);
    //printf("[MAIN_LOG] request is %d,call id is %d,phone number is %s,type of address is %d,token is %x,error is %d,call_state is %d\n",
        //msg.base.request,msg.call_id,msg.addr,msg.toa,msg.base.token,msg.base.e,msg.call_state);
    RLOGD("[MAIN_LOG] request is %d,call id is %d,phone number is %s,type of address is %d,token is %x,error is %d,call_state is %d",
        msg.base.request,msg.call_id,msg.addr,msg.toa,msg.base.token,msg.base.e,msg.call_state);
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventHangupForegroundResumeBackground(int command)
{
    lynqCallList msg;
    msg.addr=NULL;
    char output[1024] = {0};
    lynq_hangup_foreground_resume_background(&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.base.request,msg.base.token,msg.base.e);
    //RLOGD("request is %d,token is %x,error is %d\n",msg.reqNumber,msg.token,msg.error_code);
    //printf("[MAIN_LOG] request is %d,call id is %d,phone number is %s,type of address is %d,token is %x,error is %d,call_state is %d\n",
        //msg.base.request,msg.call_id,msg.addr,msg.toa,msg.base.token,msg.base.e,msg.call_state);
    RLOGD("[MAIN_LOG] request is %d,call id is %d,phone number is %s,type of address is %d,token is %x,error is %d,call_state is %d",
        msg.base.request,msg.call_id,msg.addr,msg.toa,msg.base.token,msg.base.e,msg.call_state);
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventSwitchWaitOrHoldAndActiveCall(int command)
{
    lynqCallList msg;
    msg.addr=NULL;
    char output[1024] = {0};
    lynq_switch_hold_and_active_call(&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.base.request,msg.base.token,msg.base.e);
    //RLOGD("request is %d,token is %x,error is %d\n",msg.reqNumber,msg.token,msg.error_code);
    //printf("[MAIN_LOG] request is %d,call id is %d,phone number is %s,type of address is %d,token is %x,error is %d,call_state is %d\n",
        //msg.base.request,msg.call_id,msg.addr,msg.toa,msg.base.token,msg.base.e,msg.call_state);
    RLOGD("[MAIN_LOG] request is %d,call id is %d,phone number is %s,type of address is %d,token is %x,error is %d,call_state is %d",
        msg.base.request,msg.call_id,msg.addr,msg.toa,msg.base.token,msg.base.e,msg.call_state);
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}

int eventQueryOperator(int command)
{
    operatorInfo msg;
    char output[1024] = {0};
    msg.OperatorFN=NULL;
    msg.OperatorSH=NULL;
    msg.MccMnc=NULL;
    lynq_query_operater(&msg);
    //printf("request is %d,token is %x,error is %d,OperatorFN is %s,OperatorSH is %s,MccMnc is %s\n",msg.base.request,msg.base.token,msg.base.e,msg.OperatorFN,msg.OperatorSH,msg.MccMnc);
    RLOGD("request is %d,token is %x,error is %d\n",msg.base.request,msg.base.token,msg.base.e);
    //printf("OperatorFN is %s,OperatorSH is %s,MccMnc is %s\n",msg.OperatorFN,msg.OperatorSH,msg.MccMnc);
    RLOGD("OperatorFN is %s,OperatorSH is %s,MccMnc is %s\n",msg.OperatorFN,msg.OperatorSH,msg.MccMnc);
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventQueryNetSelectMode(int command)
{
    char output[1024] = {0};
    networkSelecttionMode msg;
    lynq_query_network_selection_mode(& msg);
    //printf("request is %d,token is %x,error is %d,mode is %d\n",msg.base.request,msg.base.token,msg.base.e,msg.mode);
    RLOGD("request is %d,token is %x,error is %d,mode is %d",msg.base.request,msg.base.token,msg.base.e,msg.mode);
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventSetNetSelectMode(const int mode,int command)
{
    char output[1024] = {0};
    char str[100]={0};
    const char * mccmnc = "46000";//just China Mobile Communications Group
    lynqBase msg;
    sprintf(str,"%s",(mode==0?"Auto":"Manual"));
    if(mode==0)
    {
        lynq_set_network_selection_mode(str,NULL,&msg);
    }
    else if(mode ==1)
    {
        printf("You have selected manual mode, this command only supports CMCC SIM card temporarily");
        lynq_set_network_selection_mode(str,mccmnc,&msg);
    }
    else
    {
        sprintf(output, "please input network selection mode:0 or 1,and try again\n");
        emResultNotify(output,command);
        return 0;
    }
    //lynq_set_network_selection_mode(argv[2],argv[3],&msg);//0:auto selection 1:manual selection
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventQueryAvailableNetwork(int command)
{
    int32_t token=0;
    char output[1024] = {0};
    availableNetwork msg;
    msg.OperatorFN=NULL;
    msg.OperatorSH=NULL;
    msg.MccMnc=NULL;
    msg.NetStatus=NULL;
    lynq_query_available_network(&msg);
    //printf("request is %d,token is %x,error is %d,OperatorFN is %s,OperatorSH is %s,MccMnc is %s,Netstatus is %s\n",msg.base.request,msg.base.token,msg.base.e,msg.OperatorFN,msg.OperatorSH,msg.MccMnc,msg.NetStatus);
    RLOGD("request is %d,token is %x,error is %d",msg.base.request,msg.base.token,msg.base.e);
    //printf("OperatorFN is %s,OperatorSH is %s,MccMnc is %s\n",msg.OperatorFN,msg.OperatorSH,msg.MccMnc);
    RLOGD("OperatorFN is %s,OperatorSH is %s,MccMnc is %s,NetStatus is %s",msg.OperatorFN,msg.OperatorSH,msg.MccMnc,msg.NetStatus);
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);

    return 0;

}
 int eventQueryRegistrationState(char *type,int command)
{
    char output[1024] = {0};
    registrationStateInfo msg;
    msg.CID=NULL;
    msg.LAC=NULL;
    char str[10];
    if (strlen(type)>10)
    {
        RLOGD("the parameter is inavaliable !");
        return -1;
    }
    memcpy(str,type,strlen(type)+1);
    strUpper(str);
    //printf("upper str is %s\n",str);
    lynq_query_registration_state(str,&msg);
    if(!strcmp(str,"VOICE")){
        //printf("request is %d,token is %x,error is %d,registration state is %d\n",
        //msg.base.request,msg.base.token,msg.base.e,msg.regState);
        RLOGD("request is %d,token is %x,error is %d",msg.base.request,msg.base.token,msg.base.e);
        RLOGD("registration state is %d",msg.regState);
    }else if(!strcmp(str,"DATA")){
        //printf("request is %d,token is %x,error is %d,registration state is %d,LAC is %s,CID is %s,network type is %d\n",
        //msg.base.request,msg.base.token,msg.base.e,msg.regState,msg.LAC,msg.CID,msg.netType);
        RLOGD("request is %d,token is %x,error is %d",msg.base.request,msg.base.token,msg.base.e);
        RLOGD("registration state is %d,LAC is %s,CID is %s,network type is %d",msg.regState,msg.LAC,msg.CID,msg.netType);
    }else if(!strcmp(str,"IMS")){
        //printf("request is %d,token is %x,error is %d,ims registration state is %d,radio tech family is %d\n",
        //msg.base.request,msg.base.token,msg.base.e,msg.imsRegState,msg.radioTechFam);
        RLOGD("request is %d,token is %x,error is %d",msg.base.request,msg.base.token,msg.base.e);
        RLOGD("ims registration state is %d,radio tech family is %d",msg.imsRegState,msg.radioTechFam);
    }else{
        printf("--------->[%s,%d] query ims registration state about voice, data, and ims!!! \n",__FUNCTION__,__LINE__);
        return -1;
    }
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
 }
 int eventQueryPrefferredNetworkType(int command)
{
    char output[1024] = {0};
    prefferredNetworkType msg;
    lynq_query_prefferred_networktype(&msg);
    //printf("request is %d,token is %x,error is %d,preffered network is %d\n",
    //msg.base.request,msg.base.token,msg.base.e,msg.pnt);
    RLOGD("request is %d,token is %x,error is %d",msg.base.request,msg.base.token,msg.base.e);
    RLOGD("preffered network is %d",msg.pnt);
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
 int eventSetPrefferredNetworkType(const int type,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_set_prefferred_networktype(type,&msg);
    //printf("request is %d,token is %x,error is %d\n",
    //msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventQueryCellInfo(int command)
{
    cellInfoList **msg;
    char output[1024] = {0};
    int num=5;
    int realNum =0;
    int32_t token=0;
    msg = (cellInfoList **)malloc(sizeof(cellInfoList *)*num);
    if(msg==NULL)
    {
        RLOGD("malloc LYNQ_Data_Call_Response_v11 fail \n");
        return -1;
    }
    for(int i =0;i<num;i++)
    {
        msg[i] = (cellInfoList*)malloc(sizeof(cellInfoList));
        if (msg[i]==NULL)
        {
            for (int n=0;n<i;n++)
            {
                free(msg[n]);
            }
            return -1;
        }
        memset(msg[i],0,sizeof(cellInfoList));
    }
    token = lynq_query_cell_info(msg, num, &realNum);
    /*
    printf("request is %d,\ntoken is %x,\ne is %d\n",msg[0]->base.request,msg[0]->base.token,msg[0]->base.e);
    for(int i = 0; i<realNum; i++)
    {
        //printf("request is %d,\ntoken is %x,\ne is %d\n",msg[i]->base.request,msg[i]->base.token,msg[i]->base.e);
        printf("cellInfoType is %d\n",msg[i]->cellinfo.cellInfoType);
        printf("registered is %d\n",msg[i]->cellinfo.registered);
        printf("timeStampType is %d\n",msg[i]->cellinfo.timeStampType);
        printf("timeStamp is %d\n",msg[i]->cellinfo.timeStamp);
        switch(msg[i]->cellinfo.cellInfoType) {
            case RIL_CELL_INFO_TYPE_GSM: {
                printf("gsm.cellIdentityGsm.mcc is %d\n",msg[i]->cellinfo.CellInfo.gsm.cellIdentityGsm.mcc);
                printf("gsm.cellIdentityGsm.mnc is %d\n",msg[i]->cellinfo.CellInfo.gsm.cellIdentityGsm.mnc);
                printf("gsm.cellIdentityGsm.lac is %d\n",msg[i]->cellinfo.CellInfo.gsm.cellIdentityGsm.lac);
                printf("gsm.cellIdentityGsm.cid is %d\n",msg[i]->cellinfo.CellInfo.gsm.cellIdentityGsm.cid);
                printf("gsm.signalStrengthGsm.signalStrength is %d\n",msg[i]->cellinfo.CellInfo.gsm.signalStrengthGsm.signalStrength);
                printf("gsm.signalStrengthGsm.bitErrorRate is %d\n",msg[i]->cellinfo.CellInfo.gsm.signalStrengthGsm.bitErrorRate);
                printf("gsm.signalStrengthGsm.timingAdvance is %d\n",msg[i]->cellinfo.CellInfo.gsm.signalStrengthGsm.timingAdvance);
                break;
            }
            case RIL_CELL_INFO_TYPE_WCDMA: {
                printf("wcdma.cellIdentityWcdma.mcc is %d\n",msg[i]->cellinfo.CellInfo.wcdma.cellIdentityWcdma.mcc);
                printf("wcdma.cellIdentityWcdma.mnc is %d\n",msg[i]->cellinfo.CellInfo.wcdma.cellIdentityWcdma.mnc);
                printf("wcdma.cellIdentityWcdma.lac is%d\n",msg[i]->cellinfo.CellInfo.wcdma.cellIdentityWcdma.lac);
                printf("wcdma.cellIdentityWcdma.cid is %d\n",msg[i]->cellinfo.CellInfo.wcdma.cellIdentityWcdma.cid);
                printf("wcdma.cellIdentityWcdma.psc is %d\n",msg[i]->cellinfo.CellInfo.wcdma.cellIdentityWcdma.psc);
                printf("wcdma.signalStrengthWcdma.signalStrength is %d\n",msg[i]->cellinfo.CellInfo.wcdma.signalStrengthWcdma.signalStrength);
                printf("wcdma.signalStrengthWcdma.bitErrorRate is %d\n",msg[i]->cellinfo.CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);
                break;
            }
            case RIL_CELL_INFO_TYPE_CDMA: {
                printf("cdma.cellIdentityCdma.networkId is %d\n",msg[i]->cellinfo.CellInfo.cdma.cellIdentityCdma.networkId);
                printf("cdma.cellIdentityCdma.systemId is %d\n",msg[i]->cellinfo.CellInfo.cdma.cellIdentityCdma.systemId);
                printf("cdma.cellIdentityCdma.basestationId is %d\n",msg[i]->cellinfo.CellInfo.cdma.cellIdentityCdma.basestationId);
                printf("cdma.cellIdentityCdma.longitude is %d\n",msg[i]->cellinfo.CellInfo.cdma.cellIdentityCdma.longitude);
                printf("cdma.cellIdentityCdma.latitude is %d\n",msg[i]->cellinfo.CellInfo.cdma.cellIdentityCdma.latitude);
                printf("cdma.signalStrengthCdma.dbm is %d\n",msg[i]->cellinfo.CellInfo.cdma.signalStrengthCdma.dbm);
                printf("cdma.signalStrengthCdma.ecio is %d\n",msg[i]->cellinfo.CellInfo.cdma.signalStrengthCdma.ecio);
                printf("cdma.signalStrengthEvdo.dbm is %d\n",msg[i]->cellinfo.CellInfo.cdma.signalStrengthEvdo.dbm);
                printf("cdma.signalStrengthEvdo.ecio is %d\n",msg[i]->cellinfo.CellInfo.cdma.signalStrengthEvdo.ecio);
                printf("cdma.signalStrengthEvdo.signalNoiseRatio is %d\n",msg[i]->cellinfo.CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);
                break;
            }
            case RIL_CELL_INFO_TYPE_LTE: {
                printf("lte.cellIdentityLte.mcc is %d\n",msg[i]->cellinfo.CellInfo.lte.cellIdentityLte.mcc);
                printf("lte.cellIdentityLte.mnc is %d\n",msg[i]->cellinfo.CellInfo.lte.cellIdentityLte.mnc);
                printf("lte.cellIdentityLte.ci is %d\n",msg[i]->cellinfo.CellInfo.lte.cellIdentityLte.ci);
                printf("lte.cellIdentityLte.pci is %d\n",msg[i]->cellinfo.CellInfo.lte.cellIdentityLte.pci);
                printf("lte.cellIdentityLte.tac is %d\n",msg[i]->cellinfo.CellInfo.lte.cellIdentityLte.tac);
                printf("lte.signalStrengthLte.signalStrength is %d\n",msg[i]->cellinfo.CellInfo.lte.signalStrengthLte.signalStrength);
                printf("lte.signalStrengthLte.rsrp is %d\n",msg[i]->cellinfo.CellInfo.lte.signalStrengthLte.rsrp);
                printf("lte.signalStrengthLte.rsrq is %d\n",msg[i]->cellinfo.CellInfo.lte.signalStrengthLte.rsrq);
                printf("lte.signalStrengthLte.rssnr is %d\n",msg[i]->cellinfo.CellInfo.lte.signalStrengthLte.rssnr);
                printf("lte.signalStrengthLte.cqi is %d\n",msg[i]->cellinfo.CellInfo.lte.signalStrengthLte.cqi);
                printf("lte.signalStrengthLte.timingAdvance is %d\n",msg[i]->cellinfo.CellInfo.lte.signalStrengthLte.timingAdvance);
                break;
            }
            case RIL_CELL_INFO_TYPE_TD_SCDMA: {
                printf("tdscdma.cellIdentityTdscdma.mcc is %d\n",msg[i]->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.mcc);
                printf("tdscdma.cellIdentityTdscdma.mnc is %d\n",msg[i]->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.mnc);
                printf("tdscdma.cellIdentityTdscdma.lac is %d\n",msg[i]->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.lac);
                printf("tdscdma.cellIdentityTdscdma.cid is %d\n",msg[i]->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.cid);
                printf("tdscdma.cellIdentityTdscdma.cpid is %d\n",msg[i]->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.cpid);
                printf("tdscdma.signalStrengthTdscdma.rscp is %d\n",msg[i]->cellinfo.CellInfo.tdscdma.signalStrengthTdscdma.rscp);
                break;
            }
        }
    }*/
    sprintf(output, "Factory_result error code:%d\n",msg[0]->base.e);
    emResultNotify(output,command);
    for (int i = 0; i < num; i++) 
    {
        if (msg[i]!=NULL)
        {    
            free(msg[i]);
            msg[i]=NULL;
        }
    }
    free(msg);
    msg=NULL;
    return 0;
}
int eventSetUnsolCellInfoListrate(const int rate,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_set_unsol_cell_info_listrate(rate,&msg);
    //printf("request is %d,token is %x,error is %d\n",
    //msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventQueryNeighboringCellids(int command)
{
    neighboringCellIDs **msg=NULL;
    char output[1024] = {0};
    //printf("neighboring celll ids\n");
    int num=5;
    int realNum =0;
    int32_t token=0;
    msg = (neighboringCellIDs **)malloc(sizeof(neighboringCellIDs *)*num);
    if(msg==NULL)
    {
        RLOGD("malloc LYNQ_Data_Call_Response_v11 fail \n");
        return -1;
    }
    for(int i =0;i<num;i++)
    {
        msg[i] = (neighboringCellIDs*)malloc(sizeof(neighboringCellIDs));
        msg[i]->cid = (char*)malloc(sizeof(char));
        if (msg[i]==NULL)
        {
            for (int n=0;n<i;n++)
            {
                free(msg[n]->cid);
                free(msg[n]);
            }
            return -1;
        }
        memset(msg[i],0,sizeof(neighboringCellIDs));
    }
    token = lynq_query_neighboring_cellids(msg, num, &realNum);
    //printf("request is %d,token is %x,error is %d\n",
    //msg[0]->base.request,msg[0]->base.token,msg[0]->base.e);
    /*
    for(int i =0;i<realNum;i++)
    {
        printf("request is %d,token is %x,error is %d,cid is %s,rssi is %d\n",
        msg[i]->base.request,msg[i]->base.token,msg[i]->base.e,msg[i]->cid,msg[i]->rssi);
        RLOGD("request is %d,token is %x,error is %d",msg[i]->base.request,msg[i]->base.token,msg[i]->base.e);
        RLOGD("cid is %s,rssi is %d %d",msg[i]->cid,msg[i]->rssi);
    }
    */
    sprintf(output, "Factory_result error code:%d\n",msg[0]->base.e);
    emResultNotify(output,command);
    for (int i = 0; i < num; i++) 
    {
        if (msg[i]!=NULL)
        {
            free(msg[i]->cid);
            msg[i]->cid=NULL;
            free(msg[i]);
            msg[i]=NULL;
        }
    }
    free(msg);
    msg=NULL;
    return 0;
}
int eventSetBandMode(const int mode,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_set_band_mode(mode,&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;

}
int eventQueryAvailableBandmode(int command)
{
    availableBandMode msg;
    char output[1024] = {0};
    lynq_query_available_bandmode(&msg);
    //printf("request is %d,token is %x,error is %d,\n",msg.base.request,msg.base.token,msg.base.e);
    RLOGD("request is %d,token is %x,error is %d",msg.base.request,msg.base.token,msg.base.e);
    if(msg.bandmode[0]>0)
    {
        printf("available band mode is:");
        for(int i =1;i<=msg.bandmode[0];i++)
        {
            printf("%d,",msg.bandmode[i]);
        }
        printf("\n");
        sprintf(output, "Factory_result error code:%d\n",msg.base.e);
        emResultNotify(output,command);
        return 0;
    }
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    RLOGD("available band mode is null");
    return 0;
}
int eventRadioOn(const int state,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_radio_on(state,&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventQueryRadioTech(int command)
{
    radioTechnology msg;
    char output[1024] = {0};
    lynq_query_radio_tech(&msg);
    //printf("request is %d,token is %x,error is %d,RadioTech is %d\n",
    //msg.base.request,msg.base.token,msg.base.e,msg.radioTech);
    RLOGD("request is %d,token is %x,error is %d",msg.base.request,msg.base.token,msg.base.e);
    RLOGD("RadioTech %d",msg.radioTech);
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
return 0;}
int eventSolicitedSignalStrength(int command)
{
    solicitedSignalStrength msg;
    char output[1024] = {0};
    lynq_solicited_signal_strength(&msg);
    //printf("request is %d,token is %x,error is %d\n",
    //msg.base.request,msg.base.token,msg.base.e);
    RLOGD("request is %d,token is %x,error is %d",msg.base.request,msg.base.token,msg.base.e);
    if(msg.base.e!=RIL_E_SUCCESS)
    {
        return -1;
    }
    /*
    printf("V5 GW signalStrength=%d\n", msg.signalStrength.GW_SignalStrength.signalStrength);
    printf("GW bitErrorRate=%d\n", msg.signalStrength.GW_SignalStrength.bitErrorRate);
    printf("GW timingAdvance=%d\n", msg.signalStrength.GW_SignalStrength.timingAdvance);
    printf("CDMA dbm=%d\n", msg.signalStrength.CDMA_SignalStrength.dbm);
    printf("CDMA ecio=%d\n", msg.signalStrength.CDMA_SignalStrength.ecio);
    printf("EVDO dbm=%d\n", msg.signalStrength.EVDO_SignalStrength.dbm);
    printf("EVDO ecio=%d\n", msg.signalStrength.EVDO_SignalStrength.ecio);
    printf("EVDO signalNoiseRatio=%d\n", msg.signalStrength.EVDO_SignalStrength.signalNoiseRatio);
    printf("V6 LTE signalStrength=%d\n", msg.signalStrength.LTE_SignalStrength.signalStrength);
    printf("LTE rsrp=%d\n", msg.signalStrength.LTE_SignalStrength.rsrp);
    printf("LTE rsrq=%d\n", msg.signalStrength.LTE_SignalStrength.rsrq);
    printf("LTE rssnr=%d\n", msg.signalStrength.LTE_SignalStrength.rssnr);
    printf("LTE cqi=%d\n", msg.signalStrength.LTE_SignalStrength.cqi);
    printf("LTE timingAdvance=%d\n", msg.signalStrength.LTE_SignalStrength.timingAdvance);
    printf("TD_SCDMA signalStrength=%d\n", msg.signalStrength.TD_SCDMA_SignalStrength.signalStrength);
    printf("TD_SCDMA bitErrorRate=%d\n", msg.signalStrength.TD_SCDMA_SignalStrength.bitErrorRate);
    printf("TD_SCDMA rscp=%d\n", msg.signalStrength.TD_SCDMA_SignalStrength.rscp);
    printf("WCDMA signalStrength=%d\n", msg.signalStrength.WCDMA_SignalStrength.signalStrength);
    printf("WCDMA bitErrorRate=%d\n", msg.signalStrength.WCDMA_SignalStrength.bitErrorRate);
    printf("WCDMA rscp=%d\n", msg.signalStrength.WCDMA_SignalStrength.rscp);
    printf("WCDMA ecno=%d\n", msg.signalStrength.WCDMA_SignalStrength.ecno);
    */
    sprintf(output, "Factory_result error code:%d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventModemOn(const int state,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_modem_on(state,&msg);
    //printf("request is %d,token is %x,error is %d\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code:%d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventSetupDataCall(int command)
{
    int32_t token;
    char output[1024] = {0};
    int state=0;
    token = lynq_data_enable_data(&state);
    //printf("pdn state is %s\n",state<0?"disconnect":"connect");
    sprintf(output, "Factory_result pdn state is %s\n",state<0?"disconnect":"connect");
    emResultNotify(output,command);
    return 0;
}
int eventDeactiveDataCall(int command)
{
    int32_t token;
    int state=0;
    char output[1024] = {0};
    token = lynq_data_dectivate_data_call(&state);
    //printf("pdn state is %s\n",state<0?"connect":"disconnect");
    sprintf(output, "Factory_result pdn state is %s\n",state<0?"connect":"disconnect");
    emResultNotify(output,command);
    return 0;
}
int eventGetDataCalllist(int command)
{
    int32_t token=0;
    char output[1024] = {0};
    int num=5;
    int realNum=0;
    LYNQ_Data_Call_Response_v11 **msg=(LYNQ_Data_Call_Response_v11**)malloc(sizeof(LYNQ_Data_Call_Response_v11*)*num);
    if (msg == NULL)
    {
        printf("malloc LYNQ_Data_Call_Response_v11 fail \n");
        return -1;
    }
    for(int i =0;i<num;i++)
    {
        msg[i] = (LYNQ_Data_Call_Response_v11*)malloc(sizeof(LYNQ_Data_Call_Response_v11));
        if (msg[i]==NULL)
        {
            for (int n=0;n<i;n++)
            {
                free(msg[n]);
            }
            return -1;
        }
        memset(msg[i],0,sizeof(LYNQ_Data_Call_Response_v11));
    }
    token = lynq_get_data_call_list(msg, num,&realNum);
    /*
    for(int i = 0; i<realNum; i++)
    {
        printf("status is %d,\nsuggestedRetryTime is %d,\ncid is %d,\nactive is %d,\nmtu is %d\n",msg[i]->status,msg[i]->suggestedRetryTime,msg[i]->cid,msg[i]->active,msg[i]->mtu);
        printf("type is %s\n",msg[i]->type);
        printf("ifname is %s\n",msg[i]->ifname);
        printf("addresses is %s\n",msg[i]->addresses);
        printf("dnses is %s\n",msg[i]->dnses);
        printf("gateways is %s\n",msg[i]->gateways);
        printf("pcscf is %s\n",msg[i]->pcscf);
    }
    */
    if(realNum>0)
    {
        sprintf(output, "Factory_result error code 1\n");
        emResultNotify(output,command);
    }
    else
    {
        sprintf(output, "Factory_result error code 2\n");
        emResultNotify(output,command);
    }
    for (int i = 0; i < num; i++) 
    {
        if (msg[i]!=NULL)
        {    
            free(msg[i]);
            msg[i]=NULL;
        }
    }
    free(msg);
    msg=NULL;
    return 0;
}

int eventGetSimStatus(int command)
{
    static int32_t token=0;
    char output[1024] = {0};
    simStatus * sim_status=NULL;
    sim_status = (simStatus *)malloc(sizeof(simStatus));
    token = lynq_get_sim_status(sim_status);
    //printf("card_status:%d,card_type:%d,pin_state:%d,error_code:%d,request:%d,token:%x\n",sim_status->card_status,
        //sim_status->card_type,sim_status->pin_state,sim_status->base.e,sim_status->base.request,sim_status->base.token);
    RLOGD("card_status:%d,card_type:%d,pin_state:%d,error_code:%d,request:%d,token:%x",sim_status->card_status,
        sim_status->card_type,sim_status->pin_state,sim_status->base.e,sim_status->base.request,sim_status->base.token);
    sprintf(output, "Factory_result error code %d\n",sim_status->base.e);
    emResultNotify(output,command);
    if (sim_status->base.e==-1)
    {
        free(sim_status);
        sim_status=NULL;
        return -1;
    }
    free(sim_status);
    sim_status=NULL;
    return 0;
}
int eventGetImsi(int command)
{
    simImsi msg;
    char output[1024] = {0};
    lynq_get_imsi(&msg);
    //printf("request is %d, token is %x,error_code %d,imsi is %s\n",msg.base.request,msg.base.token, msg.base.e,msg.imsi);
    RLOGD("request is %d, token is %x,error_code %d,imsi is %s",msg.base.request,msg.base.token, msg.base.e,msg.imsi);
    sprintf(output, "Factory_result error code %d\n",msg.base.e);
    emResultNotify(output,command);
    if (msg.base.e==-1)
    {
        return -1;
    }
    return 0;
}
int eventSendSms(const char *telephonyNumber, const char *msgcont,int command)
{
    int32_t token=0;
    char output[1024] = {0};
    smsResponse msg;
    msg.smsResp.ackPDU=NULL;
    //const char *telephonyNumber ="10086";
    //const char * msgcont = "103";
    token = lynq_send_sms(telephonyNumber, 0,msgcont, NULL,&msg);
    //printf("request is %d,token is %x,error is %d,\nmessageRef is %d,ackPDU is %s,errorCode is %d\n",msg.base.request,msg.base.token,msg.base.e,
        //msg.smsResp.messageRef,msg.smsResp.ackPDU,msg.smsResp.errorCode);
    RLOGD("request is %d,token is %x,error is %d,messageRef is %d,ackPDU is %s,errorCode is %d",msg.base.request,msg.base.token,msg.base.e,
        msg.smsResp.messageRef,msg.smsResp.ackPDU,msg.smsResp.errorCode);
    sprintf(output, "Factory_result error code %d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventImsSendSms(const char *telephonyNumber, const char *msgcont,int command)
{
    int32_t token=0;
    char output[1024] = {0};
    smsResponse msg;
    msg.smsResp.ackPDU=NULL;
    //const char *telephonyNumber ="10086";
    //const char * msgcont = "103";
    const char* retryNum ="0";
    const char *messageRef = "201";
    token = lynq_Ims_send_sms(telephonyNumber, 0,msgcont,retryNum,messageRef, NULL,&msg);
    //printf("request is %d,token is %x,error is %d,\nmessageRef is %d,ackPDU is %s,errorCode is %d\n",msg.base.request,msg.base.token,msg.base.e,
        //msg.smsResp.messageRef,msg.smsResp.ackPDU,msg.smsResp.errorCode);
    RLOGD("request is %d,token is %x,error is %d,messageRef is %d,ackPDU is %s,errorCode is %d",msg.base.request,msg.base.token,msg.base.e,
        msg.smsResp.messageRef,msg.smsResp.ackPDU,msg.smsResp.errorCode);
    sprintf(output, "Factory_result error code %d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventWriteSmsToSim(int smsStatus,const char *recPhonNum, const char *msgcont,int command)
{
    int32_t token=0;
    char output[1024] = {0};
    messageStoreInfo msg;
    //const int smsStatus = 2;
    //const char *recPhonNum = "10086";
    //const char *msgcont = "103";
    token = lynq_write_sms_to_sim(smsStatus,recPhonNum,0,msgcont,NULL,&msg);
    //printf("request is %d,token is %x,error is %d,\nmessage strore index is %d\n",msg.base.request,msg.base.token,msg.base.e,
        //msg.msgStoreIndex);
    RLOGD("request is %d,token is %x,error is %d,\nmessage strore index is %d\n",msg.base.request,msg.base.token,msg.base.e,
        msg.msgStoreIndex);
    sprintf(output, "Factory_result error code %d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventReportSmsMemoryStatus(const int value,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_report_sms_memory_status(value,&msg);
    //printf("request is %d,token is %x,error is %d,\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code %d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventDeletSmsOnSim(const int value,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    lynq_delet_sms_on_sim(value,&msg);
    //printf("request is %d,token is %x,error is %d,\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code %d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int eventGetSmscAddress(int command)
{
    smscCbInfo msg;
    char output[1024] = {0};
    lynq_get_smsc_address(&msg);
    //printf("request is %d,token is %x,error is %d,smsc address is %s\n",msg.base.request,msg.base.token,msg.base.e,msg.smsc);
    RLOGD("request is %d,token is %x,error is %d,smsc address is %s",msg.base.request,msg.base.token,msg.base.e,msg.smsc);
    sprintf(output, "Factory_result error code %d\n",msg.base.e);
    emResultNotify(output,command);
    return 0;
}
int eventSetSmscAddress(const char* serviceNumber,int command)
{
    lynqBase msg;
    char output[1024] = {0};
    //const char* serviceNumber = "+8613800280500";
    lynq_set_smsc_address(serviceNumber,&msg);
    //printf("request is %d,token is %x,error is %d,\n",msg.request,msg.token,msg.e);
    RLOGD("request is %d,token is %x,error is %d",msg.request,msg.token,msg.e);
    sprintf(output, "Factory_result error code %d\n",msg.e);
    emResultNotify(output,command);
    return 0;
}
int callController(int *item, char *value,int command);
int networkcontroller(int *item, char *value,int command);
int datacontroller(int *item, char *value,int command);
int simcontroller(int *item, char *value,int command);
int smscontroller(int *item, char *value,int command);
int ril_test(int *item, char *value,char *data,int command) {
    int ril_api_choice = item[2];
    switch (ril_api_choice) {
        case CALL_API:
        {
            callController(item,value,command);
            break;
        }
        case NETWORK_API:
        {
            networkcontroller(item,value,command);
            break;
        }
        case DATA_API:
        {
            datacontroller(item,value,command);
            break;
        }
        case SMS_API:
        {
            smscontroller(item,value,command);
            //RLOGD("test_api,RIL_API");
            break;
        }
        case SIM_API:
        {
            simcontroller(item,value,command);
            break;
        }
        default:
            break;
    }
    printf("value:%s\n",value);
    return 0;
}
int callController(int *item, char *value,int command)
{
    int call_api_choice = item[3];
    char output[1024] = {0};
    switch(call_api_choice)
    {
        case DAIL:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventDial(argv[1],command);
            }
            else
            {
                sprintf(output, "please input caavaliable call number,and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case ANSWER_CALL:
        {
            eventAnswer(command);
            break;
        }
        case HANGUP_CALL:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventCallHangUp(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output, "please input call id,and try again!\n");
                emResultNotify(output ,command);
            }
            break;
        }
        case REJECT_CALL:
        {
            eventRejectCall(command);
            break;
        }
        case AUTO_ANSWER_CALL:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventAutoAnswer(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input auto answer mode value:0 or 1,and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case SET_MUTE_STATUS:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventSetMute(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input set mute mode:0 or 1,and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case GET_MUTE_STATUS:
        {
            eventGetMute(command);
            break;
        }
        case SET_DTMF:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventSetDTMF(argv[1][0],command);
            }
            else
            {
                sprintf(output,"please input DTMF value:0-9,8,#,and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case SET_DTMF_V:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventSetDTMFVolume(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input volume value,0-36,and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case DO_MULTI_CONF:
        {
            eventDoMultiConference(command);
            break;
        }
        case OTHER_CALL_HOLD:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventOthercallHold(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input call id, and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case HANGUP_WAITING_CALL:
        {
            eventHangupWatingForCall(command);
            break;
        }
        case HANGUP_FORE_RES_BACK:
        {
            eventHangupForegroundResumeBackground(command);
            break;
        }
        case SWITCH_HOLD_AND_ACTIVE_CALL:
        {
            eventSwitchWaitOrHoldAndActiveCall(command);
            break;
        }
        case GET_LAST_CALL_FAIL_CAUSE:
        {
            eventLastCallFailCause(command);
            break;
        }
        default:
            break;
    }
    return 0;
}
int networkcontroller(int *item, char *value,int command)
{
    int network_api_choice = item[3];
    char output[1024] = {0};
    switch(network_api_choice)
    {
        case QUERY_OPERATOR:
        {
            eventQueryOperator(command);
            break;
        }
        case QUERY_NETWORK_SELECTION_MODE:
        {
            eventQueryNetSelectMode(command);
            break;
        }
        case SET_NETWORK_SELECTION_MODE:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventSetNetSelectMode(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input network selection mode 0 or 1, and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case QUERY_AVAILABLE_NETWORKS:
        {
            eventQueryAvailableNetwork(command);
            break;
        }
        case QUERY_REGISTRATION_STATE:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventQueryRegistrationState(argv[1],command);
            }
            else
            {
                sprintf(output,"please input type voice,data,or ims, and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case GET_PREFERRED_NETWORK_TYPE:
        {
            eventQueryPrefferredNetworkType(command);
            break;
        }
        case SET_PREFERRED_NETWORK_TYPE:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventSetPrefferredNetworkType(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input preferred network type value , and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case GET_CELL_INFO_LIST:
        {
            eventQueryCellInfo(command);
            break;
        }
        case SET_UNSOL_CELL_INFO_LIST_RATE:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventSetUnsolCellInfoListrate(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input unsolicited cell infomation list rate , and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case GET_NEIGHBORING_CELL_IDS:
        {
            eventQueryNeighboringCellids(command);
            break;
        }
        case SET_BAND_MODE:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventSetBandMode(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input band mode, and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case QUERY_AVAILABLE_BAND_MODE:
        {
            eventQueryAvailableBandmode(command);
            break;
        }
        case RADIO_POWER:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventRadioOn(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input radio power status value 0 or 1, and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case VOICE_RADIO_TECH:
        {
            eventQueryRadioTech(command);
            break;
        }
        case SIGNAL_STRENGTH:
        {
            eventSolicitedSignalStrength(command);
            break;
        }
        case MODEM_POWER:
        {
            int num=0;
            char *argv[2]={0};
            if(num=parseParam(1, value,argv))
            {
                eventModemOn(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input modem power status value 0 or 1, and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        default:
            break;
    }
    return 0;
}
int datacontroller(int *item, char *value,int command)
{
    int data_api_choice = item[3];
    char output[1024] = {0};
    switch(data_api_choice)
    {
        case SETUP_DATA_CALL:
        {
            eventSetupDataCall(command);
            break;
        }
        case DEACTIVATE_DATA_CALL:
        {
            eventDeactiveDataCall(command);
            break;
        }
        case GET_DATA_CALL_LIST:
        {
            eventGetDataCalllist(command);
            break;
        }
        default:
            break;
    }
    return 0;
}
int simcontroller(int *item, char *value,int command)
{
    int sim_api_choice = item[3];
    char output[1024] = {0};
    switch(sim_api_choice)
    {
        case GET_SIM_STATUS:
        {
            eventGetSimStatus(command);
            break;
        }
        case GET_IMSI:
        {
            eventGetImsi(command);
            break;
        }
        default:
            break;
    }
    return 0;
}
int smscontroller(int *item, char *value,int command)
{
    int sms_api_choice = item[3];
    char output[1024] = {0};
    switch(sms_api_choice)
    {
        case SEND_SMS:
        {
            int num=0;
            char *argv[MAX_P]={0};
            if(num=parseParam(2, value,argv))
            {
                eventSendSms(argv[1], argv[2],command);
            }
            else
            {
                sprintf(output,"please input phone number and message, and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case IMS_SEND_SMS:
        {
            int num=0;
            char *argv[MAX_P]={0};
            if(num=parseParam(2, value,argv))
            {
                eventImsSendSms(argv[1], argv[2],command);
            }
            else
            {
                sprintf(output,"please input phone number and message, and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case WRITE_SMS_TO_SIM:
        {
            int num=0;
            char *argv[MAX_P]={0};
            if(num=parseParam(3, value,argv))
            {
                eventWriteSmsToSim(atoi(&argv[1][0]),argv[2], argv[3],command);
            }
            else
            {
                sprintf(output,"please input sms status,phone number and message, and try again!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case REPORT_SMS_MEMORY_STATUS:
        {
            int num=0;
            char *argv[MAX_P]={0};
            if(num=parseParam(1, value,argv))
            {
                eventReportSmsMemoryStatus(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input memory status 0 or 1,and try agin!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case DELETE_SMS_ON_SIM:
        {
            int num=0;
            char *argv[MAX_P]={0};
            if(num=parseParam(1, value,argv))
            {
                eventDeletSmsOnSim(atoi(&argv[1][0]),command);
            }
            else
            {
                sprintf(output,"please input sms index,and try agin!\n");
                emResultNotify(output,command);
            }
            break;
        }
        case GET_SMSC_ADDRESS:
        {
            eventGetSmscAddress(command);
            break;
        }
        case SET_SMSC_ADDRESS:
        {
            int num=0;
            char *argv[MAX_P]={0};
            if(num=parseParam(1, value,argv))
            {
                eventSetSmscAddress(argv[1],command);
            }
            else
            {
                sprintf(output,"please input serviceNumber,and try agin!\n");
                emResultNotify(output,command);
            }
            break;
        }
    }
    return 0;
}

