#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "Write sms to sim"
if [ "$1" == "-h" ]
then
	echo -E "WriteSMSToSIM <Status: UnRead|Read|UnSent|Sent> <Receiver Number> <charSet> <Message Content> [SMS Center Number]"
	exit 0
fi

if [ "$1" == "UnRead" ]
then
	Status="0"
elif [ "$1" == "Read" ]
then
	Status="1"
elif [ "$1" == "UnSent" ]
then
	Status="2"
elif [ "$1" == "Sent" ]
then
	Status="3"
else
	echo -E "Status is invaild!"
	exit 1
fi

ReceiverNum=$2
CharSet=$3
MessageStr=$4
SmscNum=$5

echo -E "Write $1 message ${MessageStr} to SIM with Receiver Number ${ReceiverNum}."
echo -E "SMS center Number is $SmscNum."

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_WRITE_SMS_TO_SIM $Status $ReceiverNum $CharSet \"$MessageStr\" $SmscNum " >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0