#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "Set call forwarding"
if [ "$1" == "-h" ]
then
	echo -E "Usage:$0  <Status:disable=0|enable=1|registeration=3|erasure=4> <cfreason>  <Phone Number> <Time:second> <service_code>"
	exit 0
fi

if [ "$#" != 5 ]
then
	echo -E "Usage:$0  <Status:disable=0|enable=1|registeration=3|erasure=4>  <cfreason>  <Phone Number> <Time:second> <service_code>"
	exit 1
fi

if [ "$1" == "0" ]
then
	Status="0"
elif [ "$1" == "1" ]
then
	Status="1"
elif [ "$1" == "3" ]
then
	Status="3"
elif [ "$1" == "4" ]
then
	Status="4"
else
	echo -E "Status is invaild!"
	exit 1
fi

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_SET_CALL_FORWARD $Status $2 $3 $4 $5" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
