// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SRC_UTIL_RATCONFIGURATION_H_
#define SRC_UTIL_RATCONFIGURATION_H_

#include <string>
class RatConfiguration {
public:
    RatConfiguration();
    virtual ~RatConfiguration();
    static const std::string PROPERTY_BUILD_RAT_CONFIG;
    /* the system property of active rat */
    static const std::string PROPERTY_RAT_CONFIG;
    static const std::string PROPERTY_IS_USING_DEFAULT_CONFIG;
    /* the valid characters of the human-readable rat config */
    /* the defination must be sync with ratconfig.c */
    static const std::string NR;
    static const std::string CDMA;
    static const std::string LteFdd;
    static const std::string LteTdd;
    static const std::string WCDMA;
    static const std::string TDSCDMA;
    static const std::string GSM;
    static const std::string DELIMITER;

    /* bitmask */
    /* the defination must be sync with ratconfig.c */
    static const int MASK_NR;
    static const int MASK_CDMA;
    static const int MASK_LteFdd;
    static const int MASK_LteTdd;
    static const int MASK_WCDMA;
    static const int MASK_TDSCDMA;
    static const int MASK_GSM;

    static const int MD_MODE_UNKNOWN;
    static const int MD_MODE_LTG;   //uLTG
    static const int MD_MODE_LWG;   //uLWG
    static const int MD_MODE_LWTG;  //uLWTG
    static const int MD_MODE_LWCG;  //uLWCG
    static const int MD_MODE_LWCTG;  //uLWTCG(Auto mode)
    static const int MD_MODE_LTTG;  //LtTG
    static const int MD_MODE_LFWG;  //LfWG
    static const int MD_MODE_LFWCG;  //uLfWCG
    static const int MD_MODE_LCTG;  //uLCTG
    static const int MD_MODE_LTCTG;  //uLtCTG

    static int max_rat;
    static bool max_rat_initialized;
    static int actived_rat;
    static bool is_default_config;
public:
    static int ratToBitmask(std::string rat);
    static int getMaxRat();
    static bool checkRatConfig(int iRat);
    static int getRatConfig();
    static std::string ratToString(int iRat);
    static bool isC2kSupported();
    static bool isLteFddSupported();
    static bool isLteTddSupported();
    static bool isWcdmaSupported();
    static bool isTdscdmaSupported();
    static bool isGsmSupported();
    static bool isNrSupported();
    static std::string getActiveRatConfig();

};

#endif /* SRC_UTIL_RATCONFIGURATION_H_ */
