#include <stdio.h>
#include <string.h>
#include<stdlib.h>
#include <time.h>
#include <include/lynq_uci.h>
#include "lynq_systime.h"


#define LYNQ_SYNC_TIME_SECTION "lynq_sync_time"
#define LYNQ_MODEM_TIME_KEY "lynq_modem_sync_time_enable"
#define LYNQ_GNSS_TIME_KEY "lynq_gnss_sync_time_enable"

#define BUF_LEN 258
#define  TIME_BUF 100

#define  NTP_RESTART_BUF "systemctl restart ntpd"
#define  NTP_STOP_BUF "systemctl stop ntpd"

#define SYNC_TIME_SUCCESS 0

#define NTP_ALREADY_ENABLE  1
#define NTP_ALREADY_DISABLE 2

//#define NITZ_ALREADY_ENABLE  3
//#define NITZ_ALREADY_DISABLE 4
//#define GNSS_ALREADY_ENABLE  5
//#define GNSS_ALREADY_DISABLE 6
#define OPEN_ERROR 7
#define ERROR_PARA 8

char* lynq_read_version()
{
    return "SYSTIME_V1.0";
}

int get_cmd_value(char *input_cmd, char *value)
{
    FILE * fp = NULL;
    char buf[TIME_BUF] = {0};

    fp = popen (input_cmd, "r");

    if (!fp) {  
        printf("popen error\n");
        return OPEN_ERROR;
    } 
	
    while(fgets(buf, sizeof(buf), fp)!=NULL){
        strcat(value, buf);
    }

    pclose(fp);
    return 0;
}

int user_set_time(char *date_input, char *time_input)
{
    char date[TIME_BUF] = "";
    char time[TIME_BUF] = "";

    if(NULL == date_input || NULL == time_input)
        return ERROR_PARA;

    sprintf(date, "date -s %s", date_input);
    sprintf(time, "date -s %s", time_input);

    system(date);
    system(time);
    system("hwclock -w -f /dev/rtc0");
    return 0;
}

int ntp_sync_time(int enable)
{
    char cmd_buf[TIME_BUF] = "pgrep ntpd";
    char out_value[TIME_BUF] = {0};
    
    if(enable != 0 && enable !=1)
        return ERROR_PARA;
	
    get_cmd_value(cmd_buf, out_value);
    if(strlen(out_value))
    {
        if(enable)
        {
            return NTP_ALREADY_ENABLE;
        }
        else{
            system(NTP_STOP_BUF);
            return SYNC_TIME_SUCCESS;
        }
    }
    else{
        if(enable)
        {
            system(NTP_RESTART_BUF);
            return SYNC_TIME_SUCCESS;
        }
        else{
            return NTP_ALREADY_DISABLE;
        }	
    }
}

int modem_time_enable(int enable)
{
    char buf[BUF_LEN] = "";
    int ret = 0;
    
    if(enable != 0 && enable !=1)
        return ERROR_PARA;
    
    if(enable)
    {
        //system("killall ntpd");
        sprintf(buf,"%s.%s.%s=%d", LYNQ_UCI_FILE, LYNQ_SYNC_TIME_SECTION, LYNQ_MODEM_TIME_KEY, enable);
        ret = lynq_uci_set(buf);
    }
    else
    {
        sprintf(buf,"%s.%s.%s=%d", LYNQ_UCI_FILE, LYNQ_SYNC_TIME_SECTION, LYNQ_MODEM_TIME_KEY, enable);
        ret = lynq_uci_set(buf);
    }
	
    return ret;
}

int gnss_time_enable(int enable)
{
    char buf[BUF_LEN] = "";
    int ret = 0;
    
    if(enable != 0 && enable !=1)
        return ERROR_PARA;
    
    if(enable)
    {
        //system("killall ntpd");
        sprintf(buf,"%s.%s.%s=%d", LYNQ_UCI_FILE, LYNQ_SYNC_TIME_SECTION, LYNQ_GNSS_TIME_KEY, enable);
        ret = lynq_uci_set(buf);
    }
    else
    {
        sprintf(buf,"%s.%s.%s=%d", LYNQ_UCI_FILE, LYNQ_SYNC_TIME_SECTION, LYNQ_GNSS_TIME_KEY, enable);
        ret = lynq_uci_set(buf);
    }
	
    return ret;
}
