/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include "GostEcallUtils.h"
#include "GsmUtils.h"

#include <string>
#include <cstdio>


using namespace std;

#undef LOG_TAG
#define LOG_TAG "DEMO_ECALL_GOST_UTILS"

string getResultCode(int code) {
    MTK_RLOGD("code=%d",code);
    switch(code){
    case EGTS_PC_OK: return "Processing Succeeded";
    case EGTS_PC_IN_PROGRESS: return "Processing in progress(processing result is not known yet";
    case EGTS_PC_UNS_PROTOCOL: return "protocol not supported";
    case EGTS_PC_DECRYPT_ERROR: return "Decryption error";
    case EGTS_PC_PORC_DENIED: return "Processing not permitted";
    case EGTS_PC_INC_HEADERFORM: return "Incorrect header format";
    case EGTS_PC_INC_DATAFORM: return "Incorrect data format";
    case EGTS_PC_UNS_TYPE: return "Type not supported";
    case EGTS_PC_NOTEN_PARAMS: return "Incorrect number of parameters";
    case EGTS_PC_DBL_PROC: return "Processing retry attempt";
    case EGTS_PC_PROC_SRC_DENIED: return "Data Processing not permitted for this source";
    case EGTS_PC_HEADERCRC_ERROR: return "Header checksum error";
    case EGTS_PC_DATACRC_ERROR: return "Data checksum error";
    case EGTS_PC_INVDATALEN: return "Invalid data length";
    case EGTS_PC_ROUTE_NFOUND: return "Route not found";
    case EGTS_PC_ROUTE_CLOSED: return "Route closed";
    case EGTS_PC_ROUTE_DENIED: return "Route not permitted";
    case EGTS_PC_INVADDR: return "Invalid address";
    case EGTS_PC_TTLEXPIRED: return "Time to live expired";
    case EGTS_PC_NO_ACK: return "No acknowledgement reeived";
    case EGTS_PC_OBJ_NFOUND: return "Object not found";
    case EGTS_PC_EVENT_NFOUND: return "Event not found";
    case EGTS_PC_SRVC_NFOUND: return "Service not found";
    case EGTS_PC_SRVC_DENIED: return "Service denied";
    case EGTS_PC_SRVC_UNKN: return "Service type unknown";
    case EGTS_PC_AUTH_DENIED: return "Authorisation denied";
    case EGTS_PC_ALREADY_EXISTS: return "Object already present";
    case EGTS_PC_ID_NFOUND: return "Identifier not found";
    case EGTS_PC_INC_DATETIME: return "Incorrect data and time";
    case EGTS_PC_IO_ERROR: return "Input/output error";
    case EGTS_PC_NO_RES_AVAIL: return "Insufficient resources";
    case EGTS_PC_MODULE_FAULT: return "Internal module fault";
    case EGTS_PC_MODULE_PWR_FLT: return "Power circuit fault";
    case EGTS_PC_MODULE_PROC_FLT: return "Module processor fault";
    case EGTS_PC_MODULE_SW_FLT: return "Module software fault";
    case EGTS_PC_MODULE_FW_FLT: return "Module firmware fault";
    case EGTS_PC_MODULE_IO_FLT: return "Module I/O fault";
    case EGTS_PC_MODULE_MEM_FLT: return "Internal module memory fault";
    case EGTS_PC_TEST_FAILED: return "Test failed";
    default: return "unknown";
    }
}

std::string decodeData(const std::string &str, std::uint32_t offset, const std::string &tag, std::uint32_t &index) {
    uint32_t len = str.size();
    if (len < (index + offset*2)) {
        MTK_RLOGW("decode %s fail, len(%d) < to_len(%d)", tag.c_str(), len,index + offset*2);
        return "";
    }
    std::string sub = str.substr(index, offset*2);
    MTK_RLOGD("before %s(from:%d, offset: %d): %s", tag.c_str(),index, offset*2, sub.c_str());
    index = index + offset*2;
    return sub;
}

int64_t decodeValue(const std::string &str, std::uint32_t &index,std::uint32_t offset, const std::string &tag) {
    if(offset != 2 && offset != 4 &&  offset != 8) {
        MTK_RLOGW("%s offset(%d) is invalid, just return ", tag.c_str(), offset);
        return -1;
    }
    uint32_t len = str.size();
    if (len < (index + offset)) {
        MTK_RLOGW("decode %s fail, len(%d) < to_len(%d)", tag.c_str(), len,
                index + offset);
        //return -1;
    }
    std::string sub = str.substr(index, offset);
    //RLOGD("before %s(from:%d, offset: %d): %s", tag.c_str(), index, offset, sub.c_str());
    index = index + offset;
    int ret = -1;
    switch(offset) {
    case 2:
    {
        ret = gsm_hex2_to_byte(sub.c_str());
        break;
    }
    case 4:
    {
        ret = gsm_hex4_to_short(sub.c_str());
        break;
    }
    case 8:
    {
        ret = gsm_hex8_to_int(sub.c_str());
        break;
    }
    default:
    {
        MTK_RLOGW("%s offset(%d) is invalid, just return ", tag.c_str(), offset);
        return -1;
    }
    }

    if(ret == -1) {
        MTK_RLOGW("decode %s(gsm_hex%d_to_xxx) fail", tag.c_str(), offset);
        return -1;
    }

    switch(offset) {
    case 2:
    {
        //RLOGD("0X%02x", (uint8_t)ret);
        break;
    }
    case 4:
    {
        //RLOGD("0X%04x", (uint16_t)ret);
        break;
    }
    case 8:
    {
        //RLOGD("0X%08x", (uint32_t)ret);
        break;
    }
    }
    return ret;
}

std::string encodeValue(int64_t value, uint8_t charset, const std::string tag) {
    MTK_RLOGD("value = %lld, charset=%u, encode: %s", value, charset, tag.c_str());
    if((charset != 2) &&(charset != 4) && (charset != 8)) {
        MTK_RLOGW("charset don't support,just return");
        return "";
    }
    char *hex = new char[charset+1]();
    switch(charset) {
    case 2: {
        gsm_hex_from_byte(hex,value);
        break;
    }
    case 4: {
        gsm_hex_from_short(hex,value);
        break;
    }
    case 8: {
        gsm_hex_from_int(hex, value);
        break;
    }
    default: {
        MTK_RLOGW("error");
        return "";
    }
    }
    MTK_RLOGD("%s", hex);
    std::string str(hex, charset);
    MTK_RLOGD("encode(%s=%lld) is : %s",tag.c_str(), value, str.c_str());
    delete [] hex;
    hex = NULL;
    return str;
}
