/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
 #include "lib_tele.h"
#ifndef __LYNQ_NETWORK__
#define __LYNQ_NETWORK__
#ifdef __cplusplus
extern "C" {
#endif
typedef struct{
    lynqBase base;
    char *OperatorFN;    //It is long alpha ONS or EONS
    char *OperatorSH;    //It is short alpha ONS or EONS
    char *MccMnc;        //It is 5 or 6 digit numeric code (MCC + MNC)
}operatorInfo;
typedef struct{
    lynqBase base;
    char *OperatorFN;
    char *OperatorSH;
    char *MccMnc;
    char * NetStatus;   //a string value of the status: "unknown","available","current","forbidden"
}availableNetwork;

typedef struct{
    lynqBase base;
    int mode;
}networkSelecttionMode;
typedef struct{
    lynqBase base;
    int     regState;               //registration state
    int     imsRegState;
    char *  LAC;                    //location area code, it is LAC if registered or NULL id not
    char *  CID;                    //cell identifier, if registered or NULL id not.
    RIL_RadioTechnology netType;    //network type
    RIL_RadioTechnologyFamily radioTechFam;//RIL_RadioTechnologyFamily
}registrationStateInfo;

typedef struct{
    lynqBase base;
    RIL_RadioTechnology radioTech;
}radioTechnology;

typedef struct{
    lynqBase base;
    int pnt; //preffered network type.
}prefferredNetworkType;
typedef struct{
    lynqBase base;
    char *cid;
    int rssi;
}neighboringCellIDs;
typedef struct{
    lynqBase base;
    int bandmode[20];
}availableBandMode;
typedef struct{
    lynqBase base;
    RIL_CellInfo cellinfo;
}cellInfoList;
typedef struct{
    lynqBase base;
    RIL_SignalStrength_v10 signalStrength;
}solicitedSignalStrength;
int lynq_query_operater(operatorInfo * currentOperator);
int lynq_query_network_selection_mode(networkSelecttionMode *netselMode);
int lynq_set_network_selection_mode(const char *mode,const char* mccmnc,lynqBase * base);
int lynq_query_available_network(availableNetwork *availNet);
int lynq_query_registration_state(const char *type,registrationStateInfo *regStateInfo);
int lynq_query_prefferred_networktype(prefferredNetworkType * preNetType);
int lynq_set_prefferred_networktype(const int preffertype,lynqBase * base);
int lynq_query_cell_info(cellInfoList * * cellinfo, int listNum, int * realNum);
int lynq_set_unsol_cell_info_listrate(const int rate,lynqBase * base);
int lynq_query_neighboring_cellids(neighboringCellIDs **neiCeIDs,const int listNum,int *realNum);
int lynq_set_band_mode(const int bandmode,lynqBase *base);
int lynq_query_available_bandmode(availableBandMode*availBanMode);
int lynq_radio_on(const int data,lynqBase *base);
int lynq_query_radio_tech(radioTechnology *radioTech);
int lynq_solicited_signal_strength(solicitedSignalStrength *solSigStren);
int lynq_modem_on(const int data,lynqBase *base);
//int  lynq_enter_network_depersonalization(char *code);

#ifdef __cplusplus
}
#endif

#endif



