#include "model_manager.h"
#include "list.h"
#include "thread_pool.h"
#include "common.h"
#include <signal.h>
#include <stdio.h>
#include <malloc.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <unistd.h> 
//#include <libtel/lib_tele.h>
#include "liblynq-broadcast/broadcast_receiver.h"


#define USER_LOG_TAG "THHANDLE" 
#define MIN_THR_NUM 	10
#define MAX_THR_NUM 	100



thread_pool_t *pool = NULL;
char cmd_buf[BUF_SIZE] = "";

static void CallbackByName( char*broadcast_name, int data_length,const char*data)
{
    LYDBGLOG("[%s-%d] str_arg = %s, data_length = %d, int_arg = %s\n", broadcast_name, data_length, data);
    memcpy(cmd_buf, data, strlen(data));

    return;
}

void *cmd_thread_func(void* argv_list)
{
	int runing = 1 ;
	int ret = NO_ERROR;
	
	while(runing)
	{		
		char result[20][BUF_SIZE] = {0};
		while (strcmp(cmd_buf, "") == 0) {
			usleep(100);
		}
		LYDBGLOG("[%s-%d]========cmd_buf = %s\n", __FUNCTION__, __LINE__, cmd_buf );
		int line = str_arr(cmd_buf, "\"&", result)+1;
		memset(cmd_buf, 0, sizeof(cmd_buf));
		LYDBGLOG("[%s-%d]========result[0] = %s\n", __FUNCTION__, __LINE__, result[0] );
		MAG_LIST_S *list_manager = list_manager_proc(result[0]);
		if (list_manager == NULL) {
			memset(cmd_buf, 0, sizeof(cmd_buf));
			continue;
		}

		ret = list_manager->func_param_verification(result, line);	
		if (ret != NO_ERROR){
			memset(cmd_buf, 0, sizeof(cmd_buf));
			continue;
		}

		list_manager->func_list_init();
		ret = list_manager->func_list_locate();
		if (ret != NO_ERROR)
			continue;
		list_manager->func_act_handler(pool);
	}
}


int main(void)
{
	LYLOGEINIT(USER_LOG_TAG);    
	LYDBGLOG("======lynq-threadhandle start=======\n");
	pool = threadpool_create(MIN_THR_NUM, MAX_THR_NUM);

	register_broadcast_loop();
	receive_callback_by_name("function", CallbackByName);//rita add @2021.6.21 for receive dbus info
	
	if (!threadpool_add(pool, cmd_thread_func, NULL)) {
		LYVERBLOG("+[thhandle]: error num = %d\n", ERR_INVOKE);
		return 0;
	}
	
	while (1) {
		usleep(100);
	}
	return 0;
}
