/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SSLP_COMMANDS_CMDUTILS_H_
#define SSLP_COMMANDS_CMDUTILS_H_

#include <cstdint>
#include <string>

class CmdUtils {
public:
    CmdUtils();
    virtual ~CmdUtils();
    int decodeCmdCommand(std::uint16_t cmd, const std::string& data);

    static bool isCmdCommands(std::uint16_t cmd);
public:
    //sub records;
    static constexpr std::uint8_t EGTS_SR_RECORD_RESPONSE = 0;
    static constexpr std::uint8_t EGTS_SR_COMMAND_DATA = 51;

    //List of commands sent to IVDS table 32 p40;
    static constexpr std::uint16_t EGTS_RAW_DATA = 0x0000;
    static constexpr std::uint16_t EGTS_TEST_MODE = 0x0001;
    static constexpr std::uint16_t EGTS_CONFIG_RESET = 0x0006;
    static constexpr std::uint16_t EGTS_SET_AUTH_CODE = 0x0007;
    static constexpr std::uint16_t EGTS_RESTART = 0x0008;

    //list of acknowledgements for commands and messages, table 33 p41
    //    static constexpr std::uint16_t EGTS_RAW_DATA = 0x0000;

    //LIst of IVDS parameters table34 p41;
    //radio mute
    static constexpr std::uint16_t EGTS_RADIO_MUTE_DELAY = 0x0201;
    static constexpr std::uint16_t EGTS_RADIO_UNMUTE_DELAY = 0x0202;
    //GEneral-purpose settings
    static constexpr std::uint16_t EGTS_GPRS_APN = 0x0203;
    static constexpr std::uint16_t EGTS_SERVER_ADDRESS = 0x0204;
    static constexpr std::uint16_t EGTS_SIM_PIN = 0x0205;
    static constexpr std::uint16_t EGTS_INT_MEM_TRANSMIT_INTERVAL = 0x0206;
    static constexpr std::uint16_t EGTS_INT_MEM_TRANSMIt_ATTEMPTS = 0x0207;
    //test mode
    static constexpr std::uint16_t EGTS_TEST_REGISTRATION_PERIOD = 0x0242;
    static constexpr std::uint16_t EGTS_MODE_END_DISTANCE = 0x020A;
    //service station mode
    static constexpr std::uint16_t EGTS_GARAGE_MODE_END_DISTANCE = 0x020B;
    static constexpr std::uint16_t EGTS_GARAGE_MODE_PIN = 0x020C;
    //Miscellaneous parameters
    static constexpr std::uint16_t EGTS_GNSS_POWER_OFF_TIME = 0x0301;
    static constexpr std::uint16_t EGTS_GNSS_DATA_RATE = 0x0302;
    static constexpr std::uint16_t EGTS_GNSS_MIN_ELEVATION = 0x0303;
    //Device parameters
    static constexpr std::uint16_t EGTS_UNIT_ID = 0x0404;
    static constexpr std::uint16_t EGTS_UNIT_IMEI = 0x0405;
    static constexpr std::uint16_t EGTS_UNIT_RS485_BAUD_RATE = 0x0406;
    static constexpr std::uint16_t EGTS_UNIT_RS485_STOP_BITS = 0x0407;
    static constexpr std::uint16_t EGTS_UNIT_RS485_PARITY = 0x0408;
    static constexpr std::uint16_t EGTS_UNIT_HOME_DISPATCHER_ID = 0x0411;
    static constexpr std::uint16_t EGTS_SERVICE_AUTH_METHOD = 0x0412;
    static constexpr std::uint16_t EGTS_SERVER_CHECK_IN_PERIOD = 0x0413;
    static constexpr std::uint16_t EGTS_SERVER_CHECK_IN_ATTEMPTS = 0x0414;
    static constexpr std::uint16_t EGTS_SERVER_PACKET_TOUT = 0x0415;
    static constexpr std::uint16_t EGTS_SERVER_PACKET_RETRANSMIT_ATTEMPTS = 0x0416;
    static constexpr std::uint16_t EGTS_UINT_MIC_LEVEL = 0x0417;
    static constexpr std::uint16_t EGTS_UINT_SPK_LEVEL = 0x0418;
};

#endif /* SSLP_COMMANDS_CMDUTILS_H_ */
