/*============================================================================= 
#     FileName: lynq_sim.cpp
#     Desc: about SIM API
#     Author: mobiletek 
#     Version: V1.0
#     LastChange: 2020-07-29 
#     History: 
=============================================================================*/
#include <dlfcn.h>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>
#include "lynq_common.h"
#include "lynq_sim.h"
#include <stateManager/stateManager.h>

#undef LOG_TAG
#define LOG_TAG "LYNQ_SIM"
simInfoLink *simInfoLinkHead=NULL;
#define MAX_NUM 10
//for test
#include <stdio.h>

FindOperator findOperator[] = {
#include "storeFile/operator.h"
};

int lynq_sim_init(void){
//    lynq_ril_init();
    return 0;
}

int lynq_sim_deinit(void){
//    lynq_ril_deinit();
    return 0;
}
/*Initialize SIM infomation queue for lynq_sim API.*/
int init_sim()
{
    simInfoLinkHead=createSimInfoLink();
    if(simInfoLinkHead==NULL)
    {
        RLOGD("init sim info link head fail!");
        return -1;
    }
    RLOGD("init sim info link head success!");
    millli_sleep_with_restart(300);//The premise of obtaining imsi is that aid_ptr has been obtained
    return 0;

}

void delete_char(char str[],char target){
	int i,j;
	for(i=j=0;str[i]!='\0';i++){
		if(str[i]!=target){
			str[j++]=str[i];
		}
	}
	str[j]='\0';
}  

simStatus *parceToSimInfo(Parcel &p,int &len)
{
    int32_t res;
    int num=0;
    simStatus *msg=(simStatus *)malloc(sizeof(simStatus));
    p.setDataPosition(0);
    if (p.dataAvail() > 0) 
    {
        p.readInt32(&res);
        msg->card_status = (RIL_CardState)res;
        p.readInt32(&num);
        len = num;
        LYDBGLOG("[%s] num is%d\n ",__FUNCTION__,num);
        for (int i = 0; i < num; i++) //for future.
        {
            p.readInt32(&res);
            msg->card_type = (RIL_AppType)res;
            p.readInt32(&res);
            msg->pin_state = (RIL_PinState)res;
        }
        return msg;
    }
    return NULL;
}
int checkParcelSimInfo(simStatus *msg,int32_t token)
{
    int time_sim =300;//3 s.
    enum{RUN,EXIT}state;
    state=RUN;
    int length=0;
    lynqQueue *node=NULL;
    simStatus *temp=NULL;
    while(time_sim--)
    {
         millli_sleep_with_restart(10);
         node=LynqQueueHead;
         if(node==NULL)
         {
             LYDBGLOG("[%s][%d][%s] Queue head is NULL, maybe malloc fail!",__FUNCTION__,__LINE__,__FILE__);
             continue;
         }
         node = searchTokeninQueue(token, node);
         if(node ==NULL)
         {
             msg->card_status=-1;
             msg->card_type=-1;
             msg->pin_state=-1;
             msg->base.e=-1;
            return -1;
         }
         if(node->t_Errno!=RIL_E_SUCCESS)
         {
             RLOGD("get sim status fail, the error code is %d",node->t_Errno);
             msg->base.e=node->t_Errno;
             msg->card_status=-1;
             msg->card_type=-1;
             msg->pin_state=-1;
             return -1;
         }
         else
         {
             temp = parceToSimInfo(node->parcel,length);
             if(temp ==NULL )
             {
                 continue;
             }
             else
             {
                  msg->card_status=temp->card_status;
                  msg->card_type=temp->card_type;
                  msg->pin_state=temp->pin_state;
                  msg->base.e=node->t_Errno;
                  free(temp);
                  temp=NULL;
                  return 0;
             }
         }
    }
    printf("time_sim is %d\n",time_sim);
    msg->base.e=-1;
    msg->card_status=-1;
    msg->card_type=-1;
    msg->pin_state=-1;
    return -1;
}
/*return 0:success ,1:fail*/
int checkSimInfo(simStatus *msg,int32_t token)
{
    int time_sim =300;//3 s.
    enum{RUN,EXIT}state;
    state=RUN;
    printf("check sim Info start\n");
    simInfoLink *temp;
    while(time_sim--)
    {
     millli_sleep_with_restart(10);
     temp=simInfoLinkHead;
     if(temp==NULL)
     {
         RLOGD("sim info link head is NULL, maybe malloc fail!");
         continue;
     }
     do
     {
       if((temp->simInfoLen!=0)&&(temp->token==token))
       {
           if(temp->Error_tok!=RIL_E_SUCCESS)
           {
               RLOGD("get sim status fail, the error code is %d",temp->Error_tok);
               msg->base.e=temp->Error_tok;
               msg->card_status=-1;
               msg->card_type=-1;
               msg->pin_state=-1;
               return 1;
           }
           else
           {
              msg->card_status=temp->card_status;
              msg->card_type=temp->card_type;
              msg->pin_state=temp->pin_state;
              msg->base.e=temp->Error_tok;
              return 0;
           }
         }
       temp=temp->next;
     }while(temp!=NULL);
    }
    printf("time_sim is %d\n",time_sim);
    msg->card_status=-1;
    msg->card_type=-1;
    msg->pin_state=-1;
    msg->base.e=-1;
    return 0;
}
/*return 0:success ,1:fail*/
int checkParcelImsiInfo(simImsi *msg,int32_t token)
{
    int time_sim =300;//3 s.
    enum{RUN,EXIT}state;
    int num;
    state=RUN;
    printf("check IMSI Info start\n");
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    while(time_sim--)
    {
         millli_sleep_with_restart(10);
         temp=LynqQueueHead;
         if(temp==NULL)
         {
             RLOGD("sim info link head is NULL, maybe malloc fail!");
             continue;
         }
         node = searchTokeninQueue(token, temp);
         if(node ==NULL)
         {
            memset(msg->imsi,0,sizeof(msg->imsi));
            msg->base.e=-1;
            return -1;
         }
         if(node->t_Errno!=RIL_E_SUCCESS)
         {
             RLOGD("get sim status fail, the error code is %d",node->t_Errno);
             msg->base.e=node->t_Errno;
             memset(msg->imsi,0,sizeof(msg->imsi));
             return -1;
         }
         else
         {
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {

                node->parcel.readInt32(&num);
                for(int i =0;i<num;i++)
                {
                   char * str=lynqStrdupReadString(node->parcel);
                   memcpy(msg->imsi,str,strlen(str)+1);
                   msg->base.e=node->t_Errno;
                }
                return 0;
             }
             else
             {
               continue;
             }
         }
    }
    printf("time_sim is %d\n",time_sim);
    msg->base.e=-1;
    memset(msg->imsi,0,sizeof(msg->imsi));
    return 0;
}
int checkImsiInfo(simImsi *msg,int32_t token)
{
    int time_sim =300;//3 s.
    enum{RUN,EXIT}state;
    state=RUN;
    printf("check IMEI Info start\n");
    simInfoLink *temp;
    while(time_sim--)
    {
     millli_sleep_with_restart(10);
     temp=simInfoLinkHead;
     if(temp==NULL)
     {
         RLOGD("sim info link head is NULL, maybe malloc fail!");
         continue;
     }
     do
     {
       if((temp->simInfoLen!=0)&&(temp->token==token))
       {
           if(temp->Error_tok!=RIL_E_SUCCESS)
           {
               RLOGD("get sim status fail, the error code is %d",temp->Error_tok);
               msg->base.e=temp->Error_tok;
               //msg->imsi = NULL;
               memset(msg->imsi,0,sizeof(msg->imsi));
               msg->base.token=token;
               return 1;
           }
           else
           {
              msg->base.e=temp->Error_tok;
              memcpy(msg->imsi,temp->imsi,strlen(temp->imsi)+1);
              //msg->imsi = temp->imsi;
              msg->base.token=token;
              return 0;
           }
         }
       temp=temp->next;
     }while(temp!=NULL);
    }
    memset(msg->imsi,0,sizeof(msg->imsi));
    //msg->imsi = NULL;
    msg->base.token=token;
    msg->base.e=-1;
    return 0;
}

/*If you need to use any API under lynq_sim, you mustfirst call the init_sim() function to initialize these functions.*/
int lynq_get_sim_status(int *card_status)
{   
    int res = -1;
    int32_t token=0;
    if(card_status == NULL)
        return res;
    simStatus *msg = (simStatus *)calloc(1, sizeof(simStatus));
    int length=0;
    lynqQueue *node = NULL;
    int timeout = 500; //timeout is 5s.
    RIL_Errno err = -1;
    simStatus *temp =NULL;
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_GET_SIM_STATUS"};
    if(token = lynqNoneParame(requestStr))
    {
        msg->base.token=token;
        msg->base.request = RIL_REQUEST_GET_SIM_STATUS;
        node = commonUpdateEstatus(token,timeout,err);
        msg->base.e = err;
        res = err;
        if(err != RIL_E_SUCCESS)
        {
            LYDBGLOG("[%s] error code is %d!",__FUNCTION__,err);
            msg->card_status=-1;
            *card_status = msg->card_status;
            msg->card_type=-1;
            msg->pin_state=-1;
            lynqDeQueue(token);
            free(msg);
            msg = NULL;
            return token;
        }
        if(node)
        {
            temp = parceToSimInfo(node->parcel,length);
            if(length ==0)//it means sim card absent
            {
                msg->card_status = 0;
                *card_status = msg->card_status;
                msg->card_type = 0;
                msg->pin_state = 0;
                res = RIL_E_SIM_ABSENT;
            }
            else
            {
                msg->card_status=temp->card_status;
                *card_status = msg->card_status;
                msg->card_type=temp->card_type;
                msg->pin_state=temp->pin_state;
            }
            free(temp);
            temp = NULL;
        }
        lynqDeQueue(token);
    }
    free(msg);
    msg = NULL;
    return res;
}
/*AT> AT+CIMI     AT< IMSI*/
int lynq_get_imsi(char buf[])
{   
    int res = -1;
    int32_t token = 0;
    if(buf == NULL)
        return res;
    simImsi *msg = (simImsi *)calloc(1, sizeof(simImsi));
    lynqQueue *node = NULL;
    int timeout = 500; //timeout is 5s.
    RIL_Errno err = -1;
    int num = 0;
    //memset(msg,0,sizeof(simImsi));
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_GET_IMSI"};
    if(token = lynqNoneParame(requestStr))
    {
        msg->base.request = RIL_REQUEST_GET_IMSI;
        msg->base.token = token;
        node = commonUpdateEstatus(token,timeout,err);
        msg->base.e = err;
        res = err;
        if(err != RIL_E_SUCCESS)
        {
            LYDBGLOG("[%s] error code is %d!",__FUNCTION__,err);
            memset(msg->imsi,0,sizeof(msg->imsi));
            memset(buf,0,sizeof(msg->imsi));
            lynqDeQueue(token);
            free(msg);
            msg = NULL;
            return res;
        }
        if(node)
        {
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {
                node->parcel.readInt32(&num);
                for(int i =0;i<num;i++)//for DSDS.
                {
                   char * str=lynqStrdupReadString(node->parcel);
                   memcpy(msg->imsi,str,strlen(str)+1);
                }
                memcpy(buf,msg->imsi,strlen(msg->imsi));
                buf[strlen(msg->imsi)] = '\0';
            }else{
                res = RIL_E_SIM_ABSENT;
            }
        }
        lynqDeQueue(token);
    }
    free(msg);
    msg = NULL;
    return res;
}


/*add by lei*/

int lynq_get_iccid(char buf[]){
    int res = 0;
    int32_t token = 0;
    if(buf == NULL)
        return res;
    simIccid *msg = (simIccid *)calloc(1, sizeof(simIccid));
    lynqQueue *node = NULL;
    int timeout = 500; //timeout is 5s.
    RIL_Errno err = -1;
    int num = 0;
    //memset(msg,0,sizeof(simImsi));
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_QUERY_ICCID"};
    if(token = lynqNoneParame(requestStr))
    {
        msg->base.request = RIL_REQUEST_QUERY_ICCID;
        msg->base.token = token;
        printf("token : %d\n", token);
        node = commonUpdateEstatus(token,timeout,err);
        msg->base.e = err;
        res = err;
        if(err != RIL_E_SUCCESS)
        {
            LYDBGLOG("[%s] error code is %d!",__FUNCTION__,err);
            memset(msg->iccid,0,sizeof(msg->iccid));
            lynqDeQueue(token);
            free(msg);
            msg = NULL;
            return res;
        }
        if(node)
        {
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {
                node->parcel.readInt32(&num);
                for(int i =0;i<num;i++)//for DSDS.
                {
                   char * str=lynqStrdupReadString(node->parcel);
                   memcpy(msg->iccid,str,strlen(str)+1);
                }
                memcpy(buf, msg->iccid, strlen(msg->iccid));
                buf[strlen(msg->iccid)] = '\0';
            }else{
                res = RIL_E_SIM_ABSENT;
            }
        }
        lynqDeQueue(token);
    }
    free(msg);
    msg = NULL;
    return res;
}

int lynq_enable_pin(char *pin){
    int ret = -1;
    int32_t token = 0;
    if(pin == NULL)
        return ret;
    simOperate *msg = (simOperate *)calloc(1, sizeof(simOperate));
    RIL_Errno err=-1;
    lynqQueue * node = NULL;
    int num = 0;
    int res = 0;
    char *facility = "SC";
    int serviceclass = 11;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_SET_FACILITY_LOCK"};
    token = lynqStringParameOperate_enable(requestStr, facility, pin, serviceclass);
    msg->base.request = RIL_REQUEST_SET_FACILITY_LOCK;
    msg->base.token = token;
    node = commonFindParcelmsg(token,500,err);
    for(int i = 0;i<20;i++)
    {
        msg->state[i]=0;
    }
    if (node!=NULL)
    {
        node->parcel.readInt32(&num);
        msg->state[0]=num;
        for(int i=1;i<=num;i++)
        {
            node->parcel.readInt32(&res);
            msg->state[i]=res;
        }
        char buffer[256] = {0};
        char element[256] = {0};
        if(msg->state[0]>0)
        {
            for(int i =1;i<=msg->state[0];i++)
            {
                sprintf(element,"%d,",msg->state[i]);
                strncat(buffer, element, strlen(element));
            }
            delete_char(buffer, ',');
            int len = strlen(buffer);
            memcpy(msg->buf, buffer, len);
            msg->buf[len] = '\0';
        }
        
    }
    msg->base.e=err;
    ret = err;
    lynqDeQueue(token);
    free(msg);
    msg = NULL;
    return ret;
}

int lynq_disable_pin(char *pin){
    int ret = -1;
    int32_t token = 0;
    if(pin == NULL)
        return ret;
    simOperate *msg = (simOperate *)calloc(1, sizeof(simOperate));
    RIL_Errno err=-1;
    lynqQueue * node = NULL;
    int num = 0;
    int res = 0;
    char *facility = "SC";
    int serviceclass = 11;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_SET_FACILITY_LOCK"};
    token = lynqStringParameOperate_disable(requestStr, facility, pin, serviceclass);
    msg->base.request = RIL_REQUEST_SET_FACILITY_LOCK;
    msg->base.token = token;
    node = commonFindParcelmsg(token,500,err);
    for(int i = 0;i<20;i++)
    {
        msg->state[i]=0;
    }
    if (node!=NULL)
    {
        node->parcel.readInt32(&num);
        msg->state[0]=num;
        for(int i=1;i<=num;i++)
        {
            node->parcel.readInt32(&res);
            msg->state[i]=res;
        }
        char buffer[256] = {0};
        char element[256] = {0};
        if(msg->state[0]>0)
        {
            for(int i =1;i<=msg->state[0];i++)
            {
                sprintf(element,"%d,",msg->state[i]);
                strncat(buffer, element, strlen(element));
            }
            delete_char(buffer, ',');
            int len = strlen(buffer);
            memcpy(msg->buf, buffer, len);
            msg->buf[len] = '\0';
        }
    }
    msg->base.e=err;
    ret = err;
    lynqDeQueue(token);
    free(msg);
    msg = NULL;
    return ret;
}

int lynq_query_pin_lock(char *pin,char buf[]){
    int ret = -1;
    int32_t token = 0;
    if(buf == NULL || pin == NULL)
        return ret;
    simOperate *msg = (simOperate *)calloc(1, sizeof(simOperate));
    RIL_Errno err=-1;
    lynqQueue * node = NULL;
    int num = 0;
    int res = 0;
    char *facility = "SC";
    int serviceclass = 11;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_QUERY_FACILITY_LOCK"};
    token = lynqStringParameQuery(requestStr, facility, pin, serviceclass);
    msg->base.request = RIL_REQUEST_QUERY_FACILITY_LOCK;
    msg->base.token = token;
    node = commonFindParcelmsg(token,500,err);
    for(int i = 0;i<20;i++)
    {
        msg->state[i]=0;
    }
    if (node!=NULL)
    {
        node->parcel.readInt32(&num);
        msg->state[0]=num;
        for(int i=1;i<=num;i++)
        {
            node->parcel.readInt32(&res);
            msg->state[i]=res;
        }
        char buffer[256] = {0};
        char element[256] = {0};
        if(msg->state[0]>0)
        {
            for(int i =1;i<=msg->state[0];i++)
            {
                sprintf(element,"%d,",msg->state[i]);
                strncat(buffer, element, strlen(element));
            }
            delete_char(buffer, ',');
            int len = strlen(buffer);
            memcpy(msg->buf, buffer, len);
            msg->buf[len] = '\0';
            memcpy(buf, msg->buf, len);
            buf[len] = '\0';
        }
    }
    msg->base.e=err;
    ret = err;
    lynqDeQueue(token);
    free(msg);
    msg = NULL;
    return ret;
}

int lynq_verify_pin(char *pin){
    int ret = -1;
    int32_t token = 0;
    if(pin == NULL)
        return ret;
    simOperate *msg = (simOperate *)calloc(1, sizeof(simOperate));
    RIL_Errno err=-1;
    lynqQueue * node = NULL;
    int num = 0;
    int res = 0;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_ENTER_SIM_PIN"};
    token = lynqStringParame(requestStr, pin);
    msg->base.request = RIL_REQUEST_ENTER_SIM_PIN;
    msg->base.token = token;
    node = commonFindParcelmsg(token,500,err);
    for(int i = 0;i<20;i++)
    {
        msg->state[i]=0;
    }
    if (node!=NULL)
    {
        node->parcel.readInt32(&num);
        msg->state[0]=num;
        for(int i=1;i<=num;i++)
        {
            node->parcel.readInt32(&res);
            msg->state[i]=res;
        }
        char buffer[256] = {0};
        char element[256] = {0};
        if(msg->state[0]>0)
        {
            for(int i =1;i<=msg->state[0];i++)
            {
                sprintf(element,"%d,",msg->state[i]);
                strncat(buffer, element, strlen(element));
            }
            delete_char(buffer, ',');
            int len = strlen(buffer);
            memcpy(msg->buf, buffer, len);
            msg->buf[len] = '\0';
        }
    }
    msg->base.e=err;
    ret = err;
    lynqDeQueue(token);
    free(msg);
    msg = NULL;
    return ret;
}

int lynq_change_pin(char *old_pin, char *new_pin){
    int ret = -1;
    int32_t token = 0;
    if(old_pin == NULL || new_pin == NULL)
        return ret;
    simOperate *msg = (simOperate *)calloc(1, sizeof(simOperate));
    RIL_Errno err=-1;
    lynqQueue * node = NULL;
    int num = 0;
    int res = 0;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_CHANGE_SIM_PIN"};
    token = lynqStringParameChange(requestStr, old_pin, new_pin);
    msg->base.request = RIL_REQUEST_CHANGE_SIM_PIN;
    msg->base.token = token;
    node = commonFindParcelmsg(token,500,err);
    for(int i = 0;i<20;i++)
    {
        msg->state[i]=0;
    }
    if (node!=NULL)
    {
        node->parcel.readInt32(&num);
        msg->state[0]=num;
        for(int i=1;i<=num;i++)
        {
            node->parcel.readInt32(&res);
            msg->state[i]=res;
        }
        char buffer[256] = {0};
        char element[256] = {0};
        if(msg->state[0]>0)
        {
            for(int i =1;i<=msg->state[0];i++)
            {
                sprintf(element,"%d,",msg->state[i]);
                strncat(buffer, element, strlen(element));
            }
            delete_char(buffer, ',');
            int len = strlen(buffer);
            memcpy(msg->buf, buffer, len);
            msg->buf[len] = '\0';
        }
    }
    msg->base.e=err;
    ret = err;
    lynqDeQueue(token);
    free(msg);
    return ret;
}

int lynq_unlock_pin(char *puk, char *pin){
    int ret = -1;
    int32_t token = 0;
    if(puk == NULL || pin == NULL)
        return token;
    simOperate *msg = (simOperate *)calloc(1, sizeof(simOperate));
    RIL_Errno err=-1;
    lynqQueue * node = NULL;
    int num = 0;
    int res = 0;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_ENTER_SIM_PUK"};
    token = lynqStringParameChange(requestStr, puk, pin);
    msg->base.request = RIL_REQUEST_ENTER_SIM_PUK;
    msg->base.token = token;
    node = commonFindParcelmsg(token,500,err);
    for(int i = 0;i<20;i++)
    {
        msg->state[i]=0;
    }
    if (node!=NULL)
    {
        node->parcel.readInt32(&num);
        msg->state[0]=num;
        for(int i=1;i<=num;i++)
        {
            node->parcel.readInt32(&res);
            msg->state[i]=res;
        }
        char buffer[256] = {0};
        char element[256] = {0};
        if(msg->state[0]>0)
        {
            for(int i =1;i<=msg->state[0];i++)
            {
                sprintf(element,"%d,",msg->state[i]);
                strncat(buffer, element, strlen(element));
            }
            delete_char(buffer, ',');
            int len = strlen(buffer);
            memcpy(msg->buf, buffer, len);
            msg->buf[len] = '\0';
        }
    }
    msg->base.e=err;
    ret = err;
    lynqDeQueue(token);
    free(msg);
    msg = NULL;
    return ret;
}

int parse_param(char *cmd, char **argv, char buf[]){
    if(cmd == NULL || argv == NULL || buf == NULL){
        printf("input error");
        return 0;
    }
    if(strstr(cmd,"ERROR")){
        //char *test = strchr(cmd, ':')+1;
        int len = strlen(cmd);
        memcpy(buf, cmd, len);
        buf[len] = '\0';
        return 3;
    }
    else{
        int argc = 0;
        char *token;
        token = strtok(cmd, ",");
        if(strstr(token, "CNUM")){
            char *string;
            while (token != NULL)
            {  
                string = token;
                argv[argc++] = string;
                token = strtok(NULL, ",");
            }
            int lengh = strlen(argv[1]);
            memcpy(buf, argv[1], lengh);
            buf[lengh] = '\0';
            delete_char(buf, '"');
        }
        else{
            const char *warning = "error num = 9001";
            int len = strlen(warning);
            memcpy(buf, warning, len);
            buf[len] = '\0';
        }
        
    }
    return 0;
}

int lynq_query_phone_number(char buf[]){
    int res = -1;
    int32_t token = 0;
    if(buf == NULL)
        return res;
    simNumber *msg = (simNumber *)calloc(1, sizeof(simNumber));
    lynqQueue *node = NULL;
    int timeout = 500; //timeout is 5s.
    RIL_Errno err = -1;
    int num = 0;
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_OEM_HOOK_RAW"};
    if(token = lynqStringParame(requestStr, "AT+CNUM"))
    {
        msg->base.request = RIL_REQUEST_OEM_HOOK_RAW;
        msg->base.token = token;
        node = commonUpdateEstatus(token,timeout,err);
        msg->base.e = err;
        res = err;
        if(err != RIL_E_SUCCESS)
        {   
            LYDBGLOG("[%s] error code is %d!",__FUNCTION__,err);
            memset(msg->number,0,sizeof(msg->number));
            lynqDeQueue(token);
            return res;
        }
        if(node)
        {      
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {   
                node->parcel.readInt32(&num);
                for(int i =0;i<num;i++)//for DSDS.
                {
                   char * str=lynqStrdupReadString(node->parcel);
                   memcpy(msg->number,str,strlen(str)+1);
                }
            }
        }
        lynqDeQueue(token);
    }
    char *argv[MAX_NUM];
    char str[80] = {0};
    memcpy(str, msg->number, strlen(msg->number));
    str[strlen(msg->number)] = '\0';
    res = parse_param(str, argv, buf);
    free(msg);
    msg = NULL;
    return res;
}

int get_mccmnc(char buf[], char mccmnc[]){
    for(int i = 0; i < 5; i++){
        mccmnc[i] = buf[i];
    }
    mccmnc[5] = '\0';
    return 0;
}


int lynq_query_operator(char buf[]){
    int32_t token = -1;
    if(buf == NULL)
        return token;
    char msg_imsi[20] = {0};
    //simOperator *msg =  (simOperator*)calloc(1, sizeof(simOperator));
    memset(msg_imsi,0,sizeof(simImsi));
    RIL_Errno err = -1;
    token = lynq_get_imsi(msg_imsi);
    if(strlen(msg_imsi) != 0){
        FindOperator *ope_command = NULL;
        ope_command = find_ope_command(msg_imsi, findOperator);
        if(ope_command){
            memcpy(buf, ope_command->buf, strlen(ope_command->buf));
            buf[strlen(ope_command->buf)] = '\0';
        }
        else{
            /*more*/
            char mccmnc[5] = {0};
            get_mccmnc(msg_imsi, mccmnc);
            memcpy(buf, mccmnc, 5);
            buf[5] = '\0';
            /*more*/
        }
        return token;
    }
    else{
        //msg->base.e = err;
        const char *test = "please insert sim card";
        memcpy(buf, test, strlen(test));
        return token;
    }
}





