/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Mike Muuss.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *  This product includes software developed by the University of
 *  California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _PING6_NIQUERY_H_
#define _PING6_NIQUERY_H_

#include <asm/byteorder.h>

#define NI_NONCE_SIZE           8

/* Node Information Query */
struct ni_hdr {
    struct icmp6_hdr        ni_u;
    __u8                ni_nonce[NI_NONCE_SIZE];
};

#define ni_type     ni_u.icmp6_type
#define ni_code     ni_u.icmp6_code
#define ni_cksum    ni_u.icmp6_cksum
#define ni_qtype    ni_u.icmp6_data16[0]
#define ni_flags    ni_u.icmp6_data16[1]

/* Types */
#ifndef ICMPV6_NI_QUERY
#define ICMPV6_NI_QUERY        139
#define ICMPV6_NI_REPLY        140
#endif

/* Query Codes */
#define NI_SUBJ_IPV6            0
#define NI_SUBJ_NAME            1
#define NI_SUBJ_IPV4            2

/* Reply Codes */
#define NI_SUCCESS          0
#define NI_REFUSED          1
#define NI_UNKNOWN          2

/* Qtypes */
#define NI_QTYPE_NOOP           0
#define NI_QTYPE_NAME           2
#define NI_QTYPE_IPV6ADDR       3
#define NI_QTYPE_IPV4ADDR       4

/* Flags */
#define NI_IPV6ADDR_F_TRUNCATE      __constant_cpu_to_be16(0x0001)
#define NI_IPV6ADDR_F_ALL           __constant_cpu_to_be16(0x0002)
#define NI_IPV6ADDR_F_COMPAT        __constant_cpu_to_be16(0x0004)
#define NI_IPV6ADDR_F_LINKLOCAL     __constant_cpu_to_be16(0x0008)
#define NI_IPV6ADDR_F_SITELOCAL     __constant_cpu_to_be16(0x0010)
#define NI_IPV6ADDR_F_GLOBAL        __constant_cpu_to_be16(0x0020)

#define NI_IPV4ADDR_F_TRUNCATE      NI_IPV6ADDR_F_TRUNCATE
#define NI_IPV4ADDR_F_ALL           NI_IPV6ADDR_F_ALL

#endif /*_PING6_NIQUERY_H_*/
