#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/kmemcheck.h>
#include <linux/mm.h>
#include <linux/interrupt.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/slab.h>
#include <linux/netdevice.h>
#ifdef CONFIG_NET_CLS_ACT
#include <net/pkt_sched.h>
#endif
#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/splice.h>
#include <linux/cache.h>
#include <linux/rtnetlink.h>
#include <linux/init.h>
#include <linux/scatterlist.h>
#include <linux/errqueue.h>
#include <linux/prefetch.h>
//#include <linux/psbuff.h>

#include <net/protocol.h>
#include <net/dst.h>
#include <net/sock.h>
#include <net/checksum.h>
#include <net/xfrm.h>

#include <asm/uaccess.h>
#include <trace/events/skb.h>
//#include "../kmap_skb.h"

#include <linux/wakelock.h>
#include <linux/if_arp.h>
#include <linux/hash.h>
/***************************************************************************************************************/
/***************************************************************************************************************/
/*cacheصĴӿڣԭøýӿڣڲǷfastnatɹɹˢDATA֮ǰݣˢall*/
/***************************************************************************************************************/
/***************************************************************************************************************/
extern int *vir_addr_ddrnet;

extern void dma_cache_maint(const void *vir_addr, const void *phy_addr, size_t size, int direction);
extern void copy_skb_header(struct sk_buff *new, const struct sk_buff *old);
extern unsigned long virt_to_phys_cap(unsigned long virt);
#ifndef WAN_NAME
#define WAN_NAME	"wan"
#endif

//͸CP˵skbԤͷʱøýӿڽµskb
static struct sk_buff *skb_copy_forext(const struct sk_buff *skb, gfp_t gfp_mask)
{
	int headerlen;
	int offset;
	unsigned int size;
	struct sk_buff *n;

	headerlen = skb_headroom(skb);
	offset = headerlen < NET_SKB_PAD ? NET_SKB_PAD - headerlen : 0;
	size = skb_end_offset(skb) + skb->data_len;
	n = alloc_skb(size+offset, gfp_mask);
	if (!n)
		return NULL;

	/* Set the data pointer */
	skb_reserve(n, headerlen+offset);
	/* Set the tail pointer and length */
	skb_put(n, skb->len);

	if (skb_copy_bits(skb, -headerlen, n->head+offset, headerlen + skb->len))
		BUG();

	copy_skb_header(n, skb);
	return n;
}


extern struct sk_buff *skb_copy_expand(const struct sk_buff *skb,
				int newheadroom, int newtailroom,
				gfp_t gfp_mask);

//ͷԤռ䣬ڲʹskb_copy_expandӿڲˢcachecopyskb
struct sk_buff * skb_head_expand(struct sk_buff * skb ,unsigned int lenth_expand)
{
	struct sk_buff *n;
	
	n = skb_copy_expand(skb,lenth_expand,0,GFP_ATOMIC);
	if (!n){ //skbʧ
	//	panic("skb_copy_expand can not alloc skb !!! ");
		dev_kfree_skb_any(skb);
		return NULL;
    }
	clean_cache(n->data, n->len);
	dev_kfree_skb_any(skb);
	skbinfo_add(n,SKB_COPY_CACHE);
    
	return n;	
	
}
EXPORT_SYMBOL(skb_head_expand);

static void skb_invalid_cache(struct sk_buff * skb,int len)
{
	if((skb->data - skb->head) < len)
		invalid_cache(skb->head, skb->data - skb->head);
	else
		invalid_cache(skb->data - len , len);
}
extern const struct net_device_ops psnet_netdev_ops;
//ýӿnet_device豸ڽDMA֮ǰãDMAƣ
struct sk_buff * flush_skbuf(struct sk_buff *skb)
{
	skb->isflush = 1 ;
	//fastnatɹˢdata֮ǰݣDRV+MAC+IP+TCPֵ
	if(skb->isFastnat)
	{
		if(skb_network_head(skb) == 0 || skb_network_head(skb) == ~0U)
			panic("network_header    ERR!!!!!!!!!!\n");

		if (skb_shinfo(skb)->nr_frags) 
		{
			if(skb->dev->netdev_ops == &psnet_netdev_ops){
		    //if(strncmp(skb->dev->name, "wan", 3) == 0){
                skb = skb_head_expand(skb, NET_SKB_PAD + ETH_HLEN + NET_IP_ALIGN);		
            }else
			    skb = skb_head_expand(skb, NET_SKB_PAD + NET_IP_ALIGN);			
            if(!skb)
                goto Out;
			//print_sun(SUN_DBG,"skb->isFastnat,skb to CP err,need copy new !!! \n");
			if(skb->dev != NULL && strncmp(skb->dev->name,WAN_NAME,3)==0)
				skb_invalid_cache(skb,skb->len + PSBUF_HEAD_SPACE + PDCP_INCREMENT_SPACE);
				//invalid_cache(skb->data - NET_SKB_PAD , NET_SKB_PAD );
		}
		//˼ͨʱҪȷԤ㹻invalidԤ
		else if(skb->dev != NULL && skb->dev->netdev_ops == &psnet_netdev_ops)//strncmp(skb->dev->name,WAN_NAME,3)==0)
		{
			if(skb->head + NET_SKB_PAD + ETH_HLEN > skb->data)
			{
				//skb = skb_head_expand(skb,NET_SKB_PAD + NET_IP_ALIGN);
			    skb = skb_head_expand(skb, NET_SKB_PAD + ETH_HLEN + NET_IP_ALIGN);
                if(!skb)
                  goto Out;
			}
			else
				clean_cache(skb->data, skb_network_head(skb) - skb->data +FASTNAT_IPTCP_LEN);
			skb_invalid_cache(skb,skb->len + PSBUF_HEAD_SPACE + PDCP_INCREMENT_SPACE);
			//invalid_cache(skb->data - NET_SKB_PAD , NET_SKB_PAD );
		}
		else if(unlikely(skb->indev != NULL && skb->indev->type == ARPHRD_NONE))
		{
			clean_cache(skb->data, skb->len);
		}
		else
		{
			//fast_nat_recvУfast_nat_findɹִ֮skb_reset_network_headerIPĸֵ
			clean_cache(skb->data, skb_network_head(skb) - skb->data +FASTNAT_IPTCP_LEN);
		}
		//print_sun(SUN_DBG,"fastnat   succ,clean   cache   MAC+IP+TCP !!! \n");
	}
	//fastbrɹͷĿ
	else if(skb->isFastbr)
	{
		if(skb_mac_head(skb) == 0 || skb_mac_head(skb) == ~0U)
			panic("mac_header    ERR!!!!!!!!!!\n");

		if (skb_shinfo(skb)->nr_frags) 
		{
			if(skb->dev->netdev_ops == &psnet_netdev_ops){
		    //if(strncmp(skb->dev->name, "wan", 3) == 0){
                skb = skb_head_expand(skb, NET_SKB_PAD + ETH_HLEN + NET_IP_ALIGN);		
            }else
			    skb = skb_head_expand(skb, NET_SKB_PAD + NET_IP_ALIGN);				
            if(!skb)
                goto Out;
			//print_sun(SUN_DBG,"skb->isFastbr,skb to CP err,need copy new !!! \n");
			if(skb->dev != NULL && strncmp(skb->dev->name,WAN_NAME,3)==0)
				skb_invalid_cache(skb,skb->len + PSBUF_HEAD_SPACE + PDCP_INCREMENT_SPACE);
			//invalid_cache(skb->data - NET_SKB_PAD , NET_SKB_PAD );
		}
		//˼ͨʱҪȷԤ㹻invalidԤ
		else if(skb->dev != NULL && skb->dev->netdev_ops == &psnet_netdev_ops)//strncmp(skb->dev->name,WAN_NAME,3)==0)
		{
			if(skb->head + NET_SKB_PAD + ETH_HLEN > skb->data)
			{
				//skb = skb_head_expand(skb,NET_SKB_PAD + NET_IP_ALIGN);  
			    skb = skb_head_expand(skb, NET_SKB_PAD + ETH_HLEN + NET_IP_ALIGN);    
                if(!skb)
                   goto Out;
			}
	            //if(skb->head + NET_SKB_PAD > skb->data)
				//panic("reserve  cannot PSBUF,driver may err !!! \n");
			skb_invalid_cache(skb,skb->len + PSBUF_HEAD_SPACE + PDCP_INCREMENT_SPACE);
			//invalid_cache(skb->data - NET_SKB_PAD , NET_SKB_PAD );
		}
		else if(skb->protocol == cpu_to_be16(ETH_P_8021Q))
		{
			clean_cache(skb->data, skb_network_head(skb) - skb->data);
		}
		//ͷʱˢcache,wifiͷ
		else if(skb_mac_head(skb) > skb->data)
		{
			clean_cache(skb->data, skb_mac_head(skb) - skb->data);
		}
		//˴ԣųfastnatδskb_reset_network_header
		else if(skb_mac_head(skb) < skb->data)
			panic("assert");
		//print_sun(SUN_DBG,"fastbr   succ,clean   cache   drv !!! \n");
	}
	//ˢall
	else
	{
		//ڷƬΪˢcacheҪ¿һ
		if(skb_shinfo(skb)->nr_frags)
		{
			if(skb->dev->netdev_ops == &psnet_netdev_ops){
		    //if(strncmp(skb->dev->name, "wan", 3) == 0){
                skb = skb_head_expand(skb, NET_SKB_PAD + ETH_HLEN + NET_IP_ALIGN);		
            }else
			    skb = skb_head_expand(skb, NET_SKB_PAD + NET_IP_ALIGN);			
			if(!skb)
					goto Out;
			//print_sun(SUN_DBG,"skb flags,need copy new !!! \n");
			if(skb->dev != NULL && strncmp(skb->dev->name,WAN_NAME,3)==0)
				skb_invalid_cache(skb,skb->len + PSBUF_HEAD_SPACE + PDCP_INCREMENT_SPACE);
			//invalid_cache(skb->data - NET_SKB_PAD  , NET_SKB_PAD );		
		}
		//ڷ͸CP˵ͷԤҪ¿һ
		else if(skb->dev != NULL && skb->dev->netdev_ops == &psnet_netdev_ops)//strncmp(skb->dev->name,WAN_NAME,3)==0)
		{
			if ( skb->head + NET_SKB_PAD + ETH_HLEN > skb->data) 
			{
			//	skb = skb_head_expand(skb,NET_SKB_PAD + NET_IP_ALIGN);			
				skb = skb_head_expand(skb, NET_SKB_PAD + ETH_HLEN + NET_IP_ALIGN);
       
                if(!skb)
                    goto Out;
				//print_sun(SUN_DBG,"skb to CP err,need copy new !!! \n");
			}
			else 
				clean_cache(skb->data, skb->len);
			skb_invalid_cache(skb,skb->len + PSBUF_HEAD_SPACE + PDCP_INCREMENT_SPACE);
			//invalid_cache(skb->data - NET_SKB_PAD  , NET_SKB_PAD );
		}
		else
			clean_cache(skb->data, skb->len);
		//print_sun(SUN_DBG,"fastbr+fastnat   fail,clean   all !!! \n");
	}
Out:
	return skb;
}
EXPORT_SYMBOL(flush_skbuf);

unsigned long virtaddr_to_phys(unsigned long virt)
{
#if _USE_VEHICLE_DC
	unsigned long addr = virt_to_phys_cap(virt);
	if(addr)
		return addr;
#endif
	return  __pa(virt);
}
EXPORT_SYMBOL(virtaddr_to_phys);

unsigned long physaddr_to_virt(unsigned long phys)
{
	return __va(phys);
}
EXPORT_SYMBOL(physaddr_to_virt);

void invalid_cache(unsigned char *data,int len)
{
	const void* phy_data;
#if _USE_VEHICLE_DC //ndef CONFIG_PREEMPT_RT_FULL
	phy_data = virtaddr_to_phys(data);
#else
	phy_data = data;
#endif
	dma_cache_maint(data ,phy_data ,len, DMA_FROM_DEVICE);
}
EXPORT_SYMBOL(invalid_cache);

void clean_cache(unsigned char *data,int len)
{
	const void* phy_data;
#if _USE_VEHICLE_DC//ndef CONFIG_PREEMPT_RT_FULL
	phy_data = virtaddr_to_phys(data);
#else
	phy_data = data;
#endif
	dma_cache_maint(data ,phy_data ,len, DMA_TO_DEVICE);
}
EXPORT_SYMBOL(clean_cache);



