#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>

#include "cc_at.h"
#include "cc_main.h"



#define ZAT_INVALID_LEN    -1
#define MSG_RETRY_NUM    4
#define MSG_RETRY_INTERVAL    50

static CHAR         g_zCc_RecvBuf[ATMAIN_AT_BUF_LEN + 1] = {0};


/* ַѰƥӴ˫ڵݳ */
static PSTR zCc_FindSubStr(const PSTR pStr, const PSTR pSubStr,const SINT32 strLen)
{
    SINT32 subStrLen    = 0;
    BOOL   bInSideQuote = FALSE; /* Ƿ˫ */
    UINT16   wIndex       = 0;
    PSTR   pTmpStr      = pStr;

    if ((pStr == ZUFI_NULL) || (pSubStr == ZUFI_NULL) || (strLen <= 0))
    {
        return ZUFI_NULL;
    }

    subStrLen = (SINT32)strlen((CHAR *)pSubStr);

    if (strLen < subStrLen)
    {
        return ZUFI_NULL;
    }

    for (wIndex=0; wIndex<((strLen-subStrLen)+1); wIndex++)
    {
        /* жǷ˫ */
        if (*pTmpStr == '"')
        {
            bInSideQuote = !bInSideQuote;
        }
        /* ӴȽ */
        if (!bInSideQuote && *pTmpStr == *pSubStr)
        {
            if (strncmp((CHAR *)pTmpStr, (CHAR *)pSubStr, (UINT32)subStrLen) == 0)
            {
                return pTmpStr;
            }
        }
        pTmpStr++;
    }

    return ZUFI_NULL;
}



/* ӵǰַлȡATӦӴӴ */
static SINT32 zCc_GetSubAtStr(const PSTR pCurAtStr, PSTR pSubAtStr, SINT32 iDataLen, PSTR atRecvBuf)
{
    PSTR   pAtHead      = ZUFI_NULL; /* ATӦͷ */
    PSTR   pAtTail      = ZUFI_NULL; /* ATӦβ */
    SINT32 iSubAtStrLen = ZAT_INVALID_LEN; /* ATӦӴ */
    SINT32 iFreeDataLen = ZAT_INVALID_LEN; /* δATӦݳ */

    if ((pCurAtStr == ZUFI_NULL) || (pSubAtStr == ZUFI_NULL))
    {
        return ZAT_INVALID_LEN;
    }

    /* ATӦATӦʼ"\r\n" */
    iFreeDataLen = iDataLen - (pCurAtStr - atRecvBuf);
    pAtHead = zCc_FindSubStr(pCurAtStr, (PSTR)"\r\n", iFreeDataLen);
    if (pAtHead == ZUFI_NULL)
    {
        return ZAT_INVALID_LEN;
    }

    /* ATӦATӦ"\r\n" */
    pAtHead += 2;
    iFreeDataLen = iDataLen - (pAtHead - atRecvBuf);
    pAtTail = zCc_FindSubStr(pAtHead, (PSTR)"\r\n", iFreeDataLen);
    if (pAtTail == ZUFI_NULL)
    {
        if (strlen((CHAR *)pAtHead) == 0)
        {
            return ZAT_INVALID_LEN;
        }
        else
        {
            pAtTail = pAtHead + strlen((CHAR *)pAtHead);    
        }
    }

    /* ȡ"\r\n"֮ATӦ */
    iSubAtStrLen = pAtTail - pAtHead;
    if ((iSubAtStrLen > 0) && (iSubAtStrLen < AT_CMD_MAX))
    {
        memcpy(pSubAtStr, pAtHead, (UINT32)iSubAtStrLen); 
        return iSubAtStrLen;
    }

    return iSubAtStrLen == 0? 0 : ZAT_INVALID_LEN;
}
static void skipWhiteSpace(char **p_cur)
{
    if (*p_cur == NULL)
    {
        return;
    }

    while (**p_cur != '\0' && isspace(**p_cur))
    {
        (*p_cur)++;
    }
}
char *strsep(char **stringp, const char *delim)
{
        char *s;
        const char *spanp;
        int c, sc;
        char *tok;

        if ((s = *stringp) == NULL)
                return (NULL);
        for (tok = s;;) {
                c = *s++;
                spanp = delim;
                do {
                        if ((sc = *spanp++) == c) {
                                if (c == 0)
                                        s = NULL;
                                else
                                        s[-1] = 0;
                                *stringp = s;
                                return (tok);
                        }
                } while (sc != 0);
        }
        /* NOTREACHED */
}
void skipNextComma(char **p_cur)
{
    if (*p_cur == NULL)
    {
        return;
    }

    while (**p_cur != '\0' && **p_cur != ',')
    {
        (*p_cur)++;
    }

    if (**p_cur == ',')
    {
        (*p_cur)++;
    }
}
static char * nextTok(char **p_cur)
{
    char    *ret = NULL;

    skipWhiteSpace(p_cur);

    if (*p_cur == NULL)
    {
        ret = NULL;
    }
    else if (**p_cur == '"')
    {
        (*p_cur)++;
        ret = (char*)strsep(p_cur, "\"");
        skipNextComma(p_cur);
    }
    else
    {
        ret = (char*)strsep(p_cur, ",");
    }

    return ret;
}
SINT32 zCc_at_tok_start(char **p_cur)
{
    if (*p_cur == NULL)
    {
        return -1;
    }

    // skip prefix
    // consume "^[^:]:"

    *p_cur = strchr(*p_cur, ':');

    if (*p_cur == NULL)
    {
        return -1;
    }

    (*p_cur)++;

    return 0;
}
/**
 * Parses the next integer in the AT response line and places it in *p_out
 * returns 0 on success and -1 on fail
 * updates *p_cur
 * "base" is the same as the base param in strtol
 */

static SINT32 zCc_at_tok_nextint_base(char **p_cur, SINT32 *p_out, SINT32 base, SINT32 uns)
{
    char    *ret;

    if (*p_cur == NULL)
    {
        return -1;
    }

    ret = nextTok(p_cur);

    if (ret == NULL)
    {
        return -1;
    }
    else
    {
        long    l;
        char    *end;
		errno = 0;// kw CXX.ERRNO.NOT_CHECKED
        if (uns)
        {
            l = strtoul(ret, &end, base);
        }
        else
        {
            l = strtol(ret, &end, base);
        }
		if (errno == ERANGE)// kw CXX.ERRNO.NOT_CHECKED
		{
			zte_log_append(__FILE__, __LINE__, "strtoul errno %d: %s\n", errno, strerror(errno));
		}
        *p_out = (SINT32) l;

        if (end == ret)
        {
            return -1;
        }
    }

    return 0;
}

/**
 * Parses the next base 10 integer in the AT response line
 * and places it in *p_out
 * returns 0 on success and -1 on fail
 * updates *p_cur
 */
SINT32 zCc_at_tok_nextint(char **p_cur, SINT32 *p_out)
{
    return zCc_at_tok_nextint_base(p_cur, p_out, 10, 0);
}

int zCcApp_EncAtReqCcfc(char* ptMsgBuf)
{
        int Fd ;
        char AtCmdBuf[512] = {0};
        int AtLen;  

        zCcApp_SetAtChnlCmdId(CC_APP_AT_CMD_REQ_SET_CCFC);
        sprintf(AtCmdBuf, "%s",ptMsgBuf);
        AtLen = strlen(AtCmdBuf);
        Fd = zCcApp_GetAtCmdFd();
        return zCcApp_PortSend(Fd,AtCmdBuf,AtLen);
}

int zCcApp_EncAtReqClck(char* ptMsgBuf)
{
        int Fd ;
        char AtCmdBuf[512] = {0};
        int AtLen;  

        zCcApp_SetAtChnlCmdId(CC_APP_AT_CMD_REQ_SET_CLCK);
        sprintf(AtCmdBuf, "%s",ptMsgBuf);
        AtLen = strlen(AtCmdBuf);
        Fd = zCcApp_GetAtCmdFd();
        return zCcApp_PortSend(Fd,AtCmdBuf,AtLen);
}

int zCcApp_EncAtReqD(char* ptMsgBuf)
{

        int Fd ;
        char AtCmdBuf[512] = {0};
        int AtLen;  

        zCcApp_SetAtChnlCmdId(CC_APP_AT_CMD_REQ_D);
        sprintf(AtCmdBuf, "%s",ptMsgBuf);
        AtLen = strlen(AtCmdBuf);
        Fd = zCcApp_GetAtCmdFd();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCcApp_EncAtReqD:AtcmdMsg = %s\n",__FUNCTION__,AtCmdBuf);
        return zCcApp_PortSend(Fd,AtCmdBuf,AtLen);
}

int zCcApp_EncAtReqA(VOID)
{
        int Fd ;
        char  AtCmdBuf[512] = {0};
        int AtLen;

        zCcApp_SetAtChnlCmdId(CC_APP_AT_CMD_REQ_A);

        sprintf(AtCmdBuf, "ATA\r\n");
        AtLen = strlen(AtCmdBuf);

        /**/
        Fd = zCcApp_GetAtCmdFd();
        return zCcApp_PortSend(Fd,AtCmdBuf,AtLen);
}

int zCcApp_EncAtReqChup(void)
{
        int Fd ;
        char  AtCmdBuf[512] = {0};
        int AtLen;

        zCcApp_SetAtChnlCmdId(CC_APP_AT_CMD_REQ_CHUP);

        sprintf(AtCmdBuf, "AT+CHUP\r\n");
        AtLen = strlen(AtCmdBuf);

        Fd = zCcApp_GetAtCmdFd();
        return zCcApp_PortSend(Fd,AtCmdBuf,AtLen);
}

int zCcApp_EncAtReqVts(char *ptMsgBuf)
{
        int Fd ;
        char  AtCmdBuf[512] = {0};
        int AtLen;

        zCcApp_SetAtChnlCmdId(CC_APP_AT_CMD_REQ_VTS);

        sprintf(AtCmdBuf, "%s",ptMsgBuf);        
        AtLen = strlen(AtCmdBuf);

        /**/
        Fd = zCcApp_GetAtCmdFd();
        return zCcApp_PortSend(Fd,AtCmdBuf,AtLen);
}

int zCcApp_EncAtReqImsPlus(char *ptMsgBuf)
{
        int Fd ;
        char  AtCmdBuf[512] = {0};
        int AtLen;

        zCcApp_SetAtChnlCmdId(CC_APP_AT_CMD_REQ_IMSPLUS);

        sprintf(AtCmdBuf, "%s", ptMsgBuf);        
        AtLen = strlen(AtCmdBuf);

        /**/
        Fd = zCcApp_GetAtCmdFd();
        return zCcApp_PortSend(Fd,AtCmdBuf,AtLen);
}

int zCcApp_EncAtReqChld(char *AtcmdMsg)
{
        int Fd ;
        int AtLen;        

        zCcApp_SetAtChnlCmdId(CC_APP_AT_CMD_REQ_SET_CHLD);
        AtLen = strlen(AtcmdMsg);

        /**/
        Fd = zCcApp_GetAtCmdFd();
        return zCcApp_PortSend(Fd,AtcmdMsg,AtLen);
}

