/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : Cc
*    : Cc_main.c
* ļ :
* ʵֹ : 绰ҵͺͽģ麯
*      : 
*      : 
*  :
* ˵ :
**************************************************************************/

/**************************************************************************
* ޸ļ¼ :
***************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include <errno.h>
//#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
//#include <time.h>
#include <fcntl.h>
#include "cc_main.h"
#include "cc_proc.h"
#include "cc_com.h"
#include "cc_at.h"
#include <sys/types.h>
#ifdef TEST_CCAPP
#include "soft_timer.h"
#endif



/**************************************************************************
* 
**************************************************************************/
/**************************************************************************
* ݽṹ
**************************************************************************/
extern T_CC_APP_AtIndProcItem gCcAppAtIndProc[];
extern SINT32 gCcAppRecvAtIndCnt;
T_zCc_CallDetail g_Cc_CallDetail;
char g_zCcApp_AtIndBuf[ZCC_APP_AT_BUF_MAX_LEN+1];
/**************************************************************************
* static
**************************************************************************/
/**************************************************************************
* ȫֱ
**************************************************************************/
static SINT32 g_zCc_MsqId = NULL;
//static SINT32 g_zCc_AtIndRspId = NULL;
SINT32 g_zCc_AtRspId = NULL;


static SINT32 g_zCc_getSlicEv_threadId = -1; 

int zCc_sleep(long ms) 
{
    struct timeval tv;
    tv.tv_sec = 0;
    tv.tv_usec = ms * 1000;
    return select(0, NULL, NULL, NULL, &tv);
}
VOID zCc_SlicMsgProc(MSG_BUF *ptMsgBuf)
{
    assert(ptMsgBuf != NULL);
    //g_Cc_CallDetail.curEvt = ptMsgBuf->usMsgCmd;
    if (ptMsgBuf->usMsgCmd == ZCC_DTMF_E  &&  g_Cc_CallDetail.dCount < ZDIAL_NUM_MAX)
    {
        g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount++] = ptMsgBuf->aucDataBuf[0];
        ccapp_log("zCc_SlicMsgProc digit[%d]=%s", g_Cc_CallDetail.dCount, g_Cc_CallDetail.digits);
        printf("[ccapp_debug]:collect number digit[%d]=%s\n",g_Cc_CallDetail.dCount,g_Cc_CallDetail.digits);
    }
}

VOID zCc_SendMsgToSub(MSG_BUF *pMsg)
{
    MSG_BUF   *ptMsgBuf     = (MSG_BUF*)malloc(sizeof(MSG_BUF));
    SINT32        iMsgQueueId = ZAT_INVALID_ID;

	if(ptMsgBuf == NULL)
		return;
    memcpy(ptMsgBuf, pMsg, sizeof(MSG_BUF));

    iMsgQueueId = msgget(MODULE_ID_CALL_CTRL_LOCAL, 0);
    if (iMsgQueueId != ZAT_INVALID_ID)
    {
        ptMsgBuf->lMsgType = MSG_TYPE_DEFAULT;
        ptMsgBuf->dst_id = MODULE_ID_CALL_CTRL_LOCAL;
        if (msgsnd(iMsgQueueId, ptMsgBuf, sizeof(MSG_BUF) - sizeof(LONG), 0) < 0)
        {
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s zCc_SendMsgToSub fail!!!\n",__FUNCTION__);
        }
        else
        {    
            //zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s zCc_SendMsgToSub ptMsgBuf->usMsgCmd = %d, errno = %d   <---\n",__FUNCTION__,ptMsgBuf->usMsgCmd,errno);
        }
    }
    free(ptMsgBuf);
}

void* zCcApp_AtIndReader(void * ptr)
{
    int ret = -1;
    int ReadLen = -1;
    MSG_BUF   QueueMsg      = {0};
    while(1)
    {      
         ReadLen = msgrcv(g_zCc_AtRspId,&QueueMsg,  sizeof(MSG_BUF)-sizeof(LONG), 0, 0);
         if (ReadLen > 0)
         {
             zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s msgrcv QueueMsg.aucDataBuf = %d \n",__FUNCTION__,QueueMsg.usMsgCmd);
             ret = zCcApp_AtIndRspProc(&QueueMsg);
         }
        else
        {
            continue;
        }
        
    }
}   

VOID zCc_AtRecvMsgProc(MSG_BUF *ptMsgBuf)
{
    assert(ptMsgBuf != NULL);
    ULONG           cmdId               = ptMsgBuf->usMsgCmd;
    SINT32 i ;
    SINT32 ret  = -1;

    for(i=0;i< gCcAppRecvAtIndCnt;i++)
    {
        if(cmdId == gCcAppAtIndProc[i].cmdId)
        {
            if(NULL!= gCcAppAtIndProc[i].AtIndProcFun)
            {
                ret = gCcAppAtIndProc[i].AtIndProcFun(ptMsgBuf);
            }
            break;
        }
    }
}

static VOID zCc_SetRj11LedStatus(char* LedStatus)
{
	int ret = 0;
	
	sc_cfg_set("cc_rj11_status", LedStatus);

	ret = ipc_send_message(MODULE_ID_CALL_CTRL, MODULE_ID_MMI, MSG_CMD_RJ11_STATUS_INFO, 0, NULL, 0);
	if (ret != 0) {
		printf("zCc_SetRj11LedStatus %s failed\n", LedStatus);
	} else {
		printf("zCc_SetRj11LedStatus %s success\n", LedStatus);
	}
}

VOID* zCcApp_getSlicEv_entry(VOID *pBUf)
{
    MSG_BUF   msgBuf      = {0};
    unsigned char bEvent = EV_UNKONWN;
    DWORD dtmf1 = 0;
    char dtmf;

    while (1)
    {
        if (SLIC_SUCCESS == SLIC_MsgRev(&bEvent, &dtmf1))
        	zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s zCcApp_getSlicEv_entry recv msg %d\n",__FUNCTION__,bEvent);

       printf("[ccapp_debug]: get slic event, bEvent = %d, dtmf1=%d\n",bEvent, dtmf1);
        
        switch (bEvent)
        {
            case EV_FXS_HOOKON:
                msgBuf.usMsgCmd   = ZCC_RELEASE_E;
                msgBuf.src_id = MODULE_ID_SLIC;
                zCc_SendMsgToSub(&msgBuf); /* һ ¼߳ */ 
                break;
            case EV_FXS_HOOKOFF:
                msgBuf.usMsgCmd   = ZCC_SEIZE_E;
                msgBuf.src_id = MODULE_ID_SLIC;
                zCc_SendMsgToSub(&msgBuf); /* ժ¼߳ */
                break;
            case EV_FXS_COLLECT_DIG:// '0'-'9', '*', '#'
                dtmf = dtmf1;
                msgBuf.usMsgCmd   = ZCC_DTMF_E;
                msgBuf.src_id = MODULE_ID_SLIC;
                msgBuf.aucDataBuf[0] = (UINT8)(dtmf);
                msgBuf.usDataLen = 1;
                zCc_SendMsgToSub(&msgBuf); /* DTMF ¼߳ */
                break;                
            case EV_FXS_FLASH:
                msgBuf.usMsgCmd   = ZCC_FLASH_E;
                msgBuf.src_id = MODULE_ID_SLIC;
                zCc_SendMsgToSub(&msgBuf); /* FLASH ¼߳ */
                break;
			case EV_LT_RINGER_REN:
                if (dtmf1 == 1) {
					zCc_SetRj11LedStatus("ledon");
                } else {
					zCc_SetRj11LedStatus("ledoff");	
				}
                break;  
            default:/* ¼*/
                break;
        }

        //zCc_sleep(10);
    }
}

#define MAX_DIGIT_MAP_NUM 20
#define MAX_DIGIT_MAP_WHOLE_LEN 256
#define MAX_PHONE_NUM_SIZE 32
char tz_digitmap[MAX_DIGIT_MAP_NUM][MAX_PHONE_NUM_SIZE+1];//phone list
int frist_get_map = 0;

//(2xxxxxx|3xxxxxx|4xxxxxx|5xxxxxx|7xxxxxx|0[1-9][0-9]xxxxxxx|00xxxxxxxxxxxxxx|6xxx|8xxx|1xxx|*xx|#xx)
void get_digit_map_list()
{
	int i = 0;
	int j = 0;
	char buff[256] = {0};
	char *str = NULL;

	//sc_cfg_set("digitmap_str", "(2xxxxxx|3xxxxxx|4xxxxxx|5xxxxxx|7xxxxxx|0[1-9][0-9]xxxxxxx|00xxxxxxxxxxxxxx|6xxx|8xxx|1xxx|*xx|#xx)");
	//sc_cfg_save();	
	sc_cfg_get("digitmap_str",buff,sizeof(buff));
	if (strlen(buff) == 0)
		return;
	
	str = buff;
	if(*str == '(')
		str++;
	
	while(*str != 0)
	{
		if(*str == '|')
		{
			tz_digitmap[i][j] = 0;
			i++;
			j = 0;
		}
		else if(*str == ')')
		{
			break;
		}
		else
		{
			tz_digitmap[i][j] = *str;		
			j++;
		}
		str++;
	}

}

int digit_map_call(char *num)
{
	int i = 0;
	int j = 0;
	int n = 0;
	char flag = 0;
	char switch_str[4] = {0};
	static char buff[32+1] = {0};
	
	
	sc_cfg_get("digitmap_switch",switch_str,sizeof(switch_str));
	if(strcmp(switch_str, "0") == 0)
	{
		return 0;
	}
	
	if(0 == frist_get_map)
	{
		get_digit_map_list();
		frist_get_map = 1;	
	}
	
	strncpy(buff, num,sizeof(buff)-1);
	//printf("buff:%s\n", buff);


	for(i = 0; i < MAX_DIGIT_MAP_NUM; i++)
	{
		if(strlen(tz_digitmap[i]) != 0)
		{	
			while(((j+n) <= MAX_PHONE_NUM_SIZE) && (tz_digitmap[i][j] != 0) && (buff[j] != 0))
			{
				if(tz_digitmap[i][j+n] == '[' )
				{
					n++;
					while(((j+n) <= MAX_PHONE_NUM_SIZE) && tz_digitmap[i][j+n] != ']')
					{
						if(((j+n+2) <= MAX_PHONE_NUM_SIZE) && tz_digitmap[i][j+n+1] == '-')
						{
							if(tz_digitmap[i][j+n] <= buff[j] &&  buff[j] <= tz_digitmap[i][j+n+2])
							{
								//printf("digit_map:%c, %c, %c\n", tz_digitmap[i][j+n], tz_digitmap[i][j+n+2], buff[j]);
								flag = 1;
							}
							n+=3;
						}
						else
						{
							if(tz_digitmap[i][j+n] == buff[j])
							{
								flag = 1;
							}
							n++;			
						}		
					}
					
					if(flag == 0)
					{	
						break;
					}
					
					flag = 0;


				}
				else
				{
					if(tz_digitmap[i][j+n] != buff[j])
					{
						if(!(tz_digitmap[i][j+n] == 'X' || tz_digitmap[i][j+n] == 'x'))
							break;
					}			
				}
				j++;
				if(((j+n) <= MAX_PHONE_NUM_SIZE) && (tz_digitmap[i][j+n] == 0) && (buff[j] == 0))
				{
					//ccapp_log("digit_map_call do Match: %d, %s, %s\n", i, tz_digitmap[i], buff);
					return 1;
				}
			}		
		}
		n = 0;
		j = 0;
	}

	return 0;
}

#ifdef TEST_CCAPP
VOID* zCc_main(VOID * pbuf)
{
    MSG_BUF   QueueMsg      = {0};
    int MainQeueId = -1;
    int ret = -1;
    UINT8 bMsgType =1;
    int fd = -1;
    pthread_attr_t AtIndReaderAttr;
    pthread_t  AtIndReaderThreadId;
    
    pthread_attr_init(&AtIndReaderAttr);
    pthread_attr_setstacksize(&AtIndReaderAttr,4*1024);
    fd = zCcApp_GetAtIndFd();
    AtIndReaderThreadId = pthread_create(&AtIndReaderThreadId, NULL, zCcApp_AtIndReader, (void*)&fd);
    if(AtIndReaderThreadId < 0) 
    {
      return NULL;
    }
    while (1)
    {       
        ret = msgrcv(MainQeueId, &QueueMsg, sizeof(MSG_BUF), bMsgType, 0);
        if(ret == -1)
        {
            return NULL;
        }
        else
        {
        switch (QueueMsg.src_id)
            {
            case MODULE_ID_CALL_CTRL: // AT Ind msg
                zCc_AtRecvMsgProc(&QueueMsg);
                break;
            
            case MODULE_ID_SLIC: // message from slic
            default:
                zCc_SlicMsgProc(&QueueMsg);
                break;
            }            
            zCc_RunMaster(&QueueMsg);
        }
    }
    
}
#endif
#ifndef TEST_CCAPP

static int polarity_reversal_flag = 0;
int get_polarity_reversal_flag(void)
{
	return polarity_reversal_flag;
}

void check_polarity_reversal_cfg(void)
{
	int rt;
	char buf[32];
	
	memset(buf, 0, sizeof(buf));
	rt = sc_cfg_get("polarity_reversal",buf,sizeof(buf));
	if (rt != 0 || strlen(buf) == 0)
	{
		sc_cfg_set("polarity_reversal", "0");
		sc_cfg_save();
		
		polarity_reversal_flag = 0;
		return ;
	}

	polarity_reversal_flag = atoi(buf);
}

void check_wb_mode_cfg(void)
{
	int rt;
	int val;
	char buf[64];
	
	memset(buf, 0, sizeof(buf));
	rt = sc_cfg_get("wb_mode",buf,sizeof(buf));
	if (rt != 0 || strlen(buf) == 0)
	{
		sc_cfg_set("wb_mode", "1");
		sc_cfg_save();
		
		val = 1;
	}
	else
		val = atoi(buf);
		
	sprintf(buf, "at_cmd AT+ZIMSAMRW=%d", (val==0)?0:1);
	soft_system(buf);

	sprintf(buf, "echo \"at_cmd AT+ZIMSAMRW=%d\" > /tmp/log.ZIMSAMRW", (val==0)?0:1);
	soft_system(buf);
}


int main(VOID)
{
    MSG_BUF   QueueMsg      = {0};
    int ret = -1;
    pthread_t  CcAppMainThreadId;
    pthread_attr_t AtIndReaderAttr;
    pthread_t  AtIndReaderThreadId;
    SLIC_Initial();   
    SLIC_Dev_Init();
    soft_system("at_cmd AT+ZIMSTEST=\"EMCALL_TO_NORMAL\",1 ");

    check_wb_mode_cfg();
    check_polarity_reversal_cfg();

    g_zCc_MsqId = msgget(MODULE_ID_CALL_CTRL_LOCAL, IPC_CREAT | 0600);      
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s g_zCc_MsqId %d, errno:%d\n",__FUNCTION__,g_zCc_MsqId,errno);
    if (g_zCc_MsqId == ZAT_INVALID_ID)
    {
        return 0;
    }    

    g_zCc_AtRspId = msgget(MODULE_ID_CALL_CTRL, IPC_CREAT | 0600);       
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s g_zCc_AtRspId %d, errno:%d\n",__FUNCTION__,g_zCc_AtRspId,errno);

    if (g_zCc_AtRspId == ZAT_INVALID_ID)
    {
        return 0;
    }    
   
    g_zCc_getSlicEv_threadId = pthread_create(&CcAppMainThreadId, NULL, zCcApp_getSlicEv_entry,0);

    if(g_zCc_getSlicEv_threadId!=0)
    {   
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  pthread_create zCc_getSlicEv error, errno = %d \n",__FUNCTION__,errno);
        return -1;
    }
    else
    { 
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  pthread_create zCc_getSlicEv succ\n",__FUNCTION__);
    }
  
    pthread_attr_init(&AtIndReaderAttr);
    pthread_attr_setstacksize(&AtIndReaderAttr,4*1024);
    ret = pthread_create(&AtIndReaderThreadId, NULL, zCcApp_AtIndReader, 0);
	pthread_attr_destroy(&AtIndReaderAttr); //kw 2
    if(ret != 0) //cov m
    {
         zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s pthread_create zCcApp_AtIndReader error, errno = %d \n",__FUNCTION__,errno);
         return -1;
    }
    else
    { 
         zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s pthread_create zCcApp_AtIndReader succ\n",__FUNCTION__);
    }
   
    zCc_SendAtImsPlusReq(1,1);//imsplusϱ

    while (1)
    {       
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","BACK TO main\n");
        ret = msgrcv(g_zCc_MsqId, &QueueMsg,  sizeof(MSG_BUF)-sizeof(LONG), 0, 0);
        if(ret==-1)
        {
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s msgrcv return  ret= %d errno=%d\n",__FUNCTION__,ret, errno);
            continue;
        }
        else
        {
        switch (QueueMsg.src_id)
            {            
            case MODULE_ID_SLIC: // message from slic
                zCc_SlicMsgProc(&QueueMsg);
                break;
            default: // AT Ind msg
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","recv msg %d from at_ctl\n",QueueMsg.usMsgCmd);
                if (QueueMsg.usMsgCmd==MSG_CMD_ZIMSPLUS_IND
                 ||QueueMsg.usMsgCmd==MSG_CMD_DSCI_IND
                 ||QueueMsg.usMsgCmd==MSG_CMD_ZCPI
                 ||QueueMsg.usMsgCmd==MSG_CMD_ZVOICECHNL)
                {
                    zCc_CheckSlaveState("in zCc_AtRecvMsgProc");
                    zCc_AtRecvMsgProc(&QueueMsg);
                }
                break;
            }
			if (QueueMsg.usMsgCmd==MSG_CMD_VTS_RSP)
			{
				zCcApp_Vts_Rsp();
			}
            zCc_RunMaster(&QueueMsg);
        }
    }

return 0;
}
#endif

