/*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*
  LINUX ZTE LOG MODULE

  GENERAL DESCRIPTION
  print the log to the log file
 *====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*/
 
#ifndef _ZTE_LOG_
#define _ZTE_LOG_
 /*===========================================================================
  INCLUDES
  ===========================================================================*/
#include<stdarg.h>
#include<stdio.h>
#include<stdlib.h>
/*===========================================================================
  DATA
  ===========================================================================*/
#define NV_LOG_BUF_LEN 5
#define MAX_PARA_BUF 512
#define MAX_LOG_BUF MAX_PARA_BUF+64
//#define LOG_DIR_PATH "/tmp/zte_log/"
//#define LOG_DIR_PATH "/usr/"
#define LOG_DIR_PATH "/var/log"
#define OP_APPEND ">>"

/*------------suggested log name for every process-------------------*/
#define LOG_GOAHEAD_LOG                          "goahead.log"
#define LOG_WIFI_CONTROL_LOG                 "wifi_control.log"
#define LOG_PPP_DIAL_LOG                         "ppp_dial.log"
#define LOG_WAKEUP_MC_LOG                    "wakeup_maincontrol.log"
#define LOG_ZTE_LAN_LOG                              "zte_lan.log"
#define LOG_ZTE_LIBSOCKET_LOG                "zte_libsocket.log"
#define LOG_ZTE_MODC_LOG                         "zte_modc.log"
#define LOG_ZTE_WMS_LOG                  "zte_wms.log"
#define LOG_ZTE_PBM_LOG                  "zte_pbm.log"
#define LOG_ZTE_AT_LOG                       "zte_at.log"
#define LOG_ZTE_CFG_LOG                      "zte_cfg.log"
#define LOG_ZTE_NV_LOG                   "zte_nv.log"
#define LOG_ZTE_MC_LOG                   "zte_mc.log"
#define LOG_ZTE_MDM_LOG                      "zte_mdm.log"
#define LOG_ZTE_WAN_LOG                  "zte_wan.log"
#define LOG_ZTE_QMI_LOG                  "zte_qmi.log"
#define LOG_ZTE_SHARE_LOG                "zte_share.log"
#define LOG_ZTE_DAEMON_LOG                     "zte_daemon.log"
#define LOG_ZTE_USSD_LOG                 "zte_ussd.log"
#define LOG_ZTE_NTP_LOG                 "zte_ntp.log"
#define LOG_ZTE_MF80_LOG            "zte_mf80.log"
#define LOG_ZTE_PRINTER_LOG            "zte_printer.log"

/*--------------------------------------------------------------------------------------------
---------              ZTE_MSG just like qualcomm's MSG macro                       ----------
--------------------------------------------------------------------------------------------*/
#define ZTE_MSG(fmt,a,b,c) zte_msg_print(__FILE__,__LINE__,fmt,a,b,c)
/*--------------------------------------------------------------------------------------------
---------              @LOG_APPEND: this MARCO append the log to file tail          ----------
---------              @para: filename fmt                                          ----------
---------              @filename: the file log will be stored in                    ----------
---------              @fmt :main log string                                        ----------
---------              @example: LOG_APPEND("logfile","hello MSG,%d,%d,%d",1,2,3)   ----------
---------                        or LOG_APPEND("logfile","hello MSG")               ----------
---------------------------------------------------------------------------------------------*/

#define LOG_APPEND(filename,...) zte_log_append(__FILE__,__LINE__,filename,__VA_ARGS__)

#define SYS_CALL(...) zte_system_call(__VA_ARGS__)
#define WCLOG(...) LOG_APPEND(LOG_WIFI_CONTROL_LOG,__VA_ARGS__)  /*for wifi_control*/
#define PDLOG(...) LOG_APPEND(LOG_PPP_DIAL_LOG,__VA_ARGS__)      /*for ppp_dial----*/
#define WEBLOG(...) LOG_APPEND(LOG_GOAHEAD_LOG,__VA_ARGS__)      /*for goahead-----*/
#define WMLOG(...) LOG_APPEND(LOG_WAKEUP_MC_LOG,__VA_ARGS__)     /*for wakeup main control*/
#define LANLOG(...) LOG_APPEND(LOG_ZTE_LAN_LOG,__VA_ARGS__)     /*for lan control*/
#define LIBSOCKETLOG(...) LOG_APPEND(LOG_ZTE_LIBSOCKET_LOG,__VA_ARGS__)     /*for libsocket*/
#define MODCLOG(...) LOG_APPEND(LOG_ZTE_MODC_LOG,__VA_ARGS__)     /*for mode control*/
#define WMSLOG(...) LOG_APPEND(LOG_ZTE_WMS_LOG,__VA_ARGS__)     /*for wms*/
#define PBMLOG(...) LOG_APPEND(LOG_ZTE_PBM_LOG,__VA_ARGS__)     /*for pbm*/
#define ATLOG(...) LOG_APPEND(LOG_ZTE_AT_LOG,__VA_ARGS__)     /*for at server*/
#define CFGLOG(...) LOG_APPEND(LOG_ZTE_CFG_LOG,__VA_ARGS__)     /*for cfg*/
#define ZTENVLOG(...) LOG_APPEND(LOG_ZTE_NV_LOG,__VA_ARGS__)     /*for zte nv*/
#define MCLOG(...) LOG_APPEND(LOG_ZTE_MC_LOG,__VA_ARGS__)     /*for main control*/
#define MDMLOG(...) LOG_APPEND(LOG_ZTE_MDM_LOG,__VA_ARGS__)     /*for mdm*/
#define WANLOG(...) LOG_APPEND(LOG_ZTE_WAN_LOG,__VA_ARGS__)     /*for wan*/
#define QMILOG(...) LOG_APPEND(LOG_ZTE_QMI_LOG,__VA_ARGS__)     /*for qmi*/
#define SHARELOG(...) LOG_APPEND(LOG_ZTE_SHARE_LOG,__VA_ARGS__)     /*for qmi*/
#define DAEMONLOG(...) LOG_APPEND(LOG_ZTE_DAEMON_LOG,__VA_ARGS__)     /*for daemon*/
#define USSDLOG(...) LOG_APPEND(LOG_ZTE_USSD_LOG,__VA_ARGS__)     /*for ussd*/
#define NTPLOG(...) LOG_APPEND(LOG_ZTE_NTP_LOG,__VA_ARGS__)     /*for ntp*/
#define MF80LOG(...) LOG_APPEND(LOG_ZTE_MF80_LOG,__VA_ARGS__)     /*for mf80 adaptor*/
#define PRINTERLOG(...) LOG_APPEND(LOG_ZTE_PRINTER_LOG,__VA_ARGS__)     /*for usb printer*/

void zte_log_append(const char *source_file,const unsigned int line,
                    const char *log_file,const char *fmt,...);
void zte_msg_print(const char *filename,const unsigned int line,const char *fmt,...);
void zte_system_call(const char *fmt,...);


#define ccapp_log(fmt,...) zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s	"fmt"\n", __FUNCTION__, ##__VA_ARGS__)

	
#endif/*_ZTE_LOG_*/
