/***********************************************************************
 *Project       Linux H100
 *Modual        USRLINE
 *FileName      slc_inf.h
 *Description   SLIC module interface 
 *-----------------------------------------------------------------------
 *modify History:
 *
 * Data         author          version         modify description
 * 2004/12/10   jiang.yuelong   1.0             create
 ************************************************************************/
#ifndef _SLIC_INF_H
#define _SLIC_INF_H

#include "112.h"
#include "slic_type.h"

#define SLIC_SUCCESS             (0)
#define SLIC_FAIL                (-1)


DWORD SLIC_Initial(VOID);
VOID SLIC_Release(VOID);
DWORD SLIC_Dev_Init();
DWORD SLIC_ReleasePort(WORD wPort, BYTE bType);
DWORD SLIC_ResetPort(WORD wPort, BYTE bType);
VOID SLIC_DebugLevel(WORD wLevel);
DWORD SLIC_Show_Stat(WORD wPort, BYTE bType);
DWORD SLIC_Show_Err(WORD wFlag);
DWORD SLIC_Port_Lock(WORD wPort, BYTE bType);
DWORD SLIC_Port_UnLock(WORD wPort, BYTE bType);
DWORD SLIC_GetCallStatus(WORD wPort);
DWORD SLIC_FXS_PolarityReverse(WORD wPort);
DWORD SLIC_PolarityReverse(WORD wPort, int is_active);
DWORD SLIC_FXS_StartCollect(WORD wPort);
DWORD SLIC_FXS_StopCollect(WORD wPort);
DWORD SLIC_Play_Signal(WORD wPort, BYTE bType, SIGNAL_DATA *pSig);
DWORD SLIC_Stop_Signal(WORD wPort, BYTE bType);
DWORD SLIC_SelectTimeSlot(WORD wPort, BYTE bType, BYTE bTX, BYTE bRX);
DWORD SLIC_ReleaseTimeSlot(WORD wPort, BYTE bType);
DWORD SLIC_MsgRev(BYTE *bEvent, DWORD *pPayLoad);
DWORD SLIC_MsgClr(VOID);

DWORD SLIC_Cfg_HookLowTime(WORD wPort, WORD wTime);
DWORD SLIC_Cfg_HookHighTime(WORD wPort, WORD wTime);
DWORD SLIC_Cfg_PreHookHighTime(WORD wPort, WORD wTime);
DWORD SLIC_Cfg_FlashLowMinTime(WORD wPort, WORD wTime);
DWORD SLIC_Cfg_FlashLowMaxTime(WORD wPort, WORD wTime);
DWORD SLIC_Cfg_FlashHighFixTime(WORD wPort, WORD wTime);
DWORD SLIC_Cfg_DialLowMinTime(WORD wPort, WORD wTime);
DWORD SLIC_Cfg_DialLowMaxTime(WORD wPort, WORD wTime);
DWORD SLIC_Cfg_DialHighMinTime(WORD wPort, WORD wTime);
DWORD SLIC_Cfg_DialHighFixTime(WORD wPort, WORD wTime);

DWORD SLIC_112TestStart(WriteCmd_t *pCmd);
DWORD SLIC_112TestAbort( WORD wPort, BYTE bType );
DWORD SLIC_112TestRead( WORD wPort, BYTE bType, TestResult_t *pResBuf);

DWORD SLIC_Cfg_Codec(BYTE *pParm);
DWORD SLIC_Read_Codec(BYTE *pParm);
DWORD SLIC_Read_Ram(BYTE *pParm);      
DWORD SLIC_Cfg_Ram(BYTE *pParm);
DWORD SLIC_Start_PCM();
DWORD SLIC_Stop_PCM();
DWORD SLIC_PCM_Set_NB();
DWORD SLIC_PCM_Set_WB();
DWORD SLIC_Read_Codec_ALL(VOID);


#endif /* _SLIC_INF_H */
