#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <stdint.h>
#include "slic_type.h"
#include "slic_inf.h"
#include <linux/volte_drv.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include "voice_lib.h"

typedef struct
{
    WORD    wToneId;    
    WORD    wCadenceCount; 
    
    WORD    wCadence1_rptcnt;                        
    WORD    wCadence1_on;       
    WORD    wCadence1_off;      
    WORD    wCadence1_Freq;      
    WORD    wCadence1_2ndFreq; 
    WORD    wCadence1_Amp;
    
    WORD    wCadence2_rptcnt;
    WORD    wCadence2_on;   
    WORD    wCadence2_off;  
    WORD    wCadence2_Freq;     
    WORD    wCadence2_2ndFreq;  
    WORD    wCadence2_Amp;      
    
    WORD    wCadence3_rptcnt;
    WORD    wCadence3_on;   
    WORD    wCadence3_off;  
    WORD    wCadence3_Freq;     
    WORD    wCadence3_2ndFreq;  
    WORD    wCadence3_Amp;      

    WORD    wCadence4_rptcnt;
    WORD    wCadence4_on;   
    WORD    wCadence4_off;
    WORD    wCadence4_Freq;   
    WORD    wCadence4_2ndFreq;
    WORD    wCadence4_Amp;

    WORD    wDura; 
    BYTE    bRowStatus; 
    BYTE    bReserve;                
}TONE_ATTR;

/*TONE  ID*/

#define     SIGNAL_RING                     (WORD)0x8100        /*  */
#define     SIGNAL_RING_TWO                 (WORD)0x8101        /* 2 */
#define     SIGNAL_RING_THREE               (WORD)0x8102        /* 3 */
#define     SIGNAL_RING_FOUR                (WORD)0x8103        /* 4 */
#define     SIGNAL_RING_LONG                (WORD)0x8104        /* ʱ */

#define     SIGNAL_TONE                     (WORD)0x8200        /*  */
#define     SIGNAL_TONE_TWO                 (WORD)0x8201        /* 2η */
#define     SIGNAL_TONE_THREE               (WORD)0x8202        /* 3η */
#define     SIGNAL_TONE_FOUR                (WORD)0x8203        /* 4η */
#define     SIGNAL_TONE_LONG                (WORD)0x8204        /* ʱ */

TONE_ATTR ToneAttr[] = {
/*                                                                                                                                             
ToneId                          Cadence    Cadence1                Cadence2               Cadence3              Cadence4             Dura    RowStatus Rese*/
{SIGNAL_RING,                    1,        1,200,800,25,0,100,     0,0,0,0,0,0,           0,0,0,0,0,0,          0,0,0,0,0,0,         12000,  1,        0},
{SIGNAL_RING_TWO,                2,        1,100,800,25,0,100,     1,200,800,25,0,100,    0,0,0,0,0,0,          0,0,0,0,0,0,         12000,  1,        0},
{SIGNAL_RING_THREE,              3,        1,100,800,25,0,100,     1,400,800,25,0,100,    1,200,800,25,0,100,   0,0,0,0,0,0,         12000,  1,        0},
{SIGNAL_RING_FOUR,               4,        1,100,800,25,0,100,     1,400,800,25,0,100,    1,300,300,25,0,100,   1,200,800,25,0,100,  12000,  1,        0},
{SIGNAL_RING_LONG,               1,        1,6000,0,25,0,100,      0,0,0,0,0,0,           0,0,0,0,0,0,          0,0,0,0,0,0,         12000,  1,        0},

{SIGNAL_TONE,                    1,        1,40,400,450,0,100,     0,0,0,0,0,0,           0,0,0,0,0,0,          0,0,0,0,0,0,         12000,  1,        0},
{SIGNAL_TONE_TWO,                2,        1,40,400,450,0,100,     1,100,800,450,0,100,   0,0,0,0,0,0,          0,0,0,0,0,0,         12000,  1,        0},
{SIGNAL_TONE_THREE,              3,        1,40,400,450,0,100,     1,100,800,450,0,100,   1,200,800,450,0,100,  0,0,0,0,0,0,         12000,  1,        0},
{SIGNAL_TONE_FOUR,               4,        1,40,400,450,0,100,     1,100,800,450,0,100,   1,300,300,450,0,100,  1,200,800,450,0,100, 12000,  1,        0},
{SIGNAL_TONE_LONG,               1,        1,6000,0,450,0,100,     0,0,0,0,0,0,           0,0,0,0,0,0,          0,0,0,0,0,0,         12000,  1,        0},
};
 #define  VOICE_TEST_CALL_DRV
 #ifdef VOICE_TEST_CALL_DRV
static  int voice_fd = -1;
static  int volte_fd = -1;
#else
T_Voice_Para gsmhwpara = {
   8000,  //8000;16000
    0, //// 0 gsm;1 td;2 wcdma;3 lte
    0//0 hardware dsp;1 soft amr lib	
};

T_Voice_Para tdnbhwpara = {
   8000,  //8000;16000
    1, //// 0 gsm;1 td;2 wcdma;3 lte
    0,//0 amr-nb;1 amr-wb
    0//0 hardware dsp;1 soft amr lib	
};

T_Voice_Para tdnbsfpara = {
   8000,  //8000;16000
    1, //// 0 gsm;1 td;2 wcdma;3 lte
    0,//0 amr-nb;1 amr-wb
    1//0 hardware dsp;1 soft amr lib	
};

T_Voice_Para tdwbsfpara = {
   8000,  //8000;16000
    1, //// 0 gsm;1 td;2 wcdma;3 lte
    1,//0 amr-nb;1 amr-wb
    1//0 hardware dsp;1 soft amr lib	
};
#endif


static VOID DataFormat(SIGNAL_DATA *pSig, TONE_ATTR *pAttr)
{
#if 0
    pSig->wDura = pAttr->wDura;
    pSig->bCadenceNum = pAttr->wCadenceCount;
    pSig->wSignalID = pAttr->wToneId;
    
    pSig->Cadence[0].wCadenceRptCnt  = pAttr->wCadence1_rptcnt;
    pSig->Cadence[0].wCadenceOn = pAttr->wCadence1_on;
    pSig->Cadence[0].wCadenceOff = pAttr->wCadence1_off;
    pSig->Cadence[0].wFreq1 = pAttr->wCadence1_Freq;
    pSig->Cadence[0].wFreq2 = pAttr->wCadence1_2ndFreq;
    pSig->Cadence[0].wAmp = pAttr->wCadence1_Amp;
    
    pSig->Cadence[1].wCadenceRptCnt  = pAttr->wCadence2_rptcnt;
    pSig->Cadence[1].wCadenceOn = pAttr->wCadence2_on;
    pSig->Cadence[1].wCadenceOff = pAttr->wCadence2_off;
    pSig->Cadence[1].wFreq1 = pAttr->wCadence2_Freq;
    pSig->Cadence[1].wFreq2 = pAttr->wCadence2_2ndFreq;
    pSig->Cadence[1].wAmp = pAttr->wCadence2_Amp;
    
    pSig->Cadence[2].wCadenceRptCnt  = pAttr->wCadence3_rptcnt;
    pSig->Cadence[2].wCadenceOn = pAttr->wCadence3_on;
    pSig->Cadence[2].wCadenceOff = pAttr->wCadence3_off;
    pSig->Cadence[2].wFreq1 = pAttr->wCadence3_Freq;
    pSig->Cadence[2].wFreq2 = pAttr->wCadence3_2ndFreq;
    pSig->Cadence[2].wAmp = pAttr->wCadence3_Amp;
    
    pSig->Cadence[3].wCadenceRptCnt  = pAttr->wCadence4_rptcnt;
    pSig->Cadence[3].wCadenceOn = pAttr->wCadence4_on;
    pSig->Cadence[3].wCadenceOff = pAttr->wCadence4_off;
    pSig->Cadence[3].wFreq1 = pAttr->wCadence4_Freq;
    pSig->Cadence[3].wFreq2 = pAttr->wCadence4_2ndFreq;
    pSig->Cadence[3].wAmp = pAttr->wCadence4_Amp;  
#endif
}
static TONE_ATTR* GetToneData(WORD wTid)
{
    WORD i;    
    for (i = 0; i < sizeof(ToneAttr)/sizeof(TONE_ATTR); i++)
    {
        if (wTid == ToneAttr[i].wToneId)
        {
            return &ToneAttr[i];
        }
    }
    return NULL; 
}

static void SLIC_SelfTest(void)
{
    BYTE bBuf[16] = {0,};
    WORD wSize = 0;
    SIGNAL_DATA tSig;
    DWORD dC = 0;
#if 0
    tSig.wDura = 6000;    /*60s */
    tSig.bCadenceNum = 1;
    tSig.wSignalType = USL_RING_SIGNAL;
    tSig.wSignalID = 0x8100;
    tSig.Cadence[0].wCadenceOn = 100; /* 1s */
    tSig.Cadence[0].wCadenceOff = 0; /* no off */
    tSig.Cadence[0].wFreq1 = 25;
    tSig.Cadence[0].wFreq2 = 0;
    tSig.Cadence[0].wAmp = 100;
#endif    
    /* chip test */
    printf("\n check legerity chip");
    bBuf[0] = 0x73;
    wSize = 2;
    SLIC_Read_Codec(bBuf);
    if ((bBuf[0] != 0x2) && (bBuf[1] != 0xb2))
    {
        printf("\n read legerity  ID error"); 
    } else {
        printf("\n read legerity  ID success ID:0x%x 0x%x", bBuf[0], bBuf[1]);
    }
             
    /* ring test -self test mode */
    printf("\n control port 1 ringing ");
    SLIC_Play_Signal(0, 0, &tSig);
    printf("\n press any key to stop port 1 ring");    
    while(!(dC = getchar())) { ;}
    SLIC_Stop_Signal(0, 0); 

    printf("\n control port 2 ringing ");
    SLIC_Play_Signal(1, 0, &tSig);
    printf("\n press any key to stop port 2 ring");  
    while(!(dC = getchar())) { ;}
    SLIC_Stop_Signal(1, 0); 
    
    SLIC_MsgClr();                               
    SLIC_DebugLevel(0);
    return;
}
/*lint -restore*/
/*lint -save -e14*/ 
int main(int argc, char** argv)
{
    SIGNAL_DATA tSig = {0};
    DWORD wRev = 0;    
    WORD wPort = 0;
    WORD wPort_type = 0;
    WORD wTimeSlot = 0;
    DWORD wTid = 0;
    WORD wTime = 0;
    WORD wLevel = 0;
    TONE_ATTR *pToneAttr = NULL;

    wRev = SLIC_Initial();
    if (wRev == SLIC_FAIL)
    {
        printf("\n SLIC initial failed!"); 
        exit(1);
    }
    
    if (argc < 2)
    {
        printf("\n Usage:%s cmd parm...", argv[0]);
        exit(1);    
    }
    
    if (0 == strcmp("reset", argv[1])) /* port reset */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s reset port type", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wPort_type = atoi(argv[3]);
        wRev = SLIC_ResetPort(wPort, wPort_type);        
    } else if (0 == strcmp("slotset", argv[1])) /*time slot set */
    {
        if (argc != 5)
        {
            printf("\n Usage:%s slotset port type timeslot\n", argv[0]);
            exit(1);
        }    
        wPort = atoi(argv[2]);
        wPort_type = atoi(argv[3]);  
        wTimeSlot = atoi(argv[4]);
        wRev = SLIC_SelectTimeSlot(wPort, wPort_type, wTimeSlot, wTimeSlot);
                    
    } else if (0 == strcmp("reverse", argv[1])) /* polarity reverse */
    {
        if (argc != 3)
        {
            printf("\n Usage:%s reverse port\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wRev = SLIC_FXS_PolarityReverse(wPort);            
    } else if (0 == strcmp("startring", argv[1])) /* start ring */
    {
        tSig.signal_type= RING_SIGNAL;
		memcpy(tSig.cid, argv[2], 11);
		printf("slictool startring cid %s", tSig.cid);
        wRev = SLIC_Play_Signal(wPort, SLIC_PORT_TYPE, &tSig);          
    } else if (0 == strcmp("stopring", argv[1])) /* stop ring */
    {
        wRev = SLIC_Stop_Signal(0, SLIC_PORT_TYPE);          
    } else if (0 == strcmp("playtone", argv[1])) /* play tone */
    {
        tSig.signal_type = TONE_SIGNAL;
		if(NULL != argv[2])
		{
			tSig.tone_type = atoi(argv[2]);
		}
		else
		{
			tSig.tone_type = TONE_DIAL;
		}
		printf("tone_type %d\n", tSig.tone_type);
        wRev = SLIC_Play_Signal(0, wPort_type, &tSig);            
    } 
	else if (0 == strcmp("rcvmsg", argv[1])) /* rcvmsg */
    {
        while(1)
    	{
			BYTE	bEvent   = 0;
			DWORD	pPayLoad = 0;
			if (SLIC_FAIL == SLIC_MsgRev(&bEvent, &pPayLoad))
			{
       	     printf("SLIC: Error-->>SLIC_MsgRev Failed\n");
       	     continue;
			}  
			printf("SLIC: SLIC_MsgRev Event %d, payload %x\n", bEvent, pPayLoad);
        }
    } 
	else if (0 == strcmp("stoptone", argv[1])) /* stop tone */
    {
        wRev = SLIC_Stop_Signal(wPort, wPort_type);            
    }else if (0 == strcmp("startpcm", argv[1])) /* stop tone */
    {
        wRev = SLIC_Start_PCM();            
    }  else if (0 == strcmp("stoppcm", argv[1])) /* stop tone */
    {
        wRev = SLIC_Stop_PCM();            
    } else if (0 == strcmp("pcmnb", argv[1])) /* stop tone */
    {
        wRev = SLIC_PCM_Set_NB();            
    } else if (0 == strcmp("pcmwb", argv[1])) /* stop tone */
    {
        wRev = SLIC_PCM_Set_WB();            
    } else if (0 == strcmp("lock", argv[1])) /* lock port */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s lock port type\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wPort_type = atoi(argv[3]);
        wRev = SLIC_Port_Lock(wPort, wPort_type); 
    } else if (0 == strcmp("unlock", argv[1])) /* unlock port */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s unlock port type\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wPort_type = atoi(argv[3]);
        wRev = SLIC_Port_UnLock(wPort, wPort_type);         
    } else if (0 == strcmp("codecset", argv[1]))            /* codecset */
    {
        BYTE bBuf[256];
        BYTE bTmp = 0;
        BYTE bSize = 0;
        DWORD bParm;
        if (argc != 3)
        {
            printf("\n Usage:%s codecset parmstring\n", argv[0]);
            exit(1);
        }        
        sscanf(&(argv[2][bTmp]), "%x", &bParm);

        bBuf[bSize++] = bParm;
		printf("\n codecset addr %x\n", bBuf[0]);
        for (bTmp = 0; argv[2][bTmp]!= 0; bTmp++)
        {
            if (argv[2][bTmp] != ' ')
            {
                printf("\n codecset argv[2][%d] %x\n", bTmp, argv[2][bTmp]);
                continue;
            }
            
            sscanf(&(argv[2][bTmp]), "%x", &bParm);
            bBuf[bSize++] = bParm;
        }
		printf("\n codecset value %x\n", bBuf[1]);
        wRev = SLIC_Cfg_Codec(bBuf);
    } else if (0 == strcmp("codecget", argv[1]))   /* codecget */
    {
        BYTE bBuf[256];
        BYTE bSize = 0;
        DWORD bParm;
        if (argc != 3)
        {
            printf("\n Usage:%s codecget address\n", argv[0]);
            exit(1);
        }        
        sscanf(&(argv[2][0]), "%x", &bParm);
        bBuf[0] = bParm;

        wRev = SLIC_Read_Codec(bBuf);      
    } else if (0 == strcmp("ramset", argv[1]))            //ramset 
    {
        BYTE bBuf[256];
        BYTE bTmp = 0;
        BYTE bSize = 0;
        DWORD bParm;
        if (argc != 3)
        {
            printf("\n Usage:%s ramset parmstring\n", argv[0]);
            exit(1);
        }       
        sscanf(&(argv[2][bTmp]), "%x", &bParm);
        bBuf[bSize++] = (BYTE)bParm;
        bBuf[bSize++] = (bParm>>8)&(0x07);

        for (bTmp = 0; argv[2][bTmp]!= 0; bTmp++)
        {
            if (argv[2][bTmp] != ' ')
            {
                continue;
            }
            
            sscanf(&(argv[2][bTmp]), "%x", &bParm);
            bBuf[bSize++] = (BYTE)bParm;
            bBuf[bSize++] = (bParm>>8)&(0xff);
            bBuf[bSize++] = (bParm>>16)&(0xff);
            bBuf[bSize++] = (bParm>>24)&(0xff);
        }
        wRev = SLIC_Cfg_Ram(bBuf);

    }else if (0 == strcmp("ramget", argv[1]))   //ramget
    {
        BYTE bBuf[256];
        BYTE bSize = 0;
        DWORD dwParm;
        WORD *pAddr = (WORD *)&bBuf[0];
        if (argc != 3)
        {
            printf("\n Usage:%s ramget address\n", argv[0]);
            exit(1);
        }
        sscanf(&(argv[2][0]), "%x", &dwParm);
        *pAddr = (WORD)dwParm;
        printf("read ram %d \n", (int)bBuf);
        wRev = SLIC_Read_Ram(bBuf);
  
    } else if (0 == strcmp("hooklow", argv[1])) /* config hook low time */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s hooklow port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_HookLowTime(wPort, wTime);
    } else if (0 == strcmp("hookhigh", argv[1])) /* config hook high time */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s hookhigh port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_HookHighTime(wPort, wTime);        
    } else if (0 == strcmp("prehookhigh", argv[1])) /* config prehook time */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s prehookhigh port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_PreHookHighTime(wPort, wTime); 
    } else if (0 == strcmp("flashlowmin", argv[1])) /* config flash low min */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s flashlowmin port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_FlashLowMinTime(wPort, wTime);
    } else if (0 == strcmp("flashlowmax", argv[1])) /* config flash low max */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s flashlowmax port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_FlashLowMaxTime(wPort, wTime);
    } else if (0 == strcmp("flashfix", argv[1])) /* config flash high fix */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s flashfix port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_FlashHighFixTime(wPort, wTime);        
    } else if (0 == strcmp("diallowmin", argv[1])) /* config pulse low min */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s diallowmin port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_DialLowMinTime(wPort, wTime);
    } else if (0 == strcmp("diallowmax", argv[1])) /* config pulse low max */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s diallowmax port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_DialLowMaxTime(wPort, wTime);        
    } else if (0 == strcmp("dialhighmin", argv[1])) /* config pulse high min */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s dialhighmin port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_DialHighMinTime(wPort, wTime);      
    } else if (0 == strcmp("dialhighfix", argv[1])) /* config pulse high fix */
    {
        if (argc != 4)
        {
            printf("\n Usage:%s dialhighfix port time\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wTime = atoi(argv[3]);
        wRev = SLIC_Cfg_DialHighFixTime(wPort, wTime);         
    } else if (0 == strcmp("debuglvl", argv[1])) /* config debug level */
    {
        if (argc != 3)
        {
            printf("\n Usage:%s debuglvl level\n", argv[0]);
            exit(1);
        }
        wLevel = atoi(argv[2]);
        SLIC_DebugLevel(wLevel);  
    } else if (0 == strcmp("selftest", argv[1])) /* self test */
    {
        if (argc != 2)
        {
            printf("\n Usage:%s selftest\n", argv[0]);
            exit(1);
        }
        SLIC_SelfTest();                      
    } 
    else if (0 == strcmp("leg", argv[1])) /* chip initial  */
    {

        if (argc != 3)
        {
            printf("\n Usage:%s leg num(1:init,other num :no init)\n", argv[0]);
            exit(1);
        }
        wPort=atoi(argv[2]);
        if(wPort==1)
        {
            wRev = SLIC_Dev_Init();
            if(wRev==SLIC_FAIL) 
                printf("leg init fail!!\n");
            else
                printf("leg init success!\n");
        }
        else
            exit(1);
       
    }
    else if (0 == strcmp("test", argv[1])) /* 112 test start */
    {
        WriteCmd_t Cmd = {0};
        if (argc != 6)
        {
            printf("\n Usage:%s test port type item\n", argv[0]);
            exit(1);
        }

        Cmd.port        = atoi(argv[2]);
        Cmd.port_type   = atoi(argv[3]);  
        Cmd.item        = atoi(argv[4]);
        Cmd.obligate    = atoi(argv[5]);
        wRev = SLIC_112TestStart((WriteCmd_t *)&Cmd);
    }
    else if (0 == strcmp("readreg", argv[1]))   /* codecget */
    {
        BYTE bBuf[256];
        BYTE bSize = 1;
        BYTE loopi;
        if (argc != 4)
        {
            printf("\n Usage:%s codecget port type address size\n", argv[0]);
            exit(1);
        }
        wPort = atoi(argv[2]);
        wPort_type = atoi(argv[3]);
        
        for(loopi=0; loopi<=126; loopi++)
        {
            bBuf[0] = loopi;
            wRev = SLIC_Read_Codec(bBuf);
            if (wRev != SLIC_SUCCESS) 
                break;
        }    
    }
    else if (0 == strcmp("readram", argv[1])) 
    {
        BYTE bSize = 4;  //siliconlab 32176 readram 28bit once   
        WORD loopi;      
        union 
        {
            DWORD wReturnvalue;
            WORD wAddress_on10;
        } xchange;
        
        if (argc != 4)
        {
            printf("\n Usage:%s readram port port_type reg_10\n", argv[0]);
            exit(1);
        }
        
        wPort = atoi(argv[2]);
        wPort_type = atoi(argv[3]); 
        
        printf("____show all rams_____ \n");
        for(loopi=0; loopi<=1565; loopi++)
        {
            xchange.wAddress_on10 = loopi;
            wRev = SLIC_Read_Ram((BYTE *) &xchange.wAddress_on10);
            if (wRev != SLIC_SUCCESS) 
                break;
        }
    }
	else if (0 == strcmp("voice_test", argv[1])) /* rcvmsg */
    {
        #ifdef VOICE_TEST_CALL_DRV
          int ret = 0;
   	   // WORD codecpath = 0;
   	   // WORD onoff = 0;		
	    T_Voice_Para para = {0};
	     int slicflag = 0;
           T_ZDrvVoice_Cfg cfg = {8000,1,160,16,0};
           T_ZDrvVoice_Cfg cfgwb = {16000,1,320,16,0};
	   
	    para.codec_path = atoi(argv[2]);//0 dsp ;1 soft
	    para.mode = atoi(argv[3]); // 0gsm,1 td;2 wcdma
           para.codec_type = atoi(argv[3]); // 0 amr-nb;1 amr-wb	    
	   // onoff = atoi(argv[4]); // 0 off;1 on
	    printf("slctool: voice_test  codec_path=%d,mode=%d!\n",para.codec_path,para.mode);

   	
    
    		voice_fd = open("/dev/voice_device", O_RDONLY);
    	    if(voice_fd < 0)
    	    {
    		    printf("slctool: open voice device error.\n");
    			exit(1); //cov m
    		}
          //open volte

    		volte_fd = open("/dev/volte_device", O_RDONLY);
    	       if(volte_fd < 0)
    	       {
    		        printf("slctool: open volte device error.\n");   
					exit(1); //cov m
			   }

          //ret = ioctl(volte_fd,VOLTE_IOCTL_SET_CFG,&cfg);
         // printf("slctool: volte set cfg fd=%d,ret=%d.\n",volte_fd,ret);


			   
          ret = ioctl(volte_fd,VOLTE_IOCTL_GET_SLIC_USE_FLAG,&slicflag);
          printf("slctool: volte get slic flag=%d fd=%d,ret=%d.\n",slicflag,volte_fd,ret);

          ret = ioctl(volte_fd,VOLTE_IOCTL_SET_CFG,&cfg);

           close(volte_fd);

    		volte_fd = open("/dev/volte_device", O_RDONLY);
    	       if(volte_fd < 0)
    	       {
    		        printf("slctool: open volte device error.\n");   
					exit(1); //cov m
			   }

          //ret = ioctl(volte_fd,VOLTE_IOCTL_SET_CFG,&cfg);
         // printf("slctool: volte set cfg fd=%d,ret=%d.\n",volte_fd,ret);
          ret = ioctl(volte_fd,VOLTE_IOCTL_GET_SLIC_USE_FLAG,&slicflag);
          printf("slctool: volte get slic flag=%d fd=%d,ret=%d.\n",slicflag,volte_fd,ret);

          ret = ioctl(volte_fd,VOLTE_IOCTL_SET_CFG,&cfgwb);

           close(volte_fd);

          ret = ioctl(voice_fd,VOICE_IOCTL_START,&para);
          printf("slctool: voice start fd=%d,ret=%d.\n",voice_fd,ret);

              usleep(1000000);
   
          printf("slctool: bef voice stop fd=%d,ret=%d.\n",voice_fd,ret);
     
          ret = ioctl(voice_fd,VOICE_IOCTL_STOP,&para);
          printf("slctool: voice stop fd=%d,ret=%d.\n",voice_fd,ret);
		  
             close(voice_fd);
 

	    printf("voice test !\n");
	#else

          int ret = 0;
          int sel;
          T_Voice_Para *para;
	   sel = atoi(argv[2]);//0 gsm  ;1 tdnbhw;2tdnbsf ;3tdwbsf
    	  if (sel == 0){
	       para = &gsmhwpara;	
    	  }
	  else if(sel == 1){
	       para = &tdnbhwpara;
	  }	
	  else if(sel == 2){
	       para = &tdnbsfpara;	

	  }		
	  else if(sel == 3){
             para = &tdwbsfpara;	
	  }
	  else{
            printf("voice lib test invalid para\n");
            exit(1);
        }
       ret = voice_open(para);
       printf("slctool: voice_open,ret=%d.\n",ret);
              usleep(1000000);

	   
       ret = voice_close(para);
       #endif


    }
    else if (0 == strcmp("vploop", argv[1])) 
    {
          int ret = 0;

	     int path = 0;	   
	     path = atoi(argv[2]);//0 hanset ;1 sp;2 headset;255 off        
            printf("slictool vploop path=%d \n",path);
            if((path >=0)&&(path <=2)){
		    ret = SLIC_PCM_Set_NB();
		    if (ret != 0)
		    {
		        printf("SLIC_PCM_Set_NB Error ret=%d!\n",ret); 
		        exit(1);
		    }		
			ret = SLIC_Start_PCM();
		     if (ret != 0)
		    {
		        printf("SLIC_Start_PCM Error ret=%d!\n",ret); 
		        exit(1);
		    }			 
	     }
	     else if(path == 255){
		    ret = SLIC_Stop_PCM();	 
		     if (ret != 0)
		    {
		        printf("SLIC_Stop_PCM Error ret=%d!\n",ret); 
		        exit(1);
		    }				 
	           SLIC_Release();
				
	     }			

            ret = voice_Vploop(&path);
	     if (ret != 0)
	    {
	        printf("vploop Error ret=%d!\n",ret); 
	        exit(1);
	    }	
 
    }
	
    else
    {
        printf("not support!\n");    
    }   

    if (wRev != SLIC_SUCCESS)
    {
        printf("\n Run Error!\n"); 
        exit(1);
    }
    
    SLIC_Release();
    return 0;
}
/*lint -restore*/

