/***********************************************************************
 *Project       Linux H100
 *Modual        USRLINE
 *FileName      slc_type.h
 *Description   SLIC module interface 
 *-----------------------------------------------------------------------
 *modify History:
 *
 * Data         author          version         modify description
 * 2005/4/4     jiang.yuelong   1.0             create
 ************************************************************************/
#ifndef _SLIC_TYPE_H
#define _SLIC_TYPE_H
/*lint -save -e18*/
typedef void                VOID;
typedef unsigned char       BYTE;
typedef unsigned short      WORD;
typedef unsigned int        DWORD;
typedef int                 LONG;
typedef unsigned char*      LPSTR;
typedef char                S8;

typedef enum {
    SLIC_UNKNOWN_CMD           = -1, /* unknow cmd */

	/* modified cmd*/
    SLIC_DEV_INIT    = 0,         /* 0 ʼSLICоƬ */
    SLIC_MSG_REV,                 /* 1 ϱ¼*/
    SLIC_TEST,                    /*2 ʼ */
    SLIC_SIGNAL_START,            /* 3 ʼ */
    SLIC_SIGNAL_STOP,             /*4  ֹͣ */
    SLIC_PCM_OPEN,                /* 5 PCMͨ· */  
    SLIC_PCM_CLOSE,               /* 6 رPCMͨ· */
	SLIC_PCM_SET_NB,				 /* 7 խƵ */
	SLIC_PCM_SET_WB,				 /* 8 ÿƵ */

	/* original cmd*/
    /* below cmd is used for ulc or slctool */
    SLIC_INF_PRECFG,                 /* 9 */
    SLIC_NOTUSED,                    /*10  for ioctl #define FIGETBSZ   _IO(0x00,2) */
    SLIC_PORT_RESET,                 /* 11 */
    SLIC_MSG_CLR,                    /* 12 */
    SLIC_DIAL_START,                 /* 13 */
    SLIC_DIAL_STOP,                  /*14  */
    SLIC_TIMESLOT_SET,               /*15 */
    SLIC_TIMESLOT_RELEASE,           /* 16 */
    SLIC_PORT_LOCK,                  /*  17*/
    SLIC_PORT_UNLOCK,                /*  18*/
    SLIC_FSK_START,                  /* 19 */
    SLIC_FSK_STO,                    /*20 */
    SLIC_POLARITY_REVERSE,           /*21  */
    SLIC_DTMFCID_START,              /* 22 */
    SLIC_LINE_TEST_START,            /* 23 start line test */
    SLIC_LINE_TEST_ABORT,            /* 24 stop line test */
    SLIC_LINE_TEST_READ,             /*25  read line test result */
    SLIC_TIMEPARA_CFG,               /* 26 config the time para used for hookonhookoffpulse dial and flash */
    SLIC_ELECTRIC_CFG,               /* 27 */
    
    /* below cmd is only used for slctool for debug */
    SLIC_DEBUG_LEVEL,                 /*28set the message print level */
    SLIC_CFG_HOOK_LOWLEN,             /* 29config the hookon time */
    SLIC_CFG_HOOK_HIGLEN,             /* 30 */   
    SLIC_CFG_FLASH_LMIN,              /*  31*/    
    SLIC_CFG_FLASH_LMAX,              /* 32 */    
    SLIC_CFG_FLASH_HFIX,              /*33  */    
    SLIC_CFG_DIAL_HMIN,               /*34  */     
    SLIC_CFG_DIAL_HMAX,               /* 35 */     
    SLIC_CFG_DIAL_LMIN,               /* 36*/     
    SLIC_CFG_DIAL_LMAX,               /*37  */     
    SLIC_CFG_RINGCEASE,               /*  38*/      
    SLIC_CFG_PREHOOK_HIGLEN,          /* 39 */
    SLIC_CFG_QUEUE_DELAY,             /*40  */
    SLIC_CODEC_GET,                   /*41 read the content of reg xxx */
    SLIC_CODEC_SET,                   /* 42wrtie value X to reg xxx */
    SLIC_RAM_GET,                     /* 43read the content of ram xxx */
    SLIC_RAM_SET,                     /* 44wrtie value X to ram xxx */ 
    SLIC_CODEC_GETALL,                /*45 read all the reg */
    SLIC_RAM_GETALL,                  /*46 read all the ram */      
    SLIC_GET_CHIP_NAME,               /*47  */
    
    SLIC_IOCTL_CMD_MAX,     
} SLIC_IOCTL_CMD;
    
typedef enum {
    EV_UNKONWN            = -1,
	EV_FXS_HOOKON,			  /*һ¼*/
	EV_FXS_HOOKOFF,			  /*ժ¼*/
	EV_FXS_COLLECT_DIG, 	  /*⵽ڲɼ*/
	EV_FXS_FLASH,			  /*Ĳ¼*/

    EV_FXS_FIRST_RING,
    EV_FXS_SIGNAL_CEASE,
    EV_FXO_RING_START,
    EV_FXO_RING_STOP,
    EV_FXS_PRE_HOOKOFF,
    EV_FXS_FIRST_TONE,
    EV_FXS_TEST_DONE,
    EV_FXS_TEST_ERROR,
    EV_LT_RINGER_REN
} SLIC_EVENT;

typedef enum
{
    HOOKON,
    HOOKOFF
} USL_HOOKSTATE;

  
typedef enum {
    PORT_TYPE_FXS = 0,
    PORT_TYPE_FXO = 1
} SLIC_PORT_TYPE;

#define SLIC_PORT_TYPE PORT_TYPE_FXS
#define DAA_PORT_TYPE  PORT_TYPE_FXO
    
typedef struct
{
    BYTE bTx;
    BYTE bRx;
} TIME_SLOT;

typedef union
{
    WORD wTime;
    WORD wLevel;
    WORD wImpe;
    TIME_SLOT stTimeSlot;
} SLIC_PARA_UNION;
    
typedef struct
{   
#if 0
    WORD wPort; 
    BYTE bPortType;
    SLIC_PARA_UNION unPara;
#endif
    VOID *pData;
    DWORD dwSize;
} SLIC_IOCTL_DATA;

typedef struct
{
    WORD     wCadenceRptCnt;
    WORD     wCadenceOn;
    WORD     wCadenceOff;
    WORD     wFreq1;
    WORD     wFreq2;
    WORD     wAmp;
} CANDENCE_ATTR;

typedef enum {
    RING_SIGNAL = 0,
    TONE_SIGNAL = 1    
} SLIC_SIGNAL_TYPE;

typedef  enum
{
	TONE_DIAL,                /*  */
	TONE_BUSY,                /* æ */
	TONE_RINGBACK,            /*  */
	TONE_CONGESTION,          /* */
	TONE_CW,                  /* еȴ*/
	TONE_TKY,                 /* Х*/
	TONE_SERVICE_SUCCESS,     /* óɹ */
	TONE_SERVICE_FAIL,        /* ʧ */
	/* չ */
	TONE_MAX,
} TONE_TYPE; 

typedef struct
{
	SLIC_SIGNAL_TYPE	signal_type; 
	/* TONE_SIGNAL ʾTONE */
	/* RING_SIGNAL ʾ */
	char	   cid[32]; 			 /* ʾ */
	TONE_TYPE  tone_type;		  /* tone*/
	char  date_time[32];
} SIGNAL_DATA;

typedef struct
{
    //WORD wPort;
    BYTE  bMsgId;
    DWORD dPayLoad;
} MSG_DATA;

typedef struct
{
    BYTE bCusRingVpk;      
    BYTE bCusDcVol;      
    BYTE bCusDcLoopCurr;   
    BYTE bScene;
    BYTE bChange;
}ELECTRIC_CFG_CUSTOMIZED;

#define ELEC_HOOKON_VOLTAGE (1<<0)
#define ELEC_LOOP_CURRENT   (1<<1)
#define ELEC_RING_VPK       (1<<2)

enum {
	DB_SLIC_SINGLEPHONE_SHORTLOOP = 0,
	DB_SLIC_MULTIPHONES_SHORTLOOP = 1,
	DB_SLIC_LONGLOOP = 2,
	DB_SLIC_ORIGINAL_FACTORY = 3,
	DB_SLIC_CUSTOMIZED = 4
};

#ifdef USE_SLIC_TW
typedef unsigned char   uint8;
/** Transmit/Receive Timeslot setting (timeslot and control) */
typedef struct VpOptionTimeslotType {
    uint8 tx;   /**< 8-bit TX timeslot */
    uint8 rx;   /**< 8-bit RX timeslot */
} VpOptionTimeslotType;
#endif
/*lint -restore*/
#endif /* _SLIC_TYPE_H */
