/************************************************************************
*ܽܣڹܻapദAP\CP˼USB\Tcardչatat_ctlʱ
*ˣ
*ˣ
*޸գ
*޸ݣ
*汾ţ
************************************************************************/
#if (APP_OS_TYPE == APP_OS_LINUX)
#include "at_msg.h"
#include "at_com.h"
#include "at_context.h"
#include "ext_dev_func.h"
#include "ext_cmux_func.h"

//add for cmux
#include <sys/socket.h>
#include <linux/if.h>
#include <linux/gsmmux.h>
#include <poll.h>
#include <termios.h>
#include <limits.h>

#define OPENECHO  1  //򿪻Թ
#define CLOSEECHO 0  //رջԹ
#define USB_GPIO_DETECT_ENABLE_EXT          "/sys/dwc_usb/usbconfig/gpio_detect"

static int writefile(char*path, char*buf, unsigned len)
{
    FILE *fp;
    int rtv;
    if((fp=fopen(path,"w"))==NULL)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[ext_dev_fun] open file %s error.\n",path);
        return -1;
    }
    rtv = fwrite(buf,len,1, fp);
    fclose(fp);
    return rtv;
}


// USB˿Ϣ
T_PCS_USB_INFO s_tUsbInfo =
{
    '0',     // print prompt after receiving
     0,      // baudrate: 0
    '8',     // databit: 8
    '0',     // debug: off
    '0',     // echo: off
    '0',     // flow control: software
    '0',     // default tty: COM1
    '0',     // parity: none
    '1',     // stopbit: 1
     0       // reserved
};


// תת
static int32_t iFnConvbaud(int32_t iBaudrate)
{
    //PC_SERVER_LOG();

    switch(iBaudrate)
    {
        case 2400:
            return B2400;
        case 4800:
            return B4800;
        case 9600:
            return B9600;
        case 19200:
            return B19200;
        case 38400:
            return B38400;
        case 57600:
            return B57600;
        case 115200:
            return B115200;
        default:
            return B9600;
    }
}

// ʷתת
static int32_t iFnBaudconv(int32_t Baudrate)
{
    switch(Baudrate)
    {
        case B2400:
            return 2400;
        case B4800:
            return 4800;
        case B9600:
            return 9600;
        case B19200:
            return 19200;
        case B38400:
            return 38400;
        case B57600:
            return 57600;
        case B115200:
            return 115200;
        default:
            return 9600;
    }
}

// ö˿ϢiFdCom: ļ, ptPortInfo: õĶ˿Ϣ
void vFnSetUsbInfo(int32_t iFdCom, const PT_PCS_USB_INFO ptPortInfo, USB_PORT_MODE usbPortMode)
{
    struct termios tOldTermios = {0}, tNewTermios = {0};
    int32_t iBaudrate = 0;
    char cDatabit = 0, cStopbit = 0, cParity = 0, cFctl = 0;

    //PC_SERVER_LOG();

    bzero(&tOldTermios, sizeof(tOldTermios));
    bzero(&tNewTermios, sizeof(tNewTermios));
    cfmakeraw(&tNewTermios);
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions
    /*------------ö˿----------------*/
	if(usbPortMode == AUTO_MODE)
	{
	    iBaudrate = cfgetispeed(&tOldTermios);
	}
	else
	{
        iBaudrate = iFnConvbaud(ptPortInfo->iBaudrate);
        tcflush(iFdCom, TCIOFLUSH);
        cfsetispeed(&tOldTermios, iBaudrate); //봮˲
        cfsetospeed(&tOldTermios, iBaudrate); //봮˲
        if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //, TCSANOW: ɸıЧ
        {
            return;
        }
        tcflush(iFdCom, TCIOFLUSH);
        return;
	}
    cfsetispeed(&tNewTermios, iBaudrate); //봮˲
    cfsetospeed(&tNewTermios, iBaudrate); //봮˲
    tNewTermios.c_cflag |= CLOCAL;       //ģʽ, ֤򲻻Ϊ˿ڵռ
    tNewTermios.c_cflag |= CREAD;        //ģʽ, ʹܶ˿ڶȡ
    // ģʽ, flow control
    cFctl = ptPortInfo->cFctl;
    switch(cFctl)
    {
        case '0':
            {
                tNewTermios.c_cflag &= ~CRTSCTS;        //no flow control
            }break;
        case '1':
            {
                tNewTermios.c_cflag |= CRTSCTS;         //hardware flow control
            }break;
        case '2':
            {
                tNewTermios.c_iflag |= IXON | IXOFF | IXANY;    //software flow control
            }break;
        default:
            {
                break;
            }
    }
    // ģʽ, data bits
    tNewTermios.c_cflag &= ~CSIZE; //ģʽ, ַСλ
    cDatabit = ptPortInfo->cDatabit;
    switch(cDatabit)
    {
        case '5':
            tNewTermios.c_cflag |= CS5;
            // lint -fallthrough
        case '6':
            tNewTermios.c_cflag |= CS6;
            // lint -fallthrough
        case '7':
            tNewTermios.c_cflag |= CS7;
            // lint -fallthrough
        default:
            tNewTermios.c_cflag |= CS8;
    }
    // ģʽ parity check
    cParity = ptPortInfo->cParity;
    switch(cParity)
    {
        case '0':
            {
                tNewTermios.c_cflag &= ~PARENB; //no parity check
            }break;
        case '1':
            {
                tNewTermios.c_cflag |= PARENB;  //odd check
                tNewTermios.c_cflag &= ~PARODD;
            }break;
        case '2':
            {
                tNewTermios.c_cflag |= PARENB;  //even check
                tNewTermios.c_cflag |= PARODD;
            }break;
        default:
            {
                break;
            }
    }
    // ģʽ, stop bits
    cStopbit = ptPortInfo->cStopbit;
    if('2' == cStopbit)
    {
        tNewTermios.c_cflag |= CSTOPB;
    }
    else
    {
        tNewTermios.c_cflag &= ~CSTOPB;
    }
    // other attributions default
    tNewTermios.c_oflag &= ~OPOST;            //ģʽ, ԭʼ
    tNewTermios.c_cc[VMIN] = 1;               //ַ, ҪȡַС
    tNewTermios.c_cc[VTIME] = 1;              //ַ, ȡһַĵȴʱ䣬unit: (1/10)second
    tcflush(iFdCom, TCIFLUSH);                //ݿԽ,
    tcsetattr(iFdCom, TCSANOW, &tNewTermios); //, TCSANOW: ɸıЧ
    tcgetattr(iFdCom, &tOldTermios);
}

static int32_t vFnPortEchoType(int32_t fdcom, int32_t echoType)
{
	struct termios termios_old;
	int32_t setResult = 0;
    
	bzero(&termios_old, sizeof(termios_old));
	tcgetattr(fdcom, &termios_old);         //get the serial port attributions
	/*------------ö˿----------------*/
    if(echoType == OPENECHO)
    {
        termios_old.c_lflag |= ECHO;          //ģʽû
        //termios_old.c_lflag |= ECHONL;
    }
    else
    {
        termios_old.c_lflag &= ~ECHO;          //ģʽرջ
        //termios_old.c_lflag &= ~ECHONL;
    }
	
	tcflush(fdcom, TCIFLUSH);           //ݿԽ,
	setResult = tcsetattr(fdcom, TCSANOW, &termios_old);  //, TCSANOW: ɸıЧ
	return setResult;
}

int ziprSet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    char*  at_str = NULL;
    int32_t iBaudrate = 0;
    char strAtReplyCmd[AT_CMD_MAX] = {0};
	
	if(at_paras==NULL)
   		softap_assert("ziprSet_req:at_paras is null");
		
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &iBaudrate, &at_str);
    at_print(AT_DEBUG,"ziprSet_rsq:iBaudrate == %d\n", iBaudrate);
	if (iBaudrate < 0 || iBaudrate > INT_MAX-1) //kw 3
		iBaudrate = 0;
	s_tUsbInfo.iBaudrate = iBaudrate;
	sleep(0.002);
    vFnSetUsbInfo(at_fd, &s_tUsbInfo, SET_MODE);
    sprintf(strAtReplyCmd,"%d", iBaudrate);
	*res_msg = at_query_result_build("IPR",strAtReplyCmd);
	*res_msglen = strlen(*res_msg);

    return AT_END;
}

int ziprGet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    struct termios tOldTermios = {0};
    int32_t iBaudrate = 0;
    char strAtReplyCmd[AT_CMD_MAX] = {0};

    tcgetattr(at_fd, &tOldTermios); // get the serial port attributions
    iBaudrate = iFnBaudconv(cfgetispeed(&tOldTermios));

    sprintf(strAtReplyCmd,"%d", iBaudrate);	
	*res_msg = at_query_result_build("IPR",strAtReplyCmd);
	*res_msglen = strlen(*res_msg);
	
    return AT_END;
}

int zsetUsb_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	int32_t usbMode = -1;
    char	msgBuf[10] = { 0 };
    char*  	at_str = NULL;
	
    if(at_paras==NULL)
		softap_assert("zsetUsb_req:at_paras is null");
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &usbMode, &at_str);
    at_print(AT_DEBUG,"zsetUsb_req:usbMode == %d\n", usbMode);

    if(!is_at_cmd_end(at_str))
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID); 
		*res_msglen = strlen(*res_msg);
		return AT_END;
    }
	
	if(usbMode != 0 && usbMode != 1)
	{
        *res_msg = at_err_build(ATERR_PARAM_INVALID); 
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
    
	snprintf(msgBuf,sizeof(msgBuf)-1,"%d",usbMode); 
    int result = ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_USBCFGMNG, MSG_CMD_USBMOD_SETREQ, sizeof(msgBuf), msgBuf,0);
    at_print(AT_DEBUG,"result == %d\n", result);
	if(result != 0)
	{
        *res_msg = at_err_build(ATERR_PROC_FAILED); 
		*res_msglen = strlen(*res_msg);
		return AT_END;	
	}
	
	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);
	return AT_END;	
}

int ate_req_rcv_act(char *at_paras,int at_fd,struct at_context *context)
{
    int32_t setResult = 0;

    if(atoi(at_paras) == 0 || atoi(at_paras) == 1)
    {
//#ifdef GUODIAN
        if(g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN)
        {
		    at_write(at_fd, "\r\nOK\r\n", strlen("\r\nOK\r\n"));
        }
        else
        {
//#else
            if(atoi(at_paras) == 0)
                setResult = vFnPortEchoType(at_fd, CLOSEECHO);
            else
                setResult = vFnPortEchoType(at_fd, OPENECHO);
            
            if(setResult != 0)
            {
                at_write(at_fd, "\r\nERROR\r\n", strlen("\r\nERROR\r\n"));
            }
            else
            {
                at_write(at_fd, "\r\nOK\r\n", strlen("\r\nOK\r\n"));
            }
        }
//#endif
        return AT_END;
    }
    return AT_CONTINUE;
}


int zudiskstat_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{	
    at_print(AT_ERR, "Enter zudiskstat_req\n");
	*res_msg = malloc(AT_CMD_PREFIX);
    assert(*res_msg!=NULL);
    memset(*res_msg, 0, AT_CMD_PREFIX);
    sprintf(*res_msg, "AT+ZUDISKSTAT=%s\r", at_paras);
    at_print(AT_ERR, "*res_msg:%s, len: %d\n", (char *)(*res_msg), strlen(*res_msg));
	*res_msglen = strlen(*res_msg);
	return AT_CONTINUE;	
}

int zudiskstat_rsp( void *rsp_msg, void **ret, int *retlen)
{
    *ret = malloc(strlen(rsp_msg)+1);
    assert(*ret!=NULL);
    memset(*ret,0,strlen(rsp_msg)+1);
    memcpy(*ret,rsp_msg,strlen(rsp_msg));
	*retlen = strlen(*ret);
    return AT_END;
}

char *zusbStat_req(void *msg,struct at_context *context)
{
    char *at_next=malloc(AT_CMD_PREFIX);
    assert(at_next!=NULL);
    memset(at_next,0, AT_CMD_PREFIX);
    
    snprintf(at_next, AT_CMD_PREFIX, "AT+USBINQ=%s\r\n", ((MSG_BUF *)msg)->aucDataBuf);
    return at_next;
}

//APNV
int zaprest_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    int32_t restMode = 0;
    char*  at_str = NULL;
	
    if(at_paras==NULL)
		softap_assert("zaprest_req:at_paras is null");
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &restMode, &at_str);
    at_print(AT_DEBUG,"zaprest_req:restMode == %d\n", restMode);

    if(!is_at_cmd_end(at_str))
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID); 
		*res_msglen = strlen(*res_msg);
		return AT_END;
    }

	//WiFiṩĽӿ,apnv
	if(restMode==1)
    {   
        //nv_clear(NV_RT2860);
		sc_cfg_reset();
    }
    
	*res_msg = at_ok_build();	
	*res_msglen = strlen(*res_msg);

	return AT_END;
}

int zflowcontrolset_req(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	int cFctl = -1;
	void *p[1] = {&cFctl};

    parse_param2("%d", at_paras, p);
    at_print(AT_NORMAL,"zflowcontrolset_req:cFctl = %d\n", cFctl);

	switch(cFctl)
	{
		case 0://ر
		{
			//sc_cfg_set("uart_control","1");
			sc_cfg_set("uart_ctstrs_enable","");
			sc_cfg_set("uart_softcontrol_enable","");
			*res_msg = at_ok_build();
			*res_msglen = strlen(*res_msg);
			sc_cfg_save();
			ipc_send_message(MODULE_ID_AT_CTL,MODULE_ID_MAIN_CTRL, MSG_CMD_RESTART_REQUEST, 0, NULL,0);
			break;
		}
		case 1://Ӳ
		{
			//sc_cfg_set("uart_control","1");
			sc_cfg_set("uart_ctstrs_enable","1");
			sc_cfg_set("uart_softcontrol_enable","");
			*res_msg = at_ok_build();
			*res_msglen = strlen(*res_msg);
			sc_cfg_save();
			ipc_send_message(MODULE_ID_AT_CTL,MODULE_ID_MAIN_CTRL, MSG_CMD_RESTART_REQUEST, 0, NULL,0);
			break;
		}
		case 2://
		{
			sc_cfg_set("uart_ctstrs_enable","");
			sc_cfg_set("uart_softcontrol_enable","1");
			*res_msg = at_ok_build();
			*res_msglen = strlen(*res_msg);
			sc_cfg_save();
			ipc_send_message(MODULE_ID_AT_CTL,MODULE_ID_MAIN_CTRL, MSG_CMD_RESTART_REQUEST, 0, NULL,0);
			break;
		}
		default:
		{
			*res_msg = at_err_build(ATERR_PARAM_INVALID);
			*res_msglen = strlen(*res_msg);
			break;
		}
	}
	return AT_END;
}

int zSetgpio_detect_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    char*  at_str = NULL;
    int32_t set_value = 0;
	int ret = 0;
	if(at_paras==NULL)
   		softap_assert("zSetgpio_detect_req:at_paras is null");
		
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &set_value, &at_str);
    at_print(AT_DEBUG,"zSetgpio_detect_req:set_value = %d\n", set_value);

    if(!is_at_cmd_end(at_str))
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID); 
		*res_msglen = strlen(*res_msg);
		return AT_END;
    }
	
	if(set_value < 0 || set_value > 1)
	{
        *res_msg = at_err_build(ATERR_PARAM_INVALID); 
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
	sc_cfg_set("usb_gpio_detect", (set_value == 1) ? "1" : "0");
	
	sc_cfg_save();
	//write this attr, 
	ret = writefile(USB_GPIO_DETECT_ENABLE_EXT, (set_value == 1) ? "1" : "0", 1);
	if(ret < 0)
		 at_print(AT_DEBUG,"zSetgpio_detect_req:set attr fail \n");
	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);

    return AT_END;
}

int zGetgpio_detect_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	char gpio_detect[4] = {0};

	sc_cfg_get("usb_gpio_detect",gpio_detect,sizeof(gpio_detect));
	
	*res_msg = at_query_result_build("gpio_detect",gpio_detect);
	
	*res_msglen = strlen(*res_msg);
	
    return AT_END;
}

int  ext_dev_ser_regist()
{   
    register_serv_func2("ZAPRESET=",0,0,0,zaprest_req,NULL);
	
#ifndef USE_CAP_SUPPORT
	//ATEԣATE0ATE1ڼغֱӴ󷵻ؽ͸Эջ
	register_fwd_func("ate",ate_req_rcv_act,NULL,NULL);

	//̶úͲѯ
	register_serv_func2("ipr=",0,0,0,ziprSet_req,NULL);	
	register_serv_func2("ipr?",0,0,0,ziprGet_req,NULL);
#endif
    //ģUSB    
	register_serv_func2("zsetusb=",MODULE_ID_USBCFGMNG,MSG_CMD_USBMOD_SETREQ,0,zsetUsb_req,NULL);
#ifndef USE_CAP_SUPPORT
	//CMUXģʽл
	register_serv_func2("cmux=",MODULE_ID_DRVCOMMNG,MSG_CMD_CMUX_SET_REQ,MSG_CMD_CMUX_SET_RSP,zcmuxSet_req,zcmuxSet_rsp);
#endif
	//
	register_serv_func2("ifc=",0,0,0,zflowcontrolset_req,NULL);

	//GPIOusb
	register_serv_func2("gpio_detect=",0,0,0,zSetgpio_detect_req,NULL);	
	register_serv_func2("gpio_detect?",0,0,0,zGetgpio_detect_req,NULL);	
	return 0;
}

void ext_dev_regist_init()
{
	//intercore_ext_clt_regist();
	ext_dev_ser_regist();
	
}
#endif

